/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.runtime;

import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.osgi.framework.Bundle;

public class BundleBrowser {
    public static final IScoutLogger LOG = ScoutLogManager.getLogger(BundleBrowser.class);
    private final Bundle m_bundle;
    private final String m_packagePath;
    private HashSet<String> m_set;
    private String m_prefix;
    private boolean m_doubleCheckPrefix;
    boolean m_includeInnerTypes;
    boolean m_includeSubtree;

    public BundleBrowser(String symbolicName, String packageName) {
        this.m_bundle = Platform.getBundle((String)symbolicName);
        String s = packageName;
        if (s != null) {
            s = s.replace('.', '/');
        }
        this.m_packagePath = s;
    }

    public String[] getClasses(boolean includeInnerTypes, boolean includeSubtree) {
        this.m_includeInnerTypes = includeInnerTypes;
        this.m_includeSubtree = includeSubtree;
        this.m_set = new HashSet();
        if (this.m_bundle != null && this.m_packagePath != null) {
            String path = this.removeLeadingSlash(this.m_packagePath);
            this.m_prefix = "/bin/";
            this.m_doubleCheckPrefix = true;
            Enumeration<String> sourceClasses = this.getResourcesEnumeration(this.m_bundle, String.valueOf(this.m_prefix) + path);
            if (sourceClasses == null) {
                this.m_prefix = "/classes/";
                sourceClasses = this.getResourcesEnumeration(this.m_bundle, String.valueOf(this.m_prefix) + path);
            }
            if (sourceClasses == null) {
                this.m_prefix = "/target/classes/";
                sourceClasses = this.getResourcesEnumeration(this.m_bundle, String.valueOf(this.m_prefix) + path);
            }
            this.visit(sourceClasses);
            this.m_prefix = "/";
            Enumeration<String> binaryClasses = this.getResourcesEnumeration(this.m_bundle, String.valueOf(this.m_prefix) + path);
            this.visit(binaryClasses);
        }
        return this.m_set.toArray(new String[this.m_set.size()]);
    }

    private String removeLeadingSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    /*
     * Unable to fully structure code
     */
    private Enumeration<String> getResourcesEnumeration(Bundle bundle, String path) {
        resources = new HashSet<String>();
        entries = bundle.findEntries(path, "*", true);
        if (entries != null && entries.hasMoreElements()) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            url = (URL)entries.nextElement();
            resources.add(url.getPath());
lbl8:
            // 2 sources

            ** while (entries.hasMoreElements())
        }
lbl9:
        // 1 sources

        return Collections.enumeration(resources);
    }

    private Enumeration convertToStringPaths(Enumeration entries) {
        HashSet<String> paths = new HashSet<String>();
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                paths.add(url.getPath());
            }
        }
        return Collections.enumeration(paths);
    }

    private void visit(Enumeration<String> en) {
        if (en != null) {
            while (en.hasMoreElements()) {
                String path = en.nextElement();
                if (path.endsWith(".class")) {
                    String className = this.m_doubleCheckPrefix ? (path.startsWith(this.m_prefix) ? path.substring(this.m_prefix.length(), path.length() - 6) : path.substring(this.m_prefix.length() - 1, path.length() - 6)) : path.substring(this.m_prefix.length(), path.length() - 6);
                    if (path.indexOf(36) >= 0 && !this.m_includeInnerTypes) continue;
                    className = className.replaceAll("[/]", ".");
                    this.m_set.add(className);
                    continue;
                }
                if (!path.endsWith("/") || !this.m_includeSubtree) continue;
                this.visit(this.m_bundle.getEntryPaths(path));
            }
        }
    }
}

