/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.xmlparser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.commons.xmlparser.ScoutXmlException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

@Deprecated
public class ScoutXmlParser {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ScoutXmlParser.class);
    private static boolean warnedDefaultParserNotFound;
    private static final boolean DEFAULT_IGNORE_EXTERNAL_ENTITIES = false;
    private static final boolean DEFAULT_IGNORE_SAX_ERRORS = false;
    private static final boolean DEFAULT_IGNORE_SAX_WARNINGS = true;
    private static final String DEFAULT_ENTITY_EXPANSION_LIMIT = "1000000000";
    private boolean m_ignoreExternalEntities;
    private boolean m_ignoreSaxErrors;
    private boolean m_ignoreSaxWarnings;
    private int m_numberOfIgnoredErrors;
    private int m_numberOfIgnoredWarnings;
    private ScoutXmlDocument m_xmlDocument;
    private ScoutXmlDocument.ScoutXmlElement m_initialElement;
    private XMLReader m_xmlReader;

    public ScoutXmlParser() {
        this(new ScoutXmlDocument());
    }

    public ScoutXmlParser(boolean ignoreExternalEntities) {
        this();
        this.setIgnoreExternalEntities(ignoreExternalEntities);
    }

    public ScoutXmlParser(ScoutXmlDocument document) {
        this(document, null);
    }

    protected ScoutXmlParser(ScoutXmlDocument document, ScoutXmlDocument.ScoutXmlElement root) {
        block7: {
            this.m_initialElement = root;
            this.m_xmlDocument = document;
            this.setIgnoreExternalEntities(false);
            this.setIgnoreSaxErrors(false);
            this.setIgnoreSaxWarnings(true);
            try {
                this.m_xmlReader = new SAXParser();
            }
            catch (Throwable t) {
                try {
                    this.m_xmlReader = XMLReaderFactory.createXMLReader();
                }
                catch (SAXException e) {
                    throw new UnsupportedOperationException("Cannot find an xml parser. Check dependency to org.apache.xerces");
                }
                if (warnedDefaultParserNotFound) break block7;
                warnedDefaultParserNotFound = true;
                if (!LOG.isInfoEnabled()) break block7;
                LOG.info("Missing dependency to org.apache.xerces. Using alternative " + this.m_xmlReader.getClass().getName());
            }
        }
        this.m_xmlReader.setContentHandler(new P_SaxContentHandler());
        this.m_xmlReader.setErrorHandler(new P_SaxErrorHandler());
        this.m_xmlReader.setEntityResolver(new P_SaxEntityResolver());
        try {
            this.m_xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", new P_SaxLexicalHandler());
            this.m_xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", new P_SaxDeclarationHandler());
            this.m_xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", true);
            this.m_xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    public boolean isIgnoreExternalEntities() {
        return this.m_ignoreExternalEntities;
    }

    public boolean isIgnoreSaxErrors() {
        return this.m_ignoreSaxErrors;
    }

    public boolean isIgnoreSaxWarnings() {
        return this.m_ignoreSaxWarnings;
    }

    public boolean isValidating() {
        try {
            return this.m_xmlReader.getFeature("http://xml.org/sax/features/validation");
        }
        catch (SAXNotRecognizedException exception) {
            return false;
        }
        catch (SAXNotSupportedException exception) {
            return false;
        }
    }

    public ScoutXmlDocument parse(File file) throws IOException, SAXException {
        return this.parse(new FileInputStream(file), file.getAbsolutePath());
    }

    public ScoutXmlDocument parse(InputStream stream) throws IOException, SAXException {
        return this.parse(stream, null);
    }

    public ScoutXmlDocument parse(InputStream stream, String systemId) throws IOException, SAXException {
        InputSource inputSource = new InputSource(stream);
        if (systemId != null) {
            inputSource.setSystemId(new File(systemId).toURI().toString());
        }
        this.m_xmlReader.parse(inputSource);
        return this.m_xmlDocument;
    }

    public ScoutXmlDocument parse(String source) throws IOException, SAXException {
        return this.parse(source, null);
    }

    public ScoutXmlDocument parse(String source, String systemId) throws IOException, SAXException {
        if (source.equals("")) {
            return this.m_xmlDocument;
        }
        try {
            if (new File(source).exists()) {
                source = new File(source).toURI().toString();
            } else {
                new URI(source);
            }
            this.m_xmlReader.parse(source);
        }
        catch (URISyntaxException exception) {
            if (source.trim().startsWith("<")) {
                this.parse(new ByteArrayInputStream(source.getBytes()), systemId);
            }
            throw new ScoutXmlException("Unknown source. If it is a file path the file doesn't exist.");
        }
        return this.m_xmlDocument;
    }

    public ScoutXmlDocument parse(URL url) throws IOException, SAXException {
        return this.parse(url.toExternalForm());
    }

    public void setIgnoreExternalEntities(boolean ignoreExternalEntities) {
        this.m_ignoreExternalEntities = ignoreExternalEntities;
    }

    public void setIgnoreSaxErrors(boolean ignoreSaxErrors) {
        this.m_ignoreSaxErrors = ignoreSaxErrors;
    }

    public void setIgnoreSaxWarnings(boolean ignoreSaxWarnings) {
        this.m_ignoreSaxWarnings = ignoreSaxWarnings;
    }

    public void setValidating(boolean validating) {
        block2: {
            try {
                this.m_xmlReader.setFeature("http://xml.org/sax/features/validation", validating);
            }
            catch (Exception exception) {
                if (!validating) break block2;
                throw new ScoutXmlException("The currently instantiated SAX parser doesn't allow to turn validation on.", exception);
            }
        }
    }

    public void setXmlEncoding(String encoding) {
        this.m_xmlDocument.setXmlEncoding(encoding);
    }

    private class P_SaxContentHandler
    implements ContentHandler {
        private ScoutXmlDocument.ScoutXmlElement m_ancestor;
        private ScoutXmlDocument.ScoutXmlElement m_current;
        private Map<String, String> m_namespaceBuffer;
        private StringBuffer m_textBuffer;

        private P_SaxContentHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.m_ancestor = ScoutXmlParser.this.m_initialElement != null ? ScoutXmlParser.this.m_initialElement.getParent() : null;
            this.m_current = ScoutXmlParser.this.m_initialElement;
            this.m_namespaceBuffer = new Hashtable<String, String>();
            this.m_textBuffer = new StringBuffer();
            ScoutXmlParser.this.m_numberOfIgnoredErrors = 0;
            ScoutXmlParser.this.m_numberOfIgnoredWarnings = 0;
            ScoutXmlParser.this.m_xmlDocument.setStrictlyChecking(false);
        }

        @Override
        public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
            this.m_namespaceBuffer.put(prefix, namespaceURI);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qnamePrefixed, Attributes attributes) throws SAXException {
            String text = this.m_textBuffer.toString().trim();
            if (text.length() > 0) {
                this.m_current.addText(text);
            }
            if (this.m_textBuffer.length() > 0) {
                this.m_textBuffer = new StringBuffer();
            }
            this.m_ancestor = this.m_current;
            this.m_current = ScoutXmlParser.this.m_xmlDocument.new ScoutXmlDocument.ScoutXmlElement();
            this.m_current.setName(qnamePrefixed.equals("") ? localName : qnamePrefixed);
            if (ScoutXmlParser.this.m_xmlDocument.hasRoot()) {
                this.m_ancestor.addChild(this.m_current);
            } else {
                ScoutXmlParser.this.m_xmlDocument.setRoot(this.m_current);
            }
            if (this.m_namespaceBuffer.size() > 0) {
                this.m_current.setNamespaces(this.m_namespaceBuffer);
                this.m_namespaceBuffer = new Hashtable<String, String>();
            }
            if (attributes.getLength() > 0) {
                this.m_current.setAttributes(attributes);
            }
        }

        @Override
        public void characters(char[] characters, int start, int length) throws SAXException {
            if (length > 0) {
                this.m_textBuffer.append(characters, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String text = this.m_textBuffer.toString().trim();
            if (text.length() > 0) {
                this.m_current.addText(text);
            }
            if (this.m_textBuffer.length() > 0) {
                this.m_textBuffer = new StringBuffer();
            }
            this.m_current.optimize();
            if (!this.m_current.isRoot()) {
                this.m_current = this.m_ancestor;
                this.m_ancestor = this.m_ancestor.getParent();
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
            this.m_ancestor = null;
            this.m_current = null;
            this.m_namespaceBuffer = null;
            this.m_textBuffer = null;
            if (ScoutXmlParser.this.m_numberOfIgnoredErrors > 0) {
                LOG.warn(String.valueOf(ScoutXmlParser.this.m_numberOfIgnoredErrors) + " recoverable error(s) were ignored.");
            }
            if (ScoutXmlParser.this.m_numberOfIgnoredWarnings > 0) {
                LOG.warn(String.valueOf(ScoutXmlParser.this.m_numberOfIgnoredWarnings) + " warnings(s) were ignored.");
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }

    private class P_SaxDeclarationHandler
    implements DeclHandler {
        private P_SaxDeclarationHandler() {
        }

        @Override
        public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        }

        @Override
        public void elementDecl(String name, String model) throws SAXException {
        }

        @Override
        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void internalEntityDecl(String name, String value) throws SAXException {
        }
    }

    private class P_SaxEntityResolver
    implements EntityResolver {
        private P_SaxEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (ScoutXmlParser.this.isIgnoreExternalEntities()) {
                return new InputSource(new ByteArrayInputStream(new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").getBytes()));
            }
            return null;
        }
    }

    private class P_SaxErrorHandler
    implements ErrorHandler {
        private P_SaxErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (!ScoutXmlParser.this.isIgnoreSaxErrors()) {
                throw exception;
            }
            ScoutXmlParser scoutXmlParser = ScoutXmlParser.this;
            scoutXmlParser.m_numberOfIgnoredErrors = scoutXmlParser.m_numberOfIgnoredErrors + 1;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (ScoutXmlParser.this.isIgnoreSaxWarnings()) {
                ScoutXmlParser scoutXmlParser = ScoutXmlParser.this;
                scoutXmlParser.m_numberOfIgnoredWarnings = scoutXmlParser.m_numberOfIgnoredWarnings + 1;
            } else {
                LOG.warn(exception.getMessage());
            }
        }
    }

    private class P_SaxLexicalHandler
    implements LexicalHandler {
        private P_SaxLexicalHandler() {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            ScoutXmlParser.this.m_xmlDocument.setExternalDTD(publicId, systemId);
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }
    }
}

