/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.internal;

import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.scout.nls.sdk.internal.jdt.INlsFolder;
import org.eclipse.scout.nls.sdk.internal.jdt.NlsFolder;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.sdk.util.log.SdkLogManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class NlsSdkSimple
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.scout.nls.sdk.simple";
    private static final Pattern PATTERN = Pattern.compile("^[^_.]*(_([A-Za-z]{2}))?(_([A-Za-z]{2}))?(_([A-Za-z]{2}))?\\.properties$");
    private static NlsSdkSimple plugin;
    private static SdkLogManager logManager;

    public static List<IProject> getWorkspaceFragments(String hostPluginId) throws CoreException {
        IProject[] allProjects;
        LinkedList<IProject> fragments = new LinkedList<IProject>();
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription[] hosts;
            HostSpecification hspec;
            IPluginModelBase b;
            IProject lookAt = iProjectArray[n2];
            if (lookAt.isOpen() && lookAt.hasNature("org.eclipse.jdt.core.javanature") && lookAt.hasNature("org.eclipse.pde.PluginNature") && (b = PluginRegistry.findModel((IProject)lookAt)) != null && (hspec = b.getBundleDescription().getHost()) != null && (hosts = hspec.getHosts()) != null && hosts.length > 0 && hosts[0].getName().equals(hostPluginId)) {
                fragments.add(lookAt);
            }
            ++n2;
        }
        return fragments;
    }

    public static List<IProject> getWorkspaceFragments(IProject project) throws CoreException {
        return NlsSdkSimple.getWorkspaceFragments(project.getName());
    }

    public static List<IProject> getProjectGroup(IProject project) throws FileNotFoundException, CoreException {
        List<IProject> anesters = NlsSdkSimple.getWorkspaceFragments(project);
        anesters.add(project);
        return anesters;
    }

    public static Language getLanguage(String simpleFileName) {
        Matcher matcher = PATTERN.matcher(simpleFileName);
        if (matcher.matches()) {
            String variantIso;
            String countryIso;
            if (matcher.group(2) == null) {
                return Language.LANGUAGE_DEFAULT;
            }
            String languageIso = matcher.group(2);
            if (languageIso == null) {
                languageIso = "";
            }
            if ((countryIso = matcher.group(4)) == null) {
                countryIso = "";
            }
            if ((variantIso = matcher.group(5)) == null) {
                variantIso = "";
            }
            return new Language(new Locale(languageIso, countryIso, variantIso));
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        logManager = new SdkLogManager((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        logManager = null;
        super.stop(context);
    }

    public static NlsSdkSimple getDefault() {
        return plugin;
    }

    public static List<IFile> getAllTranslations(IProject toLookAt, IPath path, String fileNamePrefix) throws CoreException {
        LinkedList<IFolder> folders = new LinkedList<IFolder>();
        List<INlsFolder> nlsFolders = NlsSdkSimple.getFoldersOfProject(toLookAt, path, true);
        for (INlsFolder folder : nlsFolders) {
            folders.add(folder.getFolder());
        }
        return NlsSdkSimple.getAllTranslations(folders, fileNamePrefix);
    }

    public static List<IFile> getAllTranslations(List<IFolder> folders, String fileNamePrefix) throws CoreException {
        LinkedList<IFile> files = new LinkedList<IFile>();
        for (IFolder folder : folders) {
            IResource[] resources;
            if (!folder.exists()) continue;
            IResource[] iResourceArray = resources = folder.members(0);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile && resource.getName().matches(String.valueOf(fileNamePrefix) + "(_[a-zA-Z]{2}){0,3}" + "\\.properties")) {
                    files.add((IFile)resource);
                }
                ++n2;
            }
        }
        return files;
    }

    public static List<INlsFolder> getFoldersOfProject(IProject project, IPath path, boolean runntimeDir) throws CoreException {
        LinkedList<INlsFolder> folders = new LinkedList<INlsFolder>();
        if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
            IFolder foundFolder;
            if (runntimeDir) {
                IClasspathEntry[] clEntries;
                IJavaProject jp = JavaCore.create((IProject)project);
                IClasspathEntry[] iClasspathEntryArray = clEntries = jp.getRawClasspath();
                int n = clEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath toCheck;
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3 && project.getFolder(toCheck = new Path(entry.getPath().lastSegment()).append(path)).exists()) {
                        folders.add((INlsFolder)new NlsFolder(project.getFolder(toCheck), 1));
                    }
                    ++n2;
                }
            }
            if ((foundFolder = project.getFolder(path)) != null && foundFolder.exists()) {
                folders.add((INlsFolder)new NlsFolder(foundFolder, 4));
            }
        }
        return folders;
    }

    public static String getLocalizedPropertiesFileName(String prefix, Language language) {
        String fileName = prefix;
        Locale locale = language.getLocale();
        fileName = String.valueOf(fileName) + "_" + locale.toString() + ".properties";
        return fileName;
    }

    public static void logInfo(Throwable t) {
        logManager.logInfo(t);
    }

    public static void logInfo(String message) {
        logManager.logInfo(message);
    }

    public static void logInfo(String message, Throwable t) {
        logManager.logInfo(message, t);
    }

    public static void logWarning(String message) {
        logManager.logWarning(message);
    }

    public static void logWarning(Throwable t) {
        logManager.logWarning(t);
    }

    public static void logWarning(String message, Throwable t) {
        logManager.logWarning(message, t);
    }

    public static void logError(Throwable t) {
        logManager.logError(t);
    }

    public static void logError(String message) {
        logManager.logError(message);
    }

    public static void logError(String message, Throwable t) {
        logManager.logError(message, t);
    }
}

