/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.beans.PropertyChangeListener;
import java.security.Principal;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ILocaleListener;
import org.eclipse.scout.rt.client.IMemoryPolicy;
import org.eclipse.scout.rt.client.LargeMemoryPolicy;
import org.eclipse.scout.rt.client.LocaleChangeEvent;
import org.eclipse.scout.rt.client.MediumMemoryPolicy;
import org.eclipse.scout.rt.client.SmallMemoryPolicy;
import org.eclipse.scout.rt.client.services.common.clientnotification.ClientNotificationConsumerEvent;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerListener;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerService;
import org.eclipse.scout.rt.client.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.client.servicetunnel.http.IClientServiceTunnel;
import org.eclipse.scout.rt.client.ui.DataChangeListener;
import org.eclipse.scout.rt.client.ui.IIconLocator;
import org.eclipse.scout.rt.client.ui.IconLocator;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.internal.VirtualDesktop;
import org.eclipse.scout.rt.shared.OfflineState;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.TextsThreadLocal;
import org.eclipse.scout.rt.shared.services.common.context.SharedContextChangedNotification;
import org.eclipse.scout.rt.shared.services.common.context.SharedVariableMap;
import org.eclipse.scout.rt.shared.services.common.prefs.IUserPreferencesStorageService;
import org.eclipse.scout.rt.shared.services.common.security.ILogoutService;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class AbstractClientSession
implements IClientSession {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractClientSession.class);
    private Bundle m_bundle;
    private final Object m_stateLock;
    private volatile boolean m_active;
    private volatile boolean m_isStopping = false;
    private Throwable m_loadError;
    private int m_exitCode = IApplication.EXIT_OK;
    private IDesktop m_desktop;
    private VirtualDesktop m_virtualDesktop;
    private IClientServiceTunnel m_serviceTunnel;
    private Subject m_offlineSubject;
    private Subject m_subject;
    private final SharedVariableMap m_sharedVariableMap;
    private boolean m_singleThreadSession;
    private String m_virtualSessionId;
    private IMemoryPolicy m_memoryPolicy;
    private IIconLocator m_iconLocator;
    private final HashMap<String, Object> m_clientSessionData;
    private ScoutTexts m_scoutTexts;
    private Locale m_locale;
    private UserAgent m_userAgent;
    private Vector<ILocaleListener> m_localeListener = new Vector();
    private long m_maxShutdownWaitTime = 4567L;

    public AbstractClientSession(boolean autoInitConfig) {
        this.m_clientSessionData = new HashMap();
        this.m_stateLock = new Object();
        this.m_sharedVariableMap = new SharedVariableMap();
        this.m_locale = LocaleThreadLocal.get();
        if (autoInitConfig) {
            this.initConfig();
        }
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredSingleThreadSession() {
        return false;
    }

    public String getUserId() {
        return this.getSharedContextVariable("userId", String.class);
    }

    public ScoutTexts getTexts() {
        return this.m_scoutTexts;
    }

    public final Locale getLocale() {
        return this.m_locale;
    }

    public final void setLocale(Locale locale) {
        if (locale != null) {
            Locale oldLocale = this.m_locale;
            this.m_locale = locale;
            if (!locale.equals(oldLocale)) {
                this.notifyLocaleListeners(locale);
            }
        }
    }

    @Override
    public Subject getOfflineSubject() {
        return this.m_offlineSubject;
    }

    protected void setOfflineSubject(Subject offlineSubject) {
        this.m_offlineSubject = offlineSubject;
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public boolean isActive() {
        return this.m_active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActive(boolean b) {
        Object object = this.m_stateLock;
        synchronized (object) {
            this.m_active = b;
            this.m_stateLock.notifyAll();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.m_active;
    }

    public Map<String, Object> getSharedVariableMap() {
        return CollectionUtility.copyMap((Map)this.m_sharedVariableMap);
    }

    protected <T> T getSharedContextVariable(String name, Class<T> type) {
        Object o = this.m_sharedVariableMap.get((Object)name);
        return (T)TypeCastUtility.castValue((Object)o, type);
    }

    @Override
    public final Throwable getLoadError() {
        return this.m_loadError;
    }

    @Override
    public final Object getStateLock() {
        return this.m_stateLock;
    }

    protected void initConfig() {
        this.m_singleThreadSession = this.getConfiguredSingleThreadSession();
        this.m_virtualDesktop = new VirtualDesktop();
        this.setMemoryPolicy(new LargeMemoryPolicy());
        IClientNotificationConsumerService clientNotificationConsumerService = (IClientNotificationConsumerService)SERVICES.getService(IClientNotificationConsumerService.class);
        if (clientNotificationConsumerService != null) {
            clientNotificationConsumerService.addClientNotificationConsumerListener(this, new IClientNotificationConsumerListener(){

                @Override
                public void handleEvent(final ClientNotificationConsumerEvent e, boolean sync) {
                    if (e.getClientNotification().getClass() == SharedContextChangedNotification.class) {
                        if (sync) {
                            try {
                                AbstractClientSession.this.updateSharedVariableMap(((SharedContextChangedNotification)e.getClientNotification()).getSharedVariableMap());
                            }
                            catch (Throwable t) {
                                LOG.error("update of shared contex", t);
                            }
                        } else {
                            new ClientSyncJob("Update shared context", ClientSyncJob.getCurrentSession()){

                                @Override
                                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                                    AbstractClientSession.this.updateSharedVariableMap(((SharedContextChangedNotification)e.getClientNotification()).getSharedVariableMap());
                                }
                            }.schedule();
                        }
                    }
                }
            });
        }
    }

    private void updateSharedVariableMap(SharedVariableMap newMap) {
        this.m_sharedVariableMap.updateInternal(newMap);
    }

    @Override
    public final void startSession(Bundle bundle) {
        this.m_bundle = bundle;
        if (this.isActive()) {
            throw new IllegalStateException("session is active");
        }
        try {
            String policy = bundle.getBundleContext().getProperty("org.eclipse.scout.memory");
            if ("small".equals(policy)) {
                this.setMemoryPolicy(new SmallMemoryPolicy());
            } else if ("medium".equals(policy)) {
                this.setMemoryPolicy(new MediumMemoryPolicy());
            }
            this.m_iconLocator = this.createIconLocator();
            this.m_scoutTexts = new ScoutTexts();
            TextsThreadLocal.set((ScoutTexts)this.m_scoutTexts);
            this.execLoadSession();
            this.setActive(true);
        }
        catch (Throwable t) {
            this.m_loadError = t;
            LOG.error("load session", t);
        }
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execLoadSession() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execStoreSession() throws ProcessingException {
    }

    @Override
    public IDesktop getVirtualDesktop() {
        return this.m_desktop != null ? this.m_desktop : this.m_virtualDesktop;
    }

    @Override
    public IDesktop getDesktop() {
        return this.m_desktop;
    }

    @Override
    public void setDesktop(IDesktop a) throws ProcessingException {
        if (a == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        if (this.m_desktop != null) {
            throw new IllegalStateException("desktop is active");
        }
        this.m_desktop = a;
        if (this.m_desktop != null) {
            if (this.m_virtualDesktop != null) {
                EventListener listener;
                int n;
                int n2;
                EventListener[] eventListenerArray;
                EventListenerList list;
                DesktopListener[] desktopListenerArray = this.m_virtualDesktop.getDesktopListeners();
                int n3 = desktopListenerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    DesktopListener desktopListener = desktopListenerArray[n4];
                    this.m_desktop.addDesktopListener(desktopListener);
                    ++n4;
                }
                for (Map.Entry<String, EventListenerList> entry : this.m_virtualDesktop.getPropertyChangeListenerMap().entrySet()) {
                    String propName = entry.getKey();
                    list = entry.getValue();
                    if (propName == null) {
                        eventListenerArray = (PropertyChangeListener[])list.getListeners(PropertyChangeListener.class);
                        n2 = eventListenerArray.length;
                        n = 0;
                        while (n < n2) {
                            listener = eventListenerArray[n];
                            this.m_desktop.addPropertyChangeListener((PropertyChangeListener)listener);
                            ++n;
                        }
                        continue;
                    }
                    eventListenerArray = (PropertyChangeListener[])list.getListeners(PropertyChangeListener.class);
                    n2 = eventListenerArray.length;
                    n = 0;
                    while (n < n2) {
                        listener = eventListenerArray[n];
                        this.m_desktop.addPropertyChangeListener(propName, (PropertyChangeListener)listener);
                        ++n;
                    }
                }
                for (Map.Entry<Object, EventListenerList> entry : this.m_virtualDesktop.getDataChangeListenerMap().entrySet()) {
                    Object dataType = entry.getKey();
                    list = entry.getValue();
                    if (dataType == null) {
                        eventListenerArray = (DataChangeListener[])list.getListeners(DataChangeListener.class);
                        n2 = eventListenerArray.length;
                        n = 0;
                        while (n < n2) {
                            listener = eventListenerArray[n];
                            this.m_desktop.addDataChangeListener((DataChangeListener)listener, new Object[0]);
                            ++n;
                        }
                        continue;
                    }
                    eventListenerArray = (DataChangeListener[])list.getListeners(DataChangeListener.class);
                    n2 = eventListenerArray.length;
                    n = 0;
                    while (n < n2) {
                        listener = eventListenerArray[n];
                        this.m_desktop.addDataChangeListener((DataChangeListener)listener, dataType);
                        ++n;
                    }
                }
                this.m_virtualDesktop = null;
            }
            this.m_desktop.initDesktop();
        } else {
            this.m_virtualDesktop = new VirtualDesktop();
        }
    }

    @Override
    public void stopSession() {
        this.stopSession(IApplication.EXIT_OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopSession(int exitCode) {
        Object object = this.m_stateLock;
        synchronized (object) {
            if (this.isStopping()) {
                return;
            }
            this.m_isStopping = true;
        }
        if (!this.m_desktop.doBeforeClosingInternal()) {
            this.m_isStopping = false;
            return;
        }
        this.m_exitCode = exitCode;
        try {
            this.execStoreSession();
        }
        catch (Throwable t) {
            LOG.error("store session", t);
        }
        if (this.m_desktop != null) {
            try {
                this.m_desktop.closeInternal();
            }
            catch (Throwable t) {
                LOG.error("close desktop", t);
            }
            this.m_desktop = null;
        }
        if (!this.m_localeListener.isEmpty()) {
            this.m_localeListener.clear();
        }
        try {
            if (this.getServiceTunnel() != null) {
                ((ILogoutService)SERVICES.getService(ILogoutService.class)).logout();
            }
        }
        catch (Throwable t) {
            LOG.info("logout on server", t);
        }
        if (this.getMaxShutdownWaitTime() > 0L) {
            this.scheduleSessionInactivation();
        } else {
            this.inactivateSession();
        }
    }

    private void scheduleSessionInactivation() {
        new Job("Wait for client jobs to finish before inactivating the session"){

            protected IStatus run(IProgressMonitor monitor) {
                long timeout = AbstractClientSession.this.getMaxShutdownWaitTime();
                for (ClientJob clientJob : AbstractClientSession.this.findClientJobs()) {
                    try {
                        clientJob.join(timeout);
                    }
                    catch (InterruptedException e) {
                        LOG.info(String.format("Interrupted while waiting for the client job to finish. [job=%s]", clientJob), (Throwable)e);
                    }
                }
                AbstractClientSession.this.inactivateSession();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected final Set<ClientJob> findClientJobs() {
        Job currentJob = ClientJob.getJobManager().currentJob();
        HashSet<ClientJob> clientJobs = new HashSet<ClientJob>();
        Job[] jobArray = Job.getJobManager().find(ClientJob.class);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            ClientJob candidateJob = (ClientJob)job;
            if (candidateJob.getClientSession() == this && candidateJob != currentJob) {
                clientJobs.add(candidateJob);
            }
            ++n2;
        }
        return clientJobs;
    }

    protected void inactivateSession() {
        Set<ClientJob> runningClientJobs = this.findClientJobs();
        if (!runningClientJobs.isEmpty()) {
            LOG.warn("Some running client jobs found while client session is going to shutdown. If waiting for a condition or running a scheduled executor, the associated worker threads may never been released. Please ensure to terminate all client jobs when the session is going down. [session={0}, user={1}, jobs={2}]", new Object[]{this, this.getUserId(), runningClientJobs});
        }
        this.setActive(false);
        if (LOG.isInfoEnabled()) {
            LOG.info("Client session was shutdown successfully [session={0}, user={1}]", (Object)this, (Object)this.getUserId());
        }
    }

    protected boolean isStopping() {
        return this.m_isStopping;
    }

    @Override
    public int getExitCode() {
        return this.m_exitCode;
    }

    @Override
    public IClientServiceTunnel getServiceTunnel() {
        return this.m_serviceTunnel;
    }

    protected void setServiceTunnel(IClientServiceTunnel tunnel) {
        this.m_serviceTunnel = tunnel;
    }

    @Deprecated
    protected void setServiceTunnel(IServiceTunnel tunnel) {
        this.setServiceTunnel((IClientServiceTunnel)tunnel);
    }

    @Override
    public IMemoryPolicy getMemoryPolicy() {
        return this.m_memoryPolicy;
    }

    @Override
    public void setMemoryPolicy(IMemoryPolicy p) {
        if (this.m_memoryPolicy != null) {
            this.m_memoryPolicy.removeNotify();
        }
        this.m_memoryPolicy = p;
        if (this.m_memoryPolicy != null) {
            this.m_memoryPolicy.addNotify();
        }
    }

    public void goOnline() throws ProcessingException {
        if (OfflineState.isOfflineDefault()) {
            OfflineState.setOfflineDefault((boolean)false);
        }
    }

    @Override
    public void goOffline() throws ProcessingException {
        Preferences pref = ((IUserPreferencesStorageService)SERVICES.getService(IUserPreferencesStorageService.class)).loadPreferences();
        if (this.getUserId() != null && OfflineState.isOnlineDefault()) {
            try {
                pref.put("offline.user", this.getUserId());
                pref.flush();
                pref.sync();
            }
            catch (BackingStoreException e) {
                LOG.error("Could not write userId to preferences!");
            }
        }
        String offlineUser = pref.get("offline.user", "anonymous");
        this.m_offlineSubject = new Subject();
        this.m_offlineSubject.getPrincipals().add((Principal)new SimplePrincipal(offlineUser));
        OfflineState.setOfflineDefault((boolean)true);
    }

    public boolean isSingleThreadSession() {
        return this.m_singleThreadSession;
    }

    public String getVirtualSessionId() {
        return this.m_virtualSessionId;
    }

    public void setVirtualSessionId(String sessionId) {
        this.m_virtualSessionId = sessionId;
    }

    public Subject getSubject() {
        return this.m_subject;
    }

    public void setSubject(Subject subject) {
        this.m_subject = subject;
    }

    protected IIconLocator createIconLocator() {
        return new IconLocator(this);
    }

    @Override
    public IIconLocator getIconLocator() {
        return this.m_iconLocator;
    }

    public void setData(String key, Object data) {
        if (data == null) {
            this.m_clientSessionData.remove(key);
        } else {
            this.m_clientSessionData.put(key, data);
        }
    }

    public Object getData(String key) {
        return this.m_clientSessionData.get(key);
    }

    public UserAgent getUserAgent() {
        if (this.m_userAgent == null) {
            LOG.warn("UserAgent has not been initialied correctly. Using default.");
            this.m_userAgent = UserAgent.createDefault();
        }
        return this.m_userAgent;
    }

    public void setUserAgent(UserAgent userAgent) {
        this.m_userAgent = userAgent;
    }

    @Override
    public void addLocaleListener(ILocaleListener listener) {
        this.m_localeListener.add(listener);
    }

    @Override
    public void removeLocaleListener(ILocaleListener listener) {
        this.m_localeListener.remove(listener);
    }

    protected void notifyLocaleListeners(Locale locale) {
        LocaleChangeEvent event = new LocaleChangeEvent(this, locale);
        for (ILocaleListener listener : (Vector)this.m_localeListener.clone()) {
            listener.localeChanged(event);
        }
    }

    public void setMaxShutdownWaitTime(long maxShutdownWaitTime) {
        this.m_maxShutdownWaitTime = maxShutdownWaitTime;
    }

    public long getMaxShutdownWaitTime() {
        return this.m_maxShutdownWaitTime;
    }
}

