/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ClientJobContext;
import org.eclipse.scout.rt.client.ClientJobContextThreadLocal;
import org.eclipse.scout.rt.client.ClientRule;
import org.eclipse.scout.rt.client.ClientSessionThreadLocal;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.IClientSessionProvider;
import org.eclipse.scout.rt.client.IJobChangeListenerEx;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.TextsThreadLocal;

public class ClientJob
extends JobEx
implements IClientSessionProvider {
    private final IClientSession m_session;
    private final EventListenerList m_listeners;
    private final Object m_waitForLock;
    private boolean m_waitFor;
    private final ClientJobContext m_context;

    public ClientJob(String name, IClientSession session, boolean sync) {
        this(name, session, sync, true);
    }

    public ClientJob(String name, IClientSession session, boolean sync, boolean system) {
        super(name);
        ClientJobContext currentContext;
        if (session == null) {
            throw new IllegalArgumentException("session is null");
        }
        this.m_session = session;
        this.m_listeners = new EventListenerList();
        this.setUser(false);
        this.setSystem(system);
        this.m_waitForLock = new Object();
        if (sync) {
            this.setRule(new ClientRule(session));
        }
        this.m_context = (currentContext = ClientJobContextThreadLocal.get()) != null ? new ClientJobContext(currentContext) : new ClientJobContext();
    }

    @Override
    public IClientSession getClientSession() {
        return this.m_session;
    }

    public boolean belongsTo(Object family) {
        return family == ClientJob.class;
    }

    public final boolean isSync() {
        return this.getRule() instanceof ClientRule;
    }

    public final void setSync(boolean sync) {
        if (sync != this.isSync()) {
            if (this.getState() != 0) {
                throw new IllegalStateException("sync property cannot be changed once the job is scheduled");
            }
            if (sync) {
                this.setRule(new ClientRule(this.m_session));
            } else {
                this.setRule(null);
            }
        }
    }

    public final boolean isWaitFor() {
        return this.m_waitFor;
    }

    public boolean shouldSchedule() {
        if (this.getClientSession() != null && this.getClientSession().isSingleThreadSession()) {
            this.runNow((IProgressMonitor)new NullProgressMonitor());
            return false;
        }
        return super.shouldSchedule();
    }

    protected final IStatus run(IProgressMonitor monitor) {
        return this.runTransactionWrapper(monitor);
    }

    private IStatus runTransactionWrapper(IProgressMonitor monitor) {
        Locale oldLocale = LocaleThreadLocal.get();
        ScoutTexts oldTexts = TextsThreadLocal.get();
        IClientSession oldSession = ClientSessionThreadLocal.get();
        ClientJobContext oldContext = ClientJobContextThreadLocal.get();
        try {
            ClientSessionThreadLocal.set(this.getClientSession());
            LocaleThreadLocal.set((Locale)this.m_session.getLocale());
            TextsThreadLocal.set((ScoutTexts)this.m_session.getTexts());
            ClientJobContextThreadLocal.set(this.m_context);
            IStatus iStatus = this.runStatus(monitor);
            return iStatus;
        }
        finally {
            ClientSessionThreadLocal.set(oldSession);
            LocaleThreadLocal.set((Locale)oldLocale);
            TextsThreadLocal.set((ScoutTexts)oldTexts);
            ClientJobContextThreadLocal.set(oldContext);
        }
    }

    protected IStatus runStatus(IProgressMonitor monitor) {
        try {
            this.runVoid(monitor);
            return Status.OK_STATUS;
        }
        catch (Throwable t) {
            return new Status(4, "<none>", 0, t.getMessage(), t);
        }
    }

    protected void runVoid(IProgressMonitor monitor) throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitFor() throws InterruptedException {
        ClientRule rule = this.getRule() instanceof ClientRule ? (ClientRule)this.getRule() : null;
        this.fireBlockingConditionStart();
        Object object = this.m_waitForLock;
        synchronized (object) {
            if (rule != null) {
                rule.setEnabled(false);
                this.rescheduleWaitingSyncJobs();
            }
            this.m_waitFor = true;
            this.m_waitForLock.wait();
        }
        this.m_waitFor = false;
        this.fireBlockingConditionEnd();
    }

    void releaseWaitFor() {
        ClientRule rule;
        ClientRule clientRule = rule = this.getRule() instanceof ClientRule ? (ClientRule)this.getRule() : null;
        if (rule != null) {
            ClientSyncJob proxyJob = new ClientSyncJob("release waitFor lock on \"" + this + "\"", this.m_session){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void runVoid(IProgressMonitor arg0) throws Throwable {
                    rule.setEnabled(true);
                    ClientJob.this.rescheduleWaitingSyncJobs();
                    Object object = ClientJob.this.m_waitForLock;
                    synchronized (object) {
                        ClientJob.this.m_waitForLock.notifyAll();
                    }
                }
            };
            proxyJob.schedule();
        }
    }

    private void rescheduleWaitingSyncJobs() {
        ArrayList<Job> jobList = new ArrayList<Job>();
        Job[] jobArray = Job.getJobManager().find(ClientJob.class);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientJob c;
            Job j = jobArray[n2];
            if (j instanceof ClientJob && (c = (ClientJob)j).isSync() && !c.isWaitFor() && c.getState() == 2) {
                jobList.add(j);
            }
            ++n2;
        }
        int i = jobList.size() - 1;
        while (i >= 0) {
            Job j = (Job)jobList.get(i);
            if (!j.sleep()) {
                jobList.remove(i);
            }
            --i;
        }
        for (Job j : jobList) {
            j.wakeUp();
        }
    }

    public final void addJobChangeListenerEx(IJobChangeListenerEx listener) {
        this.addJobChangeListener(listener);
        this.m_listeners.add(IJobChangeListenerEx.class, (EventListener)listener);
    }

    public final void removeJobChangeListenerEx(IJobChangeListenerEx listener) {
        this.removeJobChangeListener(listener);
        this.m_listeners.remove(IJobChangeListenerEx.class, (EventListener)listener);
    }

    private void fireBlockingConditionStart() {
        JobChangeEventEx e = new JobChangeEventEx((Job)this);
        IJobChangeListenerEx[] iJobChangeListenerExArray = (IJobChangeListenerEx[])this.m_listeners.getListeners(IJobChangeListenerEx.class);
        int n = iJobChangeListenerExArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJobChangeListenerEx listener = iJobChangeListenerExArray[n2];
            try {
                listener.blockingConditionStart(e);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ++n2;
        }
    }

    private void fireBlockingConditionEnd() {
        JobChangeEventEx e = new JobChangeEventEx((Job)this);
        IJobChangeListenerEx[] iJobChangeListenerExArray = (IJobChangeListenerEx[])this.m_listeners.getListeners(IJobChangeListenerEx.class);
        int n = iJobChangeListenerExArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJobChangeListenerEx listener = iJobChangeListenerExArray[n2];
            try {
                listener.blockingConditionEnd(e);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ++n2;
        }
    }

    public static final boolean isSyncClientJob() {
        Job j = Job.getJobManager().currentJob();
        return j instanceof ClientJob && ((ClientJob)j).isSync();
    }

    public static final IClientSession getCurrentSession() {
        return ClientJob.getCurrentSession(IClientSession.class);
    }

    public static final <T extends IClientSession> T getCurrentSession(Class<T> type) {
        IClientSession s = ClientSessionThreadLocal.get();
        if (s != null && type.isAssignableFrom(s.getClass())) {
            return (T)s;
        }
        return null;
    }

    private static class JobChangeEventEx
    implements IJobChangeEvent {
        Job job = null;

        public JobChangeEventEx(Job job) {
            this.job = job;
        }

        public long getDelay() {
            return 0L;
        }

        public Job getJob() {
            return this.job;
        }

        public IStatus getResult() {
            return null;
        }
    }
}

