/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.security;

import java.util.HashMap;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleClassDescriptor;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.servicetunnel.ServiceTunnelUtility;
import org.eclipse.scout.rt.shared.services.common.security.IPermissionService;
import org.eclipse.scout.service.AbstractService;

@Priority(value=-3.0f)
public class PermissionServiceClientProxy
extends AbstractService
implements IPermissionService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PermissionServiceClientProxy.class);
    private final Object m_stateLock = new Object();
    private final HashMap<Object, ServiceState> m_stateMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceState getServiceState() {
        IClientSession session = ClientJob.getCurrentSession();
        if (session == null) {
            LOG.warn("could not find a client session");
            return null;
        }
        Class<?> key = session.getClass();
        Object object = this.m_stateLock;
        synchronized (object) {
            ServiceState data = this.m_stateMap.get(key);
            if (data == null) {
                data = new ServiceState();
                this.m_stateMap.put(key, data);
            }
            return data;
        }
    }

    public BundleClassDescriptor[] getAllPermissionClasses() {
        ServiceState state = this.getServiceState();
        this.checkCache(state);
        return state.m_permissionClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCache(ServiceState state) {
        Object object = state.m_permissionClassesLock;
        synchronized (object) {
            if (state.m_permissionClasses == null) {
                state.m_permissionClasses = this.getRemoteService().getAllPermissionClasses();
            }
        }
    }

    private IPermissionService getRemoteService() {
        return (IPermissionService)ServiceTunnelUtility.createProxy(IPermissionService.class, (IServiceTunnel)ClientSyncJob.getCurrentSession().getServiceTunnel());
    }

    private static class ServiceState {
        final Object m_permissionClassesLock = new Object();
        BundleClassDescriptor[] m_permissionClasses;

        private ServiceState() {
        }
    }
}

