/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action;

import java.security.Permission;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.Replace;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionUIFacade;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractAction
extends AbstractPropertyObserver
implements IAction {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractAction.class);
    private boolean m_initialized;
    private final EventListenerList m_listenerList = new EventListenerList();
    private final IActionUIFacade m_uiFacade = this.createUIFacade();
    private boolean m_inheritAccessibility;
    private boolean m_enabledGranted = true;
    private boolean m_enabledProperty;
    private boolean m_enabledProcessingAction = true;
    private boolean m_visibleProperty;
    private boolean m_visibleGranted = true;
    private boolean m_toggleAction;
    private boolean m_separator;

    public AbstractAction() {
        this(true);
    }

    public AbstractAction(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.initConfig();
            this.m_initialized = true;
        }
    }

    @Override
    public final void initAction() throws ProcessingException {
        this.execInitAction();
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=30.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=40.0)
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=50.0)
    protected String getConfiguredTooltipText() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=55.0)
    protected String getConfiguredKeyStroke() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=22.0)
    protected boolean getConfiguredInheritAccessibility() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=25.0)
    protected boolean getConfiguredToggleAction() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredSeparator() {
        return false;
    }

    @Deprecated
    @Order(value=110.0)
    protected String getConfiguredDoc() {
        return null;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitAction() throws ProcessingException {
    }

    @Deprecated
    @Order(value=20.0)
    protected void execPrepareAction() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execAction() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=31.0)
    protected void execToggleAction(boolean selected) throws ProcessingException {
    }

    protected void initConfig() {
        this.setIconId(this.getConfiguredIconId());
        this.setText(this.getConfiguredText());
        this.setTooltipText(this.getConfiguredTooltipText());
        this.setKeyStroke(this.getConfiguredKeyStroke());
        this.setInheritAccessibility(this.getConfiguredInheritAccessibility());
        this.setEnabled(this.getConfiguredEnabled());
        this.setVisible(this.getConfiguredVisible());
        this.setToggleAction(this.getConfiguredToggleAction());
        this.setSeparator(this.getConfiguredSeparator());
    }

    protected IActionUIFacade createUIFacade() {
        return new P_UIFacade();
    }

    @Override
    public int acceptVisitor(IActionVisitor visitor) {
        switch (visitor.visit(this)) {
            case 0: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 2: {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public Object getProperty(String name) {
        return this.propertySupport.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.propertySupport.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertySupport.hasProperty(name);
    }

    @Override
    public String getActionId() {
        Class<?> c = this.getClass();
        while (c.isAnnotationPresent(Replace.class)) {
            c = c.getSuperclass();
        }
        String s = c.getName();
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    @Override
    public void doAction() throws ProcessingException {
        if (this.isEnabled() && this.isVisible()) {
            try {
                this.setEnabledProcessingAction(false);
                this.doActionInternal();
            }
            finally {
                this.setEnabledProcessingAction(true);
            }
        }
    }

    protected void doActionInternal() throws ProcessingException {
        if (this.isToggleAction()) {
            this.setSelected(!this.isSelected());
        }
        this.execAction();
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    @Override
    public String getText() {
        return this.propertySupport.getPropertyString("text");
    }

    @Override
    public String getTextWithMnemonic() {
        return this.propertySupport.getPropertyString("&text");
    }

    @Override
    public void setText(String text) {
        if (text != null) {
            this.propertySupport.setPropertyString("text", StringUtility.removeMnemonic((String)text));
            this.propertySupport.setPropertyString("&text", text);
            this.propertySupport.setProperty("mnemonic", (Object)Character.valueOf(StringUtility.getMnemonic((String)text)));
        } else {
            this.propertySupport.setPropertyString("text", null);
            this.propertySupport.setPropertyString("&text", null);
            this.propertySupport.setProperty("mnemonic", (Object)Character.valueOf('\u0000'));
        }
    }

    @Override
    public String getKeyStroke() {
        return this.propertySupport.getPropertyString("keystroke");
    }

    @Override
    public void setKeyStroke(String k) {
        if (k != null) {
            k = k.toLowerCase();
            boolean shift = false;
            boolean ctrl = false;
            boolean alt = false;
            String key = null;
            if (k.endsWith(" ")) {
                key = " ";
            }
            String[] stringArray = k.trim().split("[ -]");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equals("shift")) {
                    shift = true;
                } else if (s.equals("control")) {
                    ctrl = true;
                } else if (s.equals("ctrl")) {
                    ctrl = true;
                } else if (s.equals("strg")) {
                    ctrl = true;
                } else if (s.equals("alt")) {
                    alt = true;
                } else if (s.equals("alternate")) {
                    alt = true;
                } else {
                    key = s;
                }
                ++n2;
            }
            k = key != null ? String.valueOf(shift ? "shift-" : "") + (ctrl ? "control-" : "") + (alt ? "alternate-" : "") + key : null;
        }
        this.propertySupport.setPropertyString("keystroke", k);
    }

    @Override
    public String getTooltipText() {
        return this.propertySupport.getPropertyString("tooltipText");
    }

    @Override
    public void setTooltipText(String text) {
        this.propertySupport.setPropertyString("tooltipText", text);
    }

    @Override
    public boolean isSeparator() {
        return this.m_separator;
    }

    @Override
    public void setSeparator(boolean b) {
        this.m_separator = b;
    }

    @Override
    public boolean isEnabled() {
        return this.propertySupport.getPropertyBool("enabled");
    }

    @Override
    public boolean isThisAndParentsEnabled() {
        if (!this.isEnabled()) {
            return false;
        }
        AbstractAction temp = this;
        while (temp instanceof IActionNode) {
            if ((temp = ((IActionNode)((Object)temp)).getParent()) == null) {
                return true;
            }
            if (temp.isEnabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEnabled(boolean b) {
        this.m_enabledProperty = b;
        this.setEnabledInternal();
    }

    @Override
    public boolean isSelected() {
        return this.propertySupport.getPropertyBool("selected");
    }

    @Override
    public void setSelected(boolean b) {
        if (this.setSelectedInternal(b)) {
            try {
                this.execToggleAction(b);
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    protected boolean setSelectedInternal(boolean b) {
        return this.propertySupport.setPropertyBool("selected", b);
    }

    @Override
    public boolean isToggleAction() {
        return this.m_toggleAction;
    }

    @Override
    public void setToggleAction(boolean b) {
        this.m_toggleAction = b;
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public boolean isThisAndParentsVisible() {
        if (!this.isVisible()) {
            return false;
        }
        AbstractAction temp = this;
        while (temp instanceof IActionNode) {
            if ((temp = ((IActionNode)((Object)temp)).getParent()) == null) {
                return true;
            }
            if (temp.isVisible()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setVisible(boolean b) {
        this.m_visibleProperty = b;
        this.setVisibleInternal();
    }

    @Override
    public boolean isInheritAccessibility() {
        return this.m_inheritAccessibility;
    }

    @Override
    public void setInheritAccessibility(boolean b) {
        this.m_inheritAccessibility = b;
    }

    @Override
    public void setEnabledPermission(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setEnabledGranted(b);
    }

    @Override
    public boolean isEnabledGranted() {
        return this.m_enabledGranted;
    }

    @Override
    public void setEnabledGranted(boolean b) {
        this.m_enabledGranted = b;
        this.setEnabledInternal();
    }

    @Override
    public boolean isEnabledProcessingAction() {
        return this.m_enabledProcessingAction;
    }

    @Override
    public void setEnabledProcessingAction(boolean b) {
        this.m_enabledProcessingAction = b;
        this.setEnabledInternal();
    }

    private void setEnabledInternal() {
        this.propertySupport.setPropertyBool("enabled", this.m_enabledGranted && this.m_enabledProperty && this.m_enabledProcessingAction);
    }

    @Override
    public void setVisiblePermission(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setVisibleGranted(b);
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleGranted(boolean b) {
        this.m_visibleGranted = b;
        this.setVisibleInternal();
    }

    private void setVisibleInternal() {
        this.propertySupport.setPropertyBool("visible", this.m_visibleGranted && this.m_visibleProperty);
    }

    public String classId() {
        String simpleClassId = ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
        if (this.getContainer() != null) {
            return String.valueOf(simpleClassId) + "_" + this.getContainer().classId();
        }
        return simpleClassId;
    }

    @Override
    public char getMnemonic() {
        Character c = (Character)this.propertySupport.getProperty("mnemonic");
        return c != null ? c.charValue() : (char)'\u0000';
    }

    @Override
    @Deprecated
    public final void prepareAction() {
        try {
            this.prepareActionInternal();
            this.execPrepareAction();
        }
        catch (Throwable t) {
            LOG.warn("Action " + this.getClass().getName(), t);
        }
    }

    @Override
    public IActionUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected void prepareActionInternal() throws ProcessingException {
    }

    @Override
    public ITypeWithClassId getContainer() {
        return (ITypeWithClassId)this.propertySupport.getProperty("container");
    }

    @Override
    public void setContainerInternal(ITypeWithClassId container) {
        this.propertySupport.setProperty("container", (Object)container);
    }

    protected class P_UIFacade
    implements IActionUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void fireActionFromUI() {
            try {
                if (AbstractAction.this.isThisAndParentsEnabled() && AbstractAction.this.isThisAndParentsVisible()) {
                    AbstractAction.this.doAction();
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
            catch (Throwable e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected exception", e));
            }
        }

        @Override
        public void setSelectedFromUI(boolean b) {
            AbstractAction.this.setSelected(b);
        }
    }
}

