/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICellObserver;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.profiler.DesktopProfiler;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;

public class InternalTableRow
implements ITableRow,
ICellObserver {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(InternalTableRow.class);
    private ITable m_table;
    private int m_rowIndex;
    private boolean m_enabled;
    private boolean m_checked;
    private String m_iconId;
    private int m_status = 0;
    private List<Cell> m_cells;
    private int m_rowChanging = 0;
    private boolean m_rowPropertiesChanged;
    private boolean m_filterAccepted;

    private InternalTableRow() {
        if (DesktopProfiler.getInstance().isEnabled()) {
            DesktopProfiler.getInstance().registerTableRow(this);
        }
    }

    public InternalTableRow(ITable table) {
        this();
        this.m_table = table;
        this.m_enabled = true;
        this.m_status = 0;
        this.m_filterAccepted = true;
        this.m_cells = new ArrayList<Cell>(table.getColumnCount());
        int i = 0;
        while (i < table.getColumnCount()) {
            this.m_cells.add(new Cell(this));
            ++i;
        }
    }

    public InternalTableRow(ITable table, ITableRow row) throws ProcessingException {
        this();
        this.m_rowIndex = row.getRowIndex();
        this.m_enabled = row.isEnabled();
        this.m_checked = row.isChecked();
        this.m_status = row.getStatus();
        this.m_cells = new ArrayList<Cell>(table.getColumnCount());
        int i = 0;
        while (i < table.getColumnCount()) {
            this.m_cells.add(new Cell(this, row.getCell(i)));
            ++i;
        }
        List<IColumn<?>> cols = table.getColumns();
        int i2 = 0;
        for (IColumn<?> col : cols) {
            Cell cell = this.m_cells.get(i2);
            Object value = cell.getValue();
            value = col.parseValue(this, value);
            cell.setValue(value);
            ++i2;
        }
        this.m_status = row.getStatus();
        this.m_table = table;
    }

    @Override
    public int getRowIndex() {
        return this.m_rowIndex;
    }

    public void setRowIndex(int index) {
        this.m_rowIndex = index;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatus(int status) {
        try {
            this.setRowChanging(true);
            if (this.m_status != status) {
                this.m_status = status;
                this.m_rowPropertiesChanged = true;
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public boolean isStatusInserted() {
        return this.m_status == 1;
    }

    @Override
    public void setStatusInserted() {
        this.setStatus(1);
    }

    @Override
    public boolean isStatusUpdated() {
        return this.m_status == 2;
    }

    @Override
    public void setStatusUpdated() {
        this.setStatus(2);
    }

    @Override
    public boolean isStatusDeleted() {
        return this.m_status == 3;
    }

    @Override
    public void setStatusDeleted() {
        this.setStatus(3);
    }

    @Override
    public boolean isStatusNonchanged() {
        return this.m_status == 0;
    }

    @Override
    public void setStatusNonchanged() {
        this.setStatus(0);
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public void setEnabled(boolean b) {
        try {
            this.setRowChanging(true);
            this.m_enabled = b;
            for (Cell c : this.m_cells) {
                c.setEnabled(this.m_enabled);
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public boolean isSelected() {
        return this.getTable().isSelectedRow(this);
    }

    @Override
    public boolean isChecked() {
        return this.m_checked;
    }

    @Override
    public void setChecked(boolean b) {
        block9: {
            if (this.m_checked != b) {
                try {
                    this.setRowChanging(true);
                    this.m_checked = b;
                    this.m_rowPropertiesChanged = true;
                    ITable table = this.getTable();
                    if (table == null) break block9;
                    if (table.getCheckableColumn() != null) {
                        try {
                            table.getCheckableColumn().setValue(this, Boolean.valueOf(b));
                        }
                        catch (ProcessingException e) {
                            LOG.warn("Value could not be set on CheckableColumn", (Throwable)e);
                        }
                    }
                    if (b && !table.isMultiCheck()) {
                        for (ITableRow cr : table.getCheckedRows()) {
                            if (cr == this) continue;
                            cr.setChecked(false);
                        }
                    }
                }
                finally {
                    this.setRowChanging(false);
                }
            }
        }
    }

    @Override
    public boolean isFilterAccepted() {
        return this.m_filterAccepted;
    }

    public void setFilterAcceptedInternal(boolean b) {
        this.m_filterAccepted = b;
    }

    @Override
    public int getCellCount() {
        return this.m_cells.size();
    }

    @Override
    public ICell getCell(IColumn column) {
        return this.getCell(column.getColumnIndex());
    }

    @Override
    public ICell getCell(int columnIndex) {
        return this.getCellForUpdate(columnIndex);
    }

    @Override
    public void setCell(IColumn column, ICell cell) throws ProcessingException {
        this.setCell(column.getColumnIndex(), cell);
    }

    @Override
    public void setCell(int columnIndex, ICell cell) throws ProcessingException {
        if (cell != null) {
            try {
                this.setRowChanging(true);
                this.m_cells.set(columnIndex, new Cell(this, cell));
            }
            finally {
                this.setRowChanging(false);
            }
        }
    }

    @Override
    public Cell getCellForUpdate(IColumn column) {
        return this.getCellForUpdate(column.getColumnIndex());
    }

    @Override
    public Cell getCellForUpdate(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.m_cells.size()) {
            return new Cell();
        }
        return this.m_cells.get(columnIndex);
    }

    @Override
    public Object getCellValue(int columnIndex) {
        return this.getCell(columnIndex).getValue();
    }

    @Override
    public List<Object> getKeyValues() {
        int[] keyColumns = this.getTable().getColumnSet().getKeyColumnIndexes();
        if (keyColumns.length == 0) {
            keyColumns = this.getTable().getColumnSet().getAllColumnIndexes();
        }
        ArrayList<Object> pk = new ArrayList<Object>();
        int[] nArray = keyColumns;
        int n = keyColumns.length;
        int n2 = 0;
        while (n2 < n) {
            int keyIndex = nArray[n2];
            pk.add(this.getCell(keyIndex).getValue());
            ++n2;
        }
        return pk;
    }

    @Override
    public boolean isRowChanging() {
        return this.m_rowChanging > 0;
    }

    @Override
    public void setRowChanging(boolean b) {
        if (b) {
            ++this.m_rowChanging;
        } else {
            --this.m_rowChanging;
            if (this.m_rowChanging == 0 && this.m_rowPropertiesChanged) {
                this.m_rowPropertiesChanged = false;
                if (this.getTable() != null) {
                    this.getTable().updateRow(this);
                }
            }
        }
    }

    @Override
    public boolean isRowPropertiesChanged() {
        return this.m_rowPropertiesChanged;
    }

    @Override
    public void setRowPropertiesChanged(boolean b) {
        this.m_rowPropertiesChanged = b;
    }

    @Override
    public boolean setCellValue(int columnIndex, Object value) throws ProcessingException {
        return this.getCellForUpdate(columnIndex).setValue(value);
    }

    @Override
    public boolean setCellValues(List<? extends Object> values) throws ProcessingException {
        boolean changed = false;
        int i = 0;
        while (i < values.size()) {
            boolean b = this.setCellValue(i, values.get(i));
            changed = changed || b;
            ++i;
        }
        return changed;
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    public void setTableInternal(ITable table) {
        this.m_table = table;
    }

    @Override
    public void touch() throws ProcessingException {
        try {
            this.setRowChanging(true);
            this.m_rowPropertiesChanged = true;
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void delete() throws ProcessingException {
        if (this.getTable() != null) {
            this.getTable().deleteRow(this);
        }
    }

    @Override
    public void setBackgroundColor(String c) {
        try {
            this.setRowChanging(true);
            for (Cell cell : this.m_cells) {
                cell.setBackgroundColor(c);
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void setForegroundColor(String c) {
        try {
            this.setRowChanging(true);
            for (Cell cell : this.m_cells) {
                cell.setForegroundColor(c);
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void setFont(FontSpec f) {
        try {
            this.setRowChanging(true);
            for (Cell cell : this.m_cells) {
                cell.setFont(f);
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void setTooltipText(String s) {
        try {
            this.setRowChanging(true);
            for (Cell cell : this.m_cells) {
                cell.setTooltipText(s);
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void setIconId(String id) {
        try {
            this.setRowChanging(true);
            this.m_iconId = id;
            this.m_rowPropertiesChanged = true;
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public void moveToTop() {
        if (this.getTable() != null) {
            this.getTable().moveRow(this.getRowIndex(), 0);
        }
    }

    @Override
    public void moveToBottom() {
        if (this.getTable() != null) {
            this.getTable().moveRow(this.getRowIndex(), this.getTable().getRowCount());
        }
    }

    @Override
    public void moveUp() {
        if (this.getTable() != null) {
            this.getTable().moveRow(this.getRowIndex(), this.getRowIndex() - 1);
        }
    }

    @Override
    public void moveDown() {
        if (this.getTable() != null) {
            this.getTable().moveRow(this.getRowIndex(), this.getRowIndex() + 1);
        }
    }

    @Override
    public Object validateValue(ICell cell, Object value) throws ProcessingException {
        Object oldValue = cell.getValue();
        if (CompareUtility.equals((Object)oldValue, (Object)value)) {
            return value;
        }
        if (this.getTable() != null) {
            int colIndex = -1;
            int i = 0;
            while (i < this.m_cells.size()) {
                if (this.getCell(i) == cell) {
                    colIndex = i;
                    break;
                }
                ++i;
            }
            if (colIndex >= 0) {
                IColumn column = this.getTable().getColumnSet().getColumn(colIndex);
                value = column.parseValue(this, value);
            }
        }
        return value;
    }

    @Override
    public void cellChanged(ICell cell, int changedBit) {
        try {
            this.setRowChanging(true);
            if (changedBit == 1 && this.isStatusNonchanged()) {
                this.setStatusUpdated();
            }
            this.m_rowPropertiesChanged = true;
        }
        finally {
            this.setRowChanging(false);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + VerboseUtility.dumpObjects((Object[])this.m_cells.toArray()) + "]";
    }
}

