/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;

public abstract class AbstractFormHandler
implements IFormHandler {
    private IForm m_form;
    private boolean m_openExclusive;

    public AbstractFormHandler() {
        this.initConfig();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    protected boolean getConfiguredGuiLess() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    protected boolean getConfiguredOpenExclusive() {
        return false;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execLoad() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execPostLoad() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=40.0)
    protected boolean execCheckFields() throws ProcessingException {
        return true;
    }

    @ConfigOperation
    @Order(value=50.0)
    protected boolean execValidate() throws ProcessingException {
        return true;
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execStore() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execDiscard() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execFinally() throws ProcessingException {
    }

    protected void initConfig() {
        this.setOpenExclusive(this.getConfiguredOpenExclusive());
    }

    @Override
    public void setOpenExclusive(boolean openExclusive) {
        this.m_openExclusive = openExclusive;
    }

    @Override
    public boolean isOpenExclusive() {
        return this.m_openExclusive;
    }

    @Override
    public IForm getForm() {
        return this.m_form;
    }

    @Override
    public void setFormInternal(IForm form) {
        this.m_form = form;
    }

    @Override
    public String getHandlerId() {
        String s = this.getClass().getName();
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    @Override
    public boolean isGuiLess() {
        return this.getConfiguredGuiLess();
    }

    @Override
    public final void onLoad() throws ProcessingException {
        try {
            this.execLoad();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public final void onPostLoad() throws ProcessingException {
        try {
            this.execPostLoad();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public final boolean onCheckFields() throws ProcessingException {
        try {
            return this.execCheckFields();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public final boolean onValidate() throws ProcessingException {
        try {
            return this.execValidate();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public final void onStore() throws ProcessingException {
        try {
            this.execStore();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public final void onDiscard() throws ProcessingException {
        try {
            this.execDiscard();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }

    @Override
    public final void onFinally() throws ProcessingException {
        try {
            this.execFinally();
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ProcessingException("Unexpected", e);
        }
    }
}

