/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.DefaultFormFieldInjection;
import org.eclipse.scout.rt.client.ui.form.FormFieldInjectionThreadLocal;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.snapbox.AbstractSnapBox;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.AbstractSplitBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.AbstractTabBox;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.IWrappedFormField;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="4a641cd4-801f-45d2-9f08-5798e20b03c4")
public abstract class AbstractCompositeField
extends AbstractFormField
implements ICompositeField {
    private List<IFormField> m_fields;
    private Map<Class<?>, Class<? extends IFormField>> m_formFieldReplacements;

    public AbstractCompositeField() {
        this(true);
    }

    public AbstractCompositeField(boolean callInitializer) {
        super(callInitializer);
    }

    protected List<Class<? extends IFormField>> getConfiguredFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation(Arrays.asList(dca), IFormField.class);
    }

    @Override
    protected boolean execCalculateVisible() {
        return true;
    }

    @Override
    protected void initConfig() {
        this.m_fields = CollectionUtility.emptyArrayList();
        super.initConfig();
        DefaultFormFieldInjection injectedFields = null;
        ArrayList<Class<? extends IFormField>> configuredFields = new ArrayList<Class<? extends IFormField>>();
        for (Class<? extends IFormField> clazz : this.getConfiguredFields()) {
            if (ConfigurationUtility.isInjectFieldAnnotationPresent(clazz)) {
                if (injectedFields == null) {
                    injectedFields = new DefaultFormFieldInjection(this);
                }
                injectedFields.addField(clazz);
                continue;
            }
            configuredFields.add(clazz);
        }
        ArrayList<IFormField> fieldList = new ArrayList<IFormField>();
        try {
            if (injectedFields != null) {
                FormFieldInjectionThreadLocal.push(injectedFields);
            }
            this.filterFieldsInternal(configuredFields);
            for (Class clazz : configuredFields) {
                try {
                    IFormField f = (IFormField)ConfigurationUtility.newInnerInstance((Object)this, (Class)clazz);
                    fieldList.add(f);
                }
                catch (Throwable t) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + clazz.getName() + "'.", t));
                }
            }
            this.injectFieldsInternal(fieldList);
        }
        finally {
            if (injectedFields != null) {
                this.m_formFieldReplacements = injectedFields.getReplacementMapping();
                FormFieldInjectionThreadLocal.pop(injectedFields);
            }
        }
        for (IFormField iFormField : fieldList) {
            iFormField.setParentFieldInternal(this);
        }
        this.m_fields = fieldList;
        for (IFormField iFormField : this.m_fields) {
            iFormField.addPropertyChangeListener(new P_FieldPropertyChangeListener());
        }
        this.handleFieldVisibilityChanged();
    }

    protected void filterFieldsInternal(List<Class<? extends IFormField>> fieldList) {
        FormFieldInjectionThreadLocal.filterFields(this, fieldList);
    }

    protected void injectFieldsInternal(List<IFormField> fieldList) {
        FormFieldInjectionThreadLocal.injectFields(this, fieldList);
    }

    @Override
    public void setFormInternal(IForm form) {
        super.setFormInternal(form);
        if (form instanceof AbstractForm && this == form.getRootGroupBox()) {
            ((AbstractForm)form).registerFormFieldReplacementsInternal(this.m_formFieldReplacements);
        }
        for (IFormField field : this.m_fields) {
            field.setFormInternal(form);
        }
    }

    @Override
    public void setParentFieldInternal(ICompositeField parentField) {
        super.setParentFieldInternal(parentField);
        if (!(parentField instanceof AbstractCompositeField)) {
            return;
        }
        if (this.isTemplateField()) {
            return;
        }
        ((AbstractCompositeField)parentField).registerFormFieldReplacements(this.m_formFieldReplacements);
    }

    protected boolean isTemplateField() {
        Class<?> c = this.getClass();
        while (c.getSuperclass() != null) {
            if (!Modifier.isAbstract((c = c.getSuperclass()).getModifiers())) continue;
            if (CompareUtility.isOneOf(c, (Object[])new Object[]{AbstractCompositeField.class, AbstractGroupBox.class, AbstractSequenceBox.class, AbstractSnapBox.class, AbstractSplitBox.class, AbstractTabBox.class})) {
                return false;
            }
            Class<?>[] classArray = c.getDeclaredClasses();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> innerClass = classArray[n2];
                int m = innerClass.getModifiers();
                if (Modifier.isPublic(m) && !Modifier.isAbstract(m) && IFormField.class.isAssignableFrom(innerClass)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public int getFieldIndex(IFormField f) {
        return this.m_fields.indexOf(f);
    }

    @Override
    public int getFieldCount() {
        return this.m_fields.size();
    }

    @Override
    public IFormField getFieldById(final String id) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (IFormField)found.getValue();
    }

    @Override
    public <T extends IFormField> T getFieldById(final String id, final Class<T> type) {
        final Holder found = new Holder(type);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (type.isAssignableFrom(field.getClass()) && field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (T)((IFormField)found.getValue());
    }

    @Override
    public <T extends IFormField> T getFieldByClass(Class<T> c) {
        final Class<T> formFieldClass = this.getReplacingFieldClass(c);
        final Holder found = new Holder(c);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getClass() == formFieldClass) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (T)((IFormField)found.getValue());
    }

    private void registerFormFieldReplacements(Map<Class<?>, Class<? extends IFormField>> replacements) {
        if (replacements == null || replacements.isEmpty()) {
            return;
        }
        if (this.m_formFieldReplacements == null) {
            this.m_formFieldReplacements = new HashMap();
        }
        this.m_formFieldReplacements.putAll(replacements);
    }

    private <T extends IFormField> Class<? extends T> getReplacingFieldClass(Class<T> c) {
        Class<? extends IFormField> replacementFieldClass;
        Map<Class<?>, Class<IFormField>> mapping;
        Class<? extends IFormField> replacementFieldClass2;
        if (this.m_formFieldReplacements != null && (replacementFieldClass2 = this.m_formFieldReplacements.get(c)) != null) {
            return replacementFieldClass2;
        }
        IForm form = this.getForm();
        if (form instanceof AbstractForm && (mapping = ((AbstractForm)form).getFormFieldReplacementsInternal()) != null && (replacementFieldClass = mapping.get(c)) != null) {
            return replacementFieldClass;
        }
        ICompositeField parentField = this.getParentField();
        while (parentField != null) {
            Class<? extends IFormField> replacementFieldClass3;
            Map<Class<?>, Class<IFormField>> parentReplacements;
            if (parentField instanceof AbstractCompositeField && (parentReplacements = ((AbstractCompositeField)parentField).m_formFieldReplacements) != null && (replacementFieldClass3 = parentReplacements.get(c)) != null) {
                return replacementFieldClass3;
            }
            parentField = parentField.getParentField();
        }
        return c;
    }

    @Override
    public List<IFormField> getFields() {
        return CollectionUtility.arrayList(this.m_fields);
    }

    @Override
    public boolean visitFields(IFormFieldVisitor visitor, int startLevel) {
        if (!visitor.visitField(this, startLevel, 0)) {
            return false;
        }
        int index = 0;
        for (IFormField field : this.m_fields) {
            if (field instanceof ICompositeField ? !((ICompositeField)field).visitFields(visitor, startLevel + 1) : (field instanceof IWrappedFormField ? !((IWrappedFormField)field).visitFields(visitor, startLevel + 1) : !visitor.visitField(field, startLevel, index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Override
    protected boolean execIsSaveNeeded() throws ProcessingException {
        for (IFormField f : this.m_fields) {
            if (!f.isSaveNeeded()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void execMarkSaved() throws ProcessingException {
        super.execMarkSaved();
        for (IFormField f : this.m_fields) {
            f.markSaved();
        }
    }

    @Override
    protected boolean execIsEmpty() throws ProcessingException {
        for (IFormField f : this.m_fields) {
            if (f.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setMandatory(boolean b) {
        for (IFormField f : this.m_fields) {
            f.setMandatory(b);
        }
    }

    @Override
    public void setEnabledGranted(boolean b) {
        super.setEnabledGranted(b);
        for (IFormField f : this.getFields()) {
            if (f.getEnabledPermission() != null) continue;
            f.setEnabledGranted(b);
        }
    }

    @Override
    public void setVisibleGranted(boolean b) {
        super.setVisibleGranted(b);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.isInitialized()) {
            for (IFormField f : this.m_fields) {
                f.setEnabled(b);
            }
        }
    }

    protected void handleFieldVisibilityChanged() {
        int visCount = 0;
        for (IFormField field : this.m_fields) {
            if (!field.isVisible()) continue;
            ++visCount;
        }
        this.setVisibleFieldCount(visCount);
        this.calculateVisibleInternal();
    }

    @Override
    public void rebuildFieldGrid() {
    }

    private void setVisibleFieldCount(int n) {
        this.propertySupport.setPropertyInt("visibleFieldCount", n);
    }

    protected int getVisibleFieldCount() {
        return this.propertySupport.getPropertyInt("visibleFieldCount");
    }

    private class P_FieldPropertyChangeListener
    implements PropertyChangeListener {
        private P_FieldPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("visible")) {
                AbstractCompositeField.this.handleFieldVisibilityChanged();
            } else if (e.getPropertyName().equals("saveNeeded")) {
                AbstractCompositeField.this.checkSaveNeeded();
            } else if (e.getPropertyName().equals("empty")) {
                AbstractCompositeField.this.checkEmpty();
            }
        }
    }
}

