/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.decimalfield;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.decimalfield.IDecimalField;
import org.eclipse.scout.rt.client.ui.form.fields.decimalfield.IDecimalFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;

@ClassId(value="f4ec575e-f572-418d-a49c-3d0811ea7540")
public abstract class AbstractDecimalField<T extends Number>
extends AbstractNumberField<T>
implements IDecimalField<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDecimalField.class);
    private IDecimalFieldUIFacade m_uiFacade;

    public AbstractDecimalField() {
        this(true);
    }

    public AbstractDecimalField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=290.0)
    protected int getConfiguredFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=240.0)
    protected int getConfiguredMinFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=250.0)
    protected int getConfiguredMaxFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredPercent() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=280.0)
    protected int getConfiguredMultiplier() {
        return 1;
    }

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @Override
    protected RoundingMode getConfiguredRoundingMode() {
        return RoundingMode.HALF_UP;
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.setMinFractionDigits(this.getConfiguredMinFractionDigits());
        this.setMaxFractionDigits(this.getConfiguredMaxFractionDigits());
        this.setGroupingUsed(this.getConfiguredGroupingUsed());
        this.setPercent(this.getConfiguredPercent());
        this.setFractionDigits(this.getConfiguredFractionDigits());
        this.setMultiplier(this.getConfiguredMultiplier());
        if (this.getConfiguredFormat() != null) {
            this.getFormatInternal().applyPattern(this.getConfiguredFormat());
        }
    }

    @Override
    public void setMinFractionDigits(int i) {
        try {
            this.setFieldChanging(true);
            DecimalFormat format = this.getFormat();
            format.setMinimumFractionDigits(i);
            this.setFormat(format);
            if (this.isInitialized() && this.shouldUpdateDisplayText(false)) {
                this.setDisplayText(this.execFormatValue((Number)this.getValue()));
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public int getMinFractionDigits() {
        return this.getFormatInternal().getMinimumFractionDigits();
    }

    @Override
    public void setMaxFractionDigits(int i) {
        try {
            this.setFieldChanging(true);
            DecimalFormat format = this.getFormat();
            format.setMaximumFractionDigits(i);
            this.setFormat(format);
            if (this.isInitialized() && this.shouldUpdateDisplayText(false)) {
                this.setDisplayText(this.execFormatValue((Number)this.getValue()));
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public int getMaxFractionDigits() {
        return this.getFormatInternal().getMaximumFractionDigits();
    }

    @Override
    public void setPercent(boolean b) {
        try {
            DecimalFormat percentDF = (DecimalFormat)DecimalFormat.getPercentInstance(LocaleThreadLocal.get());
            DecimalFormat format = this.getFormat();
            if (b) {
                format.setPositiveSuffix(percentDF.getPositiveSuffix());
                format.setNegativeSuffix(percentDF.getNegativeSuffix());
            } else if (this.isPercent()) {
                format.setPositiveSuffix("");
                format.setNegativeSuffix("");
            }
            this.setFormat(format);
            if (this.isInitialized() && this.shouldUpdateDisplayText(false)) {
                this.setDisplayText(this.execFormatValue((Number)this.getValue()));
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public boolean isPercent() {
        DecimalFormat percentDF = (DecimalFormat)DecimalFormat.getPercentInstance(LocaleThreadLocal.get());
        DecimalFormat internalDF = this.getFormatInternal();
        return internalDF.getPositiveSuffix().equals(percentDF.getPositiveSuffix()) && internalDF.getNegativeSuffix().equals(percentDF.getNegativeSuffix());
    }

    @Override
    public void setFractionDigits(int i) {
        try {
            this.propertySupport.setPropertyInt("parsingFractionDigits", i);
            if (this.isInitialized()) {
                this.setValue((Number)this.getValue());
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public int getFractionDigits() {
        return this.propertySupport.getPropertyInt("parsingFractionDigits");
    }

    @Override
    public void setMultiplier(int i) {
        try {
            DecimalFormat format = this.getFormat();
            format.setMultiplier(i);
            this.setFormat(format);
            if (this.isInitialized()) {
                this.setValue((Number)this.getValue());
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public int getMultiplier() {
        return this.getFormatInternal().getMultiplier();
    }

    @Override
    public IDecimalFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    protected BigDecimal roundParsedValue(BigDecimal valBeforeRounding) {
        int additionalFractionDigits = ("" + Math.abs(this.getMultiplier())).length() - 1;
        int precision = valBeforeRounding.toBigInteger().toString().length() + this.getFractionDigits() + additionalFractionDigits;
        return valBeforeRounding.round(new MathContext(precision, this.getRoundingMode()));
    }

    private class P_UIFacade
    implements IDecimalFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean setTextFromUI(String newText, boolean whileTyping) {
            if (newText != null && newText.length() == 0) {
                newText = null;
            }
            AbstractDecimalField.this.setWhileTyping(whileTyping);
            return AbstractDecimalField.this.parseValue(newText);
        }
    }
}

