/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.documentfield;

import java.util.EventObject;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.documentfield.IDocumentField;

public class DocumentFieldEvent
extends EventObject {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DocumentFieldEvent.class);
    private static final long serialVersionUID = 1L;
    public static final int TYPE_SAVE_AS = 10;
    public static final int TYPE_SAVE_NEEDED = 12;
    public static final int TYPE_AUTORESIZE_DOCUMENT = 20;
    private final int m_type;
    private final Object m_data;

    public DocumentFieldEvent(IDocumentField source, int type) {
        super(source);
        this.m_type = type;
        this.m_data = null;
    }

    public DocumentFieldEvent(IDocumentField source, int type, Object data) {
        super(source);
        this.m_type = type;
        this.m_data = data;
    }

    public IDocumentField getDocumentField() {
        return (IDocumentField)this.getSource();
    }

    public int getType() {
        return this.m_type;
    }

    public Object getData() {
        return this.m_data;
    }

    public String getDataString() {
        try {
            return (String)TypeCastUtility.castValue((Object)this.m_data, String.class);
        }
        catch (ClassCastException e) {
            LOG.error("Could not cast data to String");
            return null;
        }
    }

    public boolean getDataBool() {
        try {
            return (Boolean)TypeCastUtility.castValue((Object)this.m_data, Boolean.TYPE);
        }
        catch (ClassCastException e) {
            LOG.error("Could not cast data to Boolean");
            return false;
        }
    }

    public Long getDataLong() {
        try {
            return (Long)TypeCastUtility.castValue((Object)this.m_data, Long.class);
        }
        catch (ClassCastException e) {
            LOG.error("Could not cast data to Long");
            return null;
        }
    }

    public Integer getDataInt() {
        try {
            return (Integer)TypeCastUtility.castValue((Object)this.m_data, Integer.class);
        }
        catch (ClassCastException e) {
            LOG.error("Could not cast data to Integer");
            return null;
        }
    }
}

