/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.matrix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.AbstractGroupBoxBodyGrid;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.matrix.Cell;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.matrix.IGridMatrix;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.matrix.MatrixCursor;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.matrix.MatrixIndex;

public class VerticalGridMatrix
implements IGridMatrix {
    private MatrixCursor m_cursor;
    private final Map<IFormField, GridData> m_fieldGridDatas = new HashMap<IFormField, GridData>();
    private final Map<MatrixIndex, Cell> m_cells = new HashMap<MatrixIndex, Cell>();
    private final Map<IFormField, Integer> m_formFieldIndexes = new HashMap<IFormField, Integer>();

    public VerticalGridMatrix(int columnCount, int rowCount) {
        this(0, 0, columnCount, rowCount);
    }

    public VerticalGridMatrix(int x, int y, int columnCount, int rowCount) {
        this.m_cursor = new MatrixCursor(x, y, columnCount, rowCount, MatrixCursor.Orientation.Vertical);
    }

    public void resetAll(int columnCount, int rowCount) {
        this.m_fieldGridDatas.clear();
        this.m_cells.clear();
        this.m_formFieldIndexes.clear();
        this.m_cursor = new MatrixCursor(this.m_cursor.startX, this.m_cursor.startY, columnCount, rowCount, MatrixCursor.Orientation.Vertical);
    }

    @Override
    public boolean computeGridData(List<IFormField> fields) {
        int i = 0;
        for (IFormField field : fields) {
            this.m_formFieldIndexes.put(field, i++);
            GridData gridData = AbstractGroupBoxBodyGrid.getGridDataFromHints(field, this.m_cursor.columnCount);
            if (this.add(field, gridData)) {
                this.m_fieldGridDatas.put(field, gridData);
                continue;
            }
            return false;
        }
        return true;
    }

    public GridData getGridData(IFormField field) {
        return this.m_fieldGridDatas.get(field);
    }

    private boolean add(IFormField field, GridData data) {
        MatrixIndex currentIndex = this.m_cursor.currentIndex();
        if (data.w > 1) {
            int x = currentIndex.x;
            int y = currentIndex.y;
            while (x + data.w > this.m_cursor.startX + this.m_cursor.columnCount) {
                --x;
                y = this.m_cursor.rowCount - 1;
            }
            this.reorganizeGridAbove(x, y, data.w);
        }
        if (!this.nextFree(data.w, data.h)) {
            return false;
        }
        currentIndex = this.m_cursor.currentIndex();
        data.x = currentIndex.x;
        data.y = currentIndex.y;
        int xx = currentIndex.x;
        while (xx < currentIndex.x + data.w) {
            int yy = currentIndex.y;
            while (yy < currentIndex.y + data.h) {
                this.m_cells.put(new MatrixIndex(xx, yy), new Cell(field, data));
                ++yy;
            }
            ++xx;
        }
        return true;
    }

    private void reorganizeGridAbove(int x, int y, int w) {
        HashSet<IFormField> fieldsToReorganize = new HashSet<IFormField>();
        HashMap<MatrixIndex, Cell> occupiedCells = new HashMap<MatrixIndex, Cell>();
        Bounds reorgBounds = new Bounds(x, 0, w, y + 1);
        int minY = y;
        int usedCells = 0;
        boolean continueLoop = true;
        int yi = y;
        while (yi >= 0 && continueLoop) {
            int xi = x;
            while (xi < x + w && continueLoop) {
                MatrixIndex matrixIndex = new MatrixIndex(xi, yi);
                Cell cell = this.m_cells.get(matrixIndex);
                if (cell != null && !cell.isEmpty()) {
                    GridData gd = cell.fieldGridData;
                    if (VerticalGridMatrix.horizontalMatchesOrOverlaps(reorgBounds, gd)) {
                        continueLoop = false;
                    } else if (VerticalGridMatrix.horizontalOverlapsOnSide(reorgBounds, gd)) {
                        occupiedCells.put(matrixIndex, cell);
                        ++usedCells;
                        minY = Math.min(matrixIndex.y, minY);
                    } else {
                        this.m_cells.remove(matrixIndex);
                        fieldsToReorganize.add(cell.field);
                        ++usedCells;
                        minY = Math.min(matrixIndex.y, minY);
                    }
                }
                ++xi;
            }
            --yi;
        }
        if (fieldsToReorganize.isEmpty()) {
            return;
        }
        ArrayList<IFormField> sortedFieldsToReorganize = new ArrayList<IFormField>(fieldsToReorganize);
        Collections.sort(sortedFieldsToReorganize, new Comparator<IFormField>(){

            @Override
            public int compare(IFormField o1, IFormField o2) {
                Integer i1 = (Integer)VerticalGridMatrix.this.m_formFieldIndexes.get(o1);
                Integer i2 = (Integer)VerticalGridMatrix.this.m_formFieldIndexes.get(o2);
                return i1.compareTo(i2);
            }
        });
        reorgBounds.y = minY;
        VerticalGridMatrix reorgMatrix = new VerticalGridMatrix(reorgBounds.x, reorgBounds.y, reorgBounds.w, (usedCells + reorgBounds.w - 1) / reorgBounds.w);
        reorgMatrix.addCells(occupiedCells);
        while (!reorgMatrix.computeGridData(sortedFieldsToReorganize)) {
            reorgMatrix.resetAll(reorgMatrix.getColumnCount(), reorgMatrix.getRowCount() + 1);
        }
        this.m_cursor.reset();
        this.m_cells.putAll(reorgMatrix.getCells());
        this.m_fieldGridDatas.putAll(reorgMatrix.getFieldGridDatas());
    }

    private boolean nextFree(int w, int h) {
        if (!this.m_cursor.increment()) {
            return false;
        }
        MatrixIndex currentIndex = this.m_cursor.currentIndex();
        if (!this.isAllCellFree(currentIndex.x, currentIndex.y, w, h)) {
            if (this.m_cells.get(currentIndex) == null) {
                this.m_cells.put(currentIndex, new Cell());
            }
            return this.nextFree(w, h);
        }
        return true;
    }

    private boolean isAllCellFree(int x, int y, int w, int h) {
        if (x + w > this.m_cursor.startX + this.m_cursor.columnCount || y + h > this.m_cursor.startY + this.m_cursor.rowCount) {
            return false;
        }
        int xi = x;
        while (xi < x + w) {
            int yi = y;
            while (yi < y + h) {
                if (this.m_cells.get(new MatrixIndex(xi, yi)) != null) {
                    return false;
                }
                ++yi;
            }
            ++xi;
        }
        return true;
    }

    protected Map<MatrixIndex, Cell> getCells() {
        return this.m_cells;
    }

    public Map<IFormField, GridData> getFieldGridDatas() {
        return this.m_fieldGridDatas;
    }

    protected void addCells(Map<MatrixIndex, Cell> cells) {
        this.m_cells.putAll(cells);
    }

    public int getColumnCount() {
        return this.m_cursor.columnCount;
    }

    public int getRowCount() {
        return this.m_cursor.rowCount;
    }

    protected static boolean horizontalMatchesOrOverlaps(Bounds bounds, GridData gd) {
        return bounds.x >= gd.x && bounds.x + bounds.w <= gd.x + gd.w;
    }

    protected static boolean horizontalOverlapsOnSide(Bounds bounds, GridData gd) {
        return bounds.x > gd.x || bounds.x + bounds.w < gd.x + gd.w;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("----Vertical Grid Matrix [columnCount=" + this.getColumnCount() + ",rowCount=" + this.getRowCount() + "]--------------\n");
        MatrixCursor tempCursor = new MatrixCursor(0, 0, this.getColumnCount(), this.getRowCount(), MatrixCursor.Orientation.Vertical);
        while (tempCursor.increment()) {
            Cell cell = this.m_cells.get(tempCursor.currentIndex());
            builder.append("cell[").append(tempCursor.currentIndex().x).append(", ").append(tempCursor.currentIndex().y).append("] ");
            if (cell == null) {
                builder.append("NULL");
            } else if (cell.field == null) {
                builder.append("PlaceHolder");
            } else if (cell.field == null) {
                builder.append("No field");
            } else {
                builder.append(cell.field.getClass().getSimpleName()).append("/").append(cell.field.getLabel()).append("\t").append(cell.field.getGridData());
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    protected static final class Bounds {
        public int x;
        public int y;
        public int w;
        public int h;

        public Bounds(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

