/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.longfield;

import java.math.BigDecimal;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.longfield.ILongField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;

@ClassId(value="cfc961a1-195f-491d-94c5-762f9d86efee")
public abstract class AbstractLongField
extends AbstractNumberField<Long>
implements ILongField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractLongField.class);

    public AbstractLongField() {
        this(true);
    }

    public AbstractLongField(boolean callInitializer) {
        super(callInitializer);
    }

    @Deprecated
    protected Long getConfiguredMinimumValue() {
        return this.getConfiguredMinValue();
    }

    @Deprecated
    protected Long getConfiguredMaximumValue() {
        return this.getConfiguredMaxValue();
    }

    @Override
    @ConfigProperty(value="LONG")
    @Order(value=250.0)
    @ValidationRule(value="minValue")
    protected Long getConfiguredMinValue() {
        return Long.MIN_VALUE;
    }

    @Override
    @ConfigProperty(value="LONG")
    @Order(value=260.0)
    @ValidationRule(value="maxValue")
    protected Long getConfiguredMaxValue() {
        return Long.MAX_VALUE;
    }

    @Override
    @Order(value=270.0)
    @ConfigProperty(value="INTEGER")
    protected int getConfiguredMaxIntegerDigits() {
        return 19;
    }

    @Override
    protected Long getMinPossibleValue() {
        return Long.MIN_VALUE;
    }

    @Override
    protected Long getMaxPossibleValue() {
        return Long.MAX_VALUE;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMinValue(this.getConfiguredMinimumValue());
        this.setMaxValue(this.getConfiguredMaximumValue());
    }

    @Override
    protected Long parseValueInternal(String text) throws ProcessingException {
        Long retVal = null;
        BigDecimal parsedVal = this.parseToBigDecimalInternal(text);
        if (parsedVal != null) {
            retVal = parsedVal.longValueExact();
        }
        return retVal;
    }
}

