/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal;

import org.eclipse.scout.commons.BeanUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.IPageExtensionFilter;
import org.eclipse.scout.rt.extension.client.ui.desktop.outline.pages.internal.AbstractPageExtension;

public class PageContributionExtension
extends AbstractPageExtension {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PageContributionExtension.class);
    private final Class<? extends IPage> m_pageClass;
    private final double m_order;

    public PageContributionExtension(Class<? extends IPage> pageClass, double order) {
        this(null, pageClass, order);
    }

    public PageContributionExtension(IPageExtensionFilter pageFilter, Class<? extends IPage> pageClass, double order) {
        super(pageFilter);
        this.m_pageClass = pageClass;
        this.m_order = order;
    }

    public Class<? extends IPage> getPageClass() {
        return this.m_pageClass;
    }

    public double getOrder() {
        return this.m_order;
    }

    public IPage createContribution(IOutline outline, IPageWithNodes parentPage) throws ProcessingException {
        IPage page;
        if (outline == null) {
            throw new IllegalArgumentException("outline must not be null");
        }
        if (parentPage != null) {
            page = (IPage)BeanUtility.createInstance(this.getPageClass(), (Object[])new Object[]{parentPage});
            if (page != null) {
                return page;
            }
            page = (IPage)BeanUtility.createInstance(this.getPageClass(), (Object[])new Object[]{outline, parentPage});
            if (page != null) {
                return page;
            }
            page = (IPage)BeanUtility.createInstance(this.getPageClass(), (Object[])new Object[]{parentPage, outline});
            if (page != null) {
                return page;
            }
        }
        if ((page = (IPage)BeanUtility.createInstance(this.getPageClass(), (Object[])new Object[]{outline})) != null) {
            return page;
        }
        page = (IPage)BeanUtility.createInstance(this.getPageClass(), (Object[])new Object[]{outline, parentPage});
        if (page != null) {
            return page;
        }
        page = (IPage)BeanUtility.createInstance(this.getPageClass(), (Object[])new Object[]{parentPage, outline});
        if (page != null) {
            return page;
        }
        page = (IPage)BeanUtility.createInstance(this.getPageClass(), (Object[])new Object[0]);
        if (page != null) {
            return page;
        }
        if (parentPage == null && (page = (IPage)BeanUtility.createInstance(this.getPageClass(), (Object[])new Object[1])) != null) {
            return page;
        }
        throw new ProcessingException("Cannot create new instance of class [" + this.getPageClass() + "] with arguments outline=[" + outline + "], parentPage=[" + parentPage + "]");
    }
}

