/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servletfilter.security;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.eclipse.scout.commons.Base64Utility;
import org.eclipse.scout.commons.EncryptionUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.rt.server.commons.cache.IHttpSessionCacheService;
import org.eclipse.scout.rt.server.commons.servletfilter.FilterConfigInjection;
import org.eclipse.scout.rt.server.commons.servletfilter.security.AbstractChainableSecurityFilter;
import org.eclipse.scout.rt.server.commons.servletfilter.security.PrincipalHolder;
import org.eclipse.scout.service.SERVICES;

public class DataSourceSecurityFilter
extends AbstractChainableSecurityFilter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DataSourceSecurityFilter.class);
    public static final String PROP_BASIC_ATTEMPT = "DataSourceSecurityFilter.basicAttempt";
    private String m_jdbcUserName;
    private String m_jdbcPassword;
    private String m_jdbcDriverName;
    private String m_jdbcMappingName;
    private String m_selectStatement;
    private boolean m_useJndiConnection;
    private String m_jndiName;
    private String m_jndiInitialContextFactory;
    private String m_jndiProviderUrl;
    private String m_jndiUrlPkgPrefixes;

    @Override
    public void init(FilterConfig config0) throws ServletException {
        super.init(config0);
        FilterConfigInjection.FilterConfig config = new FilterConfigInjection(config0, this.getClass()).getAnyConfig();
        String useJndiConnectionString = config.getInitParameter("useJndiConnection");
        this.m_useJndiConnection = Boolean.parseBoolean(useJndiConnectionString);
        this.m_jdbcDriverName = this.getInitParam(config, "jdbcDriverName", !this.m_useJndiConnection);
        this.m_jdbcMappingName = this.getInitParam(config, "jdbcMappingName", !this.m_useJndiConnection);
        this.m_jdbcUserName = this.getInitParam(config, "jdbcUsername", false);
        this.m_jdbcPassword = this.getInitParam(config, "jdbcPassword", false);
        this.m_selectStatement = this.getInitParam(config, "selectUserPass", !this.m_useJndiConnection);
        this.m_jndiName = this.getInitParam(config, "jndiName", this.m_useJndiConnection);
        this.m_jndiInitialContextFactory = config.getInitParameter("jndiInitialContextFactory");
        this.m_jndiProviderUrl = config.getInitParameter("jndiProviderUrl");
        this.m_jndiUrlPkgPrefixes = config.getInitParameter("jndiUrlPkgPrefixes");
    }

    private String getInitParam(FilterConfig filterConfig, String paramName, boolean requierd) throws ServletException {
        String paramValue = filterConfig.getInitParameter(paramName);
        if (requierd && paramValue == null) {
            throw new ServletException("Missing init-param with name '" + paramName + "'.");
        }
        return paramValue;
    }

    @Override
    protected int negotiate(HttpServletRequest req, HttpServletResponse resp, PrincipalHolder holder) throws IOException, ServletException {
        int attempts;
        String h = req.getHeader("Authorization");
        if (h != null && h.matches("Basic .*")) {
            String passEncrypted;
            String[] a = new String(Base64Utility.decode((String)h.substring(6)), "ISO-8859-1").split(":", 2);
            String user = a[0].toLowerCase();
            String pass = a[1];
            if (user != null && pass != null && this.isValidUser(user, passEncrypted = this.encryptPass(pass))) {
                holder.setPrincipal((Principal)new SimplePrincipal(user));
                return 3;
            }
        }
        if ((attempts = this.getBasicAttempt(req, resp)) > 2) {
            return 1;
        }
        this.setBasicAttept(req, resp, attempts + 1);
        resp.setHeader("WWW-Authenticate", "Basic realm=\"" + this.getRealm() + "\"");
        return 1;
    }

    private int getBasicAttempt(HttpServletRequest req, HttpServletResponse res) {
        int basicAtttempt = 0;
        Object attribute = ((IHttpSessionCacheService)SERVICES.getService(IHttpSessionCacheService.class)).getAndTouch(PROP_BASIC_ATTEMPT, req, res);
        if (attribute instanceof Integer) {
            basicAtttempt = (Integer)attribute;
        }
        return basicAtttempt;
    }

    private void setBasicAttept(HttpServletRequest req, HttpServletResponse res, int attempts) {
        ((IHttpSessionCacheService)SERVICES.getService(IHttpSessionCacheService.class)).put(PROP_BASIC_ATTEMPT, attempts, req, res);
    }

    protected boolean isValidUser(String username, String password) throws ServletException {
        Connection databaseConnection = null;
        try {
            databaseConnection = this.m_useJndiConnection ? this.createJndiConnection() : this.createJdbcDirectConnection();
            boolean bl = this.isValidUser(username, password, databaseConnection);
            return bl;
        }
        catch (Exception e) {
            LOG.error("Cannot SELECT user/pass.", (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (databaseConnection != null) {
                    databaseConnection.close();
                    databaseConnection = null;
                }
            }
            catch (SQLException e) {
                LOG.warn("Exception in close connection!", (Throwable)e);
            }
        }
    }

    protected boolean isValidUser(String username, String password, Connection connection) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(this.m_selectStatement);
            stmt.setString(1, username);
            stmt.setString(2, password);
            stmt.execute();
            ResultSet resultSet = stmt.getResultSet();
            boolean bl = resultSet.next() && resultSet.getString(1).equals(username);
            return bl;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (SQLException e) {
                LOG.warn("Exception in close stmt!", (Throwable)e);
            }
        }
    }

    protected String encryptPass(String pass) throws ServletException {
        String passEncrypted = null;
        if (pass != null) {
            try {
                passEncrypted = Base64Utility.encode((byte[])EncryptionUtility.signMD5((byte[])pass.getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error("couldn't create the password", (Throwable)e);
                throw new ServletException("couldn't create the password", (Throwable)e);
            }
        }
        return passEncrypted;
    }

    protected Connection createJdbcDirectConnection() throws ClassNotFoundException, SQLException {
        Class.forName(this.m_jdbcDriverName);
        return DriverManager.getConnection(this.m_jdbcMappingName, this.m_jdbcUserName, this.m_jdbcPassword);
    }

    protected Connection createJndiConnection() throws NamingException, SQLException {
        InitialContext initialContext = null;
        String jndiName = this.m_jndiName;
        String jndiInitialContextFactory = this.m_jndiInitialContextFactory;
        String jndiProviderUrl = this.m_jndiProviderUrl;
        String jndiUrlPkgPrefixes = this.m_jndiUrlPkgPrefixes;
        if (LOG.isInfoEnabled()) {
            LOG.info("Opening rmi connection to: " + jndiName + "," + this.m_jdbcUserName);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("  using initial context factory: " + jndiInitialContextFactory);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("  using provider url: " + jndiProviderUrl);
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        if (jndiInitialContextFactory != null) {
            ht.put("java.naming.factory.initial", jndiInitialContextFactory);
        }
        if (jndiProviderUrl != null) {
            ht.put("java.naming.provider.url", jndiProviderUrl);
        }
        if (jndiUrlPkgPrefixes != null) {
            ht.put("java.naming.factory.url.pkgs", jndiUrlPkgPrefixes);
        }
        DataSource dataSource = null;
        initialContext = ht.size() > 0 ? new InitialContext(ht) : new InitialContext();
        dataSource = (DataSource)initialContext.lookup(jndiName);
        Connection conn = this.m_jdbcUserName != null && this.m_jdbcPassword != null ? dataSource.getConnection(this.m_jdbcUserName, this.m_jdbcPassword) : dataSource.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }
}

