/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.scheduler;

import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.scheduler.AbstractScheduler;
import org.eclipse.scout.rt.server.scheduler.IScheduler;
import org.eclipse.scout.rt.server.scheduler.ISchedulerJob;
import org.eclipse.scout.rt.server.scheduler.TickSignal;
import org.eclipse.scout.rt.server.scheduler.Ticker;
import org.eclipse.scout.rt.server.services.common.session.IServerSessionRegistryService;
import org.eclipse.scout.service.SERVICES;

public class Scheduler
extends AbstractScheduler
implements IScheduler {
    private Subject m_subject;
    private IServerSession m_serverSession;

    public Scheduler(Subject subject, Class<? extends IServerSession> serverSessionType) throws ProcessingException {
        this(subject, serverSessionType, new Ticker(12));
    }

    public Scheduler(Subject subject, Class<? extends IServerSession> serverSessionType, Ticker ticker) throws ProcessingException {
        super(ticker);
        this.m_subject = subject;
        this.m_serverSession = ((IServerSessionRegistryService)SERVICES.getService(IServerSessionRegistryService.class)).newServerSession(serverSessionType, subject);
    }

    @Override
    public void handleJobExecution(final ISchedulerJob job, final TickSignal signal) throws ProcessingException {
        ServerJob serverJob = new ServerJob("Scheduler." + job.getGroupId() + "." + job.getJobId(), this.m_serverSession, this.m_subject){

            @Override
            protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
                job.run(Scheduler.this, signal);
                return Status.OK_STATUS;
            }
        };
        serverJob.schedule();
        try {
            serverJob.join();
        }
        catch (InterruptedException ie) {
            throw new ProcessingException("Interrupted", (Throwable)ie);
        }
    }
}

