/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clustersync;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.internal.Activator;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNodeStatusInfo;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotification;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationListener;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessage;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessageProperties;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterSynchronizationService;
import org.eclipse.scout.rt.server.services.common.clustersync.IPubSubMessageListener;
import org.eclipse.scout.rt.server.services.common.clustersync.IPubSubMessageService;
import org.eclipse.scout.rt.server.services.common.clustersync.internal.ClusterNotificationMessage;
import org.eclipse.scout.rt.server.services.common.clustersync.internal.ClusterNotificationMessageProperties;
import org.eclipse.scout.rt.server.services.common.clustersync.internal.ServerSessionClassFinder;
import org.eclipse.scout.rt.server.services.common.session.IServerSessionRegistryService;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.ServiceRegistration;

public class ClusterSynchronizationService
extends AbstractService
implements IClusterSynchronizationService,
IPubSubMessageListener {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ClusterSynchronizationService.class);
    private final List<IClusterNotificationListener> m_listeners = new ArrayList<IClusterNotificationListener>();
    private static final String QUEUE_NAME = "scoutNotificationQueue";
    private IPubSubMessageService m_pubSubMessageService;
    private String m_nodeId;
    private boolean m_enabled;
    private IServerSession m_session;
    private Subject m_subject;

    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        this.m_pubSubMessageService = (IPubSubMessageService)SERVICES.getService(IPubSubMessageService.class);
        this.m_nodeId = UUID.randomUUID().toString();
        this.m_subject = this.createBackendSubject();
        this.m_session = this.createBackendSession();
        this.enable();
    }

    private Subject createBackendSubject() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new SimplePrincipal("server"));
        return subject;
    }

    protected IServerSession createBackendSession() {
        Class<? extends IServerSession> sessionClazz = ServerSessionClassFinder.find();
        IServerSession serverSession = null;
        try {
            serverSession = ((IServerSessionRegistryService)SERVICES.getService(IServerSessionRegistryService.class)).newServerSession(sessionClazz, this.m_subject);
            serverSession.setIdInternal(UUID.randomUUID().toString());
        }
        catch (ProcessingException e) {
            LOG.error("Error creating backend session for cluster synchronization.", (Throwable)e);
        }
        return serverSession;
    }

    public void disposeServices() {
        super.disposeServices();
        this.disable();
    }

    @Override
    public boolean enable() {
        if (this.m_pubSubMessageService != null) {
            this.m_enabled = this.m_pubSubMessageService.subscribe(QUEUE_NAME);
            if (this.m_enabled) {
                this.m_pubSubMessageService.setListener(this);
            }
        } else {
            this.m_enabled = false;
            LOG.error("Clustersync could not be enabled. No service of type IPubSubMessageService found.");
        }
        return this.m_enabled;
    }

    public IClusterNodeStatusInfo getNodeStatus() {
        return Activator.getDefault().getClusterSynchronizationInfo();
    }

    @Override
    public boolean disable() {
        boolean unregisterSuccessful = this.m_pubSubMessageService.unsubsribe(QUEUE_NAME);
        if (unregisterSuccessful) {
            this.m_enabled = false;
        }
        return unregisterSuccessful;
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public void publishNotification(IClusterNotification notification) {
        ClusterNotificationMessage message;
        boolean successful;
        if (this.m_enabled && (successful = this.m_pubSubMessageService.publishNotification(message = new ClusterNotificationMessage(notification, this.getNotificationProperties())))) {
            Activator.getDefault().getClusterSynchronizationInfo().incrementSentMessageCount();
        }
    }

    protected IClusterNotificationMessageProperties getNotificationProperties() {
        return new ClusterNotificationMessageProperties(this.getNodeId(), ServerJob.getCurrentSession().getUserId());
    }

    public IServerSession getBackendSession() {
        return this.m_session;
    }

    public Subject getBackendSubject() {
        return this.m_subject;
    }

    protected void notifyListeners(IClusterNotificationMessage message) {
        for (IClusterNotificationListener listener : this.getListeners()) {
            listener.onNotification(message);
        }
    }

    @Override
    public void addListener(IClusterNotificationListener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public void removeListener(IClusterNotificationListener listener) {
        this.m_listeners.remove(listener);
    }

    protected List<IClusterNotificationListener> getListeners() {
        return this.m_listeners;
    }

    @Override
    public String getNodeId() {
        return this.m_nodeId;
    }

    @Override
    public void onMessage(IClusterNotificationMessage message) {
        String originNode = message.getProperties().getOriginNode();
        if (!this.m_nodeId.equals(originNode)) {
            Activator.getDefault().getClusterSynchronizationInfo().updateReceiveStatus(message);
            P_NotificationProcessingJob j = new P_NotificationProcessingJob("NotificationProcessingJob", message, this.m_listeners);
            j.runNow((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private class P_NotificationProcessingJob
    extends ServerJob {
        private final IClusterNotificationMessage m_distributedNotification;
        private final List<IClusterNotificationListener> m_listeners;

        public P_NotificationProcessingJob(String name, IClusterNotificationMessage notification, List<IClusterNotificationListener> listener) {
            super(name, ClusterSynchronizationService.this.getBackendSession(), ClusterSynchronizationService.this.getBackendSubject());
            this.m_distributedNotification = notification;
            this.m_listeners = listener;
        }

        @Override
        protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
            ClusterSynchronizationService.this.notifyListeners(this.m_distributedNotification);
            return Status.OK_STATUS;
        }
    }
}

