/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class CodeTypeCache {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CodeTypeCache.class);
    private Object m_cacheLock = new Object();
    private HashMap<Class<? extends ICodeType>, ICodeType> m_cache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ICodeType<T, ?> findCodeTypeById(T id) {
        if (id == null) {
            return null;
        }
        Object object = this.m_cacheLock;
        synchronized (object) {
            for (ICodeType ct : this.m_cache.values()) {
                if (!id.equals(ct.getId())) continue;
                return ct;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICodeType> T getCodeType(Class<T> type) {
        Object object = this.m_cacheLock;
        synchronized (object) {
            ICodeType instance = this.m_cache.get(type);
            if (instance == null) {
                try {
                    instance = (ICodeType)type.newInstance();
                    this.m_cache.put(type, instance);
                }
                catch (Throwable t) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + type.getName() + "'.", t));
                }
            }
            return (T)instance;
        }
    }

    public List<ICodeType<?, ?>> getCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) {
        ArrayList instances = new ArrayList(types.size());
        for (Class<ICodeType<?, ?>> clazz : types) {
            instances.add(this.getCodeType(clazz));
        }
        return instances;
    }

    public <CODE_ID_TYPE, CODE extends ICode<CODE_ID_TYPE>> CODE getCode(final Class<CODE> type) {
        if (type == null) {
            return null;
        }
        Class<?> declaringCodeTypeClass = null;
        if (type.getDeclaringClass() != null) {
            Class<?> c = type.getDeclaringClass();
            while (c != null && !ICodeType.class.isAssignableFrom(c)) {
                c = c.getDeclaringClass();
            }
            declaringCodeTypeClass = c;
        }
        if (declaringCodeTypeClass == null) {
            try {
                declaringCodeTypeClass = ((ICode)type.newInstance()).getCodeType().getClass();
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + type.getName() + "'.", t));
            }
        }
        Object codeType = this.getCodeType(declaringCodeTypeClass);
        final Holder codeHolder = new Holder();
        ICodeVisitor v = new ICodeVisitor<ICode<CODE_ID_TYPE>>(){

            public boolean visit(ICode<CODE_ID_TYPE> code, int treeLevel) {
                if (code.getClass() == type) {
                    codeHolder.setValue(code);
                    return false;
                }
                return true;
            }
        };
        codeType.visit(v);
        return (CODE)((ICode)codeHolder.getValue());
    }

    public <T extends ICodeType<?, ?>> T reloadCodeType(Class<T> type) {
        ArrayList codeTypeList = new ArrayList(1);
        codeTypeList.add(type);
        this.unloadCodeTypes(codeTypeList);
        return this.getCodeType(type);
    }

    public List<ICodeType<?, ?>> reloadCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) {
        this.unloadCodeTypes(types);
        return this.getCodeTypes(types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unloadCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) {
        Object object = this.m_cacheLock;
        synchronized (object) {
            for (Class<ICodeType<?, ?>> clazz : types) {
                this.m_cache.remove(clazz);
            }
        }
    }
}

