/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.builder;

import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.EntityContribution;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.FormDataStatementBuilder;
import org.eclipse.scout.rt.shared.data.form.fields.composer.ComposerAttributeNodeData;
import org.eclipse.scout.rt.shared.data.model.DataModelConstants;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;

public class DataModelAttributePartDefinition
implements DataModelConstants {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DataModelAttributePartDefinition.class);
    private final String m_whereClause;
    private final String m_selectClause;
    private final boolean m_plainBind;
    private final Class<? extends IDataModelAttribute> m_attributeType;

    public DataModelAttributePartDefinition(Class<? extends IDataModelAttribute> attributeType, String whereClause, boolean plainBind) {
        this(attributeType, whereClause, DataModelAttributePartDefinition.autoCreateSelectClause(whereClause), plainBind);
    }

    public DataModelAttributePartDefinition(Class<? extends IDataModelAttribute> attributeType, String whereClause, String selectClause, boolean plainBind) {
        this.m_attributeType = attributeType;
        this.m_whereClause = whereClause;
        this.m_selectClause = selectClause;
        this.m_plainBind = plainBind;
        this.check();
    }

    private static String autoCreateSelectClause(String whereClause) {
        if (whereClause == null) {
            return null;
        }
        String tmp = whereClause;
        tmp = StringUtility.removeTag((String)tmp, (String)"fromPart");
        tmp = StringUtility.removeTag((String)tmp, (String)"wherePart");
        if (!StringUtility.hasText((String)(tmp = StringUtility.removeTag((String)tmp, (String)"havingPart")))) {
            return null;
        }
        if ((" " + tmp).matches(".*[^a-zA-Z_$]SELECT[^a-zA-Z_$].*")) {
            return null;
        }
        return whereClause;
    }

    protected void check() {
        String low;
        if (this.m_whereClause != null && (low = this.m_whereClause.toLowerCase().replaceAll("\\s", " ")).indexOf("<attribute") >= 0 && low.indexOf("<wherepart") < 0 && low.indexOf(" and ") >= 0) {
            LOG.info(String.valueOf(this.m_attributeType.getName()) + " is a non-trivial attribute and should have the form <wherePart>... AND ...</wherePart> <attribute>...</attribute>: " + this.m_whereClause);
        }
    }

    public String getWhereClause() {
        return this.m_whereClause;
    }

    public String getSelectClause() {
        return this.m_selectClause;
    }

    public Class<? extends IDataModelAttribute> getAttributeType() {
        return this.m_attributeType;
    }

    public boolean isPlainBind() {
        return this.m_plainBind;
    }

    public EntityContribution createInstance(FormDataStatementBuilder builder, ComposerAttributeNodeData attributeNodeData, FormDataStatementBuilder.AttributeStrategy strategy, String stm, List<String> bindNames, List<Object> bindValues, Map<String, String> parentAliasMap) throws ProcessingException {
        return builder.createAttributePart(strategy, attributeNodeData.getAggregationType(), stm, attributeNodeData.getOperator(), bindNames, bindValues, this.isPlainBind(), parentAliasMap);
    }
}

