/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.parsers.token.FunctionInputToken;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.rt.server.services.common.jdbc.AbstractSqlService;
import org.eclipse.scout.rt.server.services.common.jdbc.ISqlService;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindInput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

class FunctionInput
implements IBindInput {
    private ISqlService m_callerService;
    private Object[] m_bindBases;
    private int m_batchIndex = -1;
    private int m_jdbcBindIndex = -1;
    private Object m_value;
    private boolean m_valueSet;
    private FunctionInputToken m_target;

    public FunctionInput(ISqlService callerService, Object[] bindBases, FunctionInputToken target) {
        this.m_callerService = callerService;
        this.m_bindBases = bindBases;
        this.m_target = target;
    }

    @Override
    public IToken getToken() {
        return this.m_target;
    }

    @Override
    public boolean isBatch() {
        return false;
    }

    @Override
    public boolean hasBatch(int i) {
        return i <= 0;
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_batchIndex = i;
    }

    @Override
    public boolean isJdbcBind() {
        if (this.m_target.isPlainToken()) {
            return false;
        }
        if (this.m_target.isPlainValue()) {
            return false;
        }
        return !this.m_target.isPlainSql();
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_jdbcBindIndex;
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_jdbcBindIndex = index;
    }

    @Override
    public SqlBind produceSqlBindAndSetReplaceToken(ISqlStyle sqlStyle) throws ProcessingException {
        if (this.isBatch() || !this.m_valueSet) {
            if (!(this.m_callerService instanceof AbstractSqlService)) {
                throw new ProcessingException("don't know how to resolve custom bind function '" + this.m_target.getName() + "' on service " + this.m_callerService.getClass().getName());
            }
            this.m_value = ((AbstractSqlService)this.m_callerService).callbackCustomBindFunction(this.m_target.getName(), this.m_target.getArgs(), this.m_bindBases);
            this.m_valueSet = true;
        }
        Object value = null;
        value = this.isBatch() && this.m_batchIndex >= 1 ? null : this.m_value;
        Class nullType = null;
        if (value instanceof IHolder) {
            IHolder h = (IHolder)value;
            value = h.getValue();
            nullType = h.getHolderType();
        }
        if (this.m_target.isPlainToken()) {
            this.m_target.setReplaceToken(this.m_target.getParsedToken());
            return null;
        }
        if (this.m_target.isPlainValue()) {
            this.m_target.setReplaceToken(sqlStyle.toPlainText(value));
            return null;
        }
        if (this.m_target.isPlainSql()) {
            this.m_target.setReplaceToken("" + value);
            return null;
        }
        this.m_target.setReplaceToken("?");
        return sqlStyle.buildBindFor(value, nullType);
    }
}

