/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.data.basic.MemoryOptimizedObject;
import org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;

public class LookupRow<ID_TYPE>
extends MemoryOptimizedObject
implements ILookupRow<ID_TYPE> {
    private static final long serialVersionUID = 0L;
    public static final LookupRow<?>[] EMPTY_ARRAY = new LookupRow[0];
    public static final int KEY_BIT = 1;
    public static final int TEXT_BIT = 2;
    public static final int ICON_ID_BIT = 3;
    public static final int TOOLTIP_BIT = 4;
    public static final int BACKGROUD_COLOR_BIT = 5;
    public static final int FOREGROUD_COLOR_BIT = 6;
    public static final int FONT_BIT = 7;
    public static final int ENABLED_BIT = 8;
    public static final int PARENT_KEY_BIT = 9;
    public static final int ACTIVE_BIT = 10;
    public static final int ADDITIONAL_TABLE_ROW_DATA = 11;

    public LookupRow(ID_TYPE key, String text) {
        this(key, text, null);
    }

    public LookupRow(ID_TYPE key, String text, String iconId) {
        this(key, text, iconId, null);
    }

    public LookupRow(ID_TYPE key, String text, String iconId, String tooltip) {
        this(key, text, iconId, tooltip, null);
    }

    public LookupRow(ID_TYPE key, String text, String iconId, String tooltip, String backgroundColor) {
        this(key, text, iconId, tooltip, backgroundColor, null);
    }

    public LookupRow(ID_TYPE key, String text, String iconId, String tooltip, String backgroundColor, String foregroundColor) {
        this(key, text, iconId, tooltip, backgroundColor, foregroundColor, null);
    }

    public LookupRow(ID_TYPE key, String text, String iconId, String tooltip, String backgroundColor, String foregroundColor, FontSpec font) {
        this(key, text, iconId, tooltip, backgroundColor, foregroundColor, font, true);
    }

    public LookupRow(ID_TYPE key, String text, String iconId, String tooltip, String backgroundColor, String foregroundColor, FontSpec font, boolean enabled) {
        this(key, text, iconId, tooltip, backgroundColor, foregroundColor, font, enabled, null);
    }

    public LookupRow(ID_TYPE key, String text, String iconId, String tooltip, String backgroundColor, String foregroundColor, FontSpec font, boolean enabled, ID_TYPE parentKey) {
        this(key, text, iconId, tooltip, backgroundColor, foregroundColor, font, enabled, parentKey, true);
    }

    public LookupRow(ID_TYPE key, String text, String iconId, String tooltip, String backgroundColor, String foregroundColor, FontSpec font, boolean enabled, ID_TYPE parentKey, boolean active) {
        this.setKey(key);
        this.setText(text);
        this.setIconId(iconId);
        this.setTooltipText(tooltip);
        this.setBackgroundColor(backgroundColor);
        this.setForegroundColor(foregroundColor);
        this.setFont(font);
        this.setEnabled(enabled);
        this.setParentKey(parentKey);
        this.setActive(active);
    }

    @Deprecated
    public LookupRow(Object[] cells) {
        this(cells, cells == null ? 0 : cells.length);
    }

    @Deprecated
    public LookupRow(Object[] cells, int maxColumnIndex) {
        this(cells, maxColumnIndex, Object.class);
    }

    public LookupRow(Object[] cells, Class<?> keyClass) {
        this(cells, cells == null ? 0 : cells.length, keyClass);
    }

    public LookupRow(Object[] cells, int maxColumnIndex, Class<?> keyClass) {
        if (cells != null) {
            int keyIndex = 0;
            int textIndex = 1;
            int iconIndex = 2;
            int ttIndex = 3;
            int bgIndex = 4;
            int fgIndex = 5;
            int fontIndex = 6;
            int enabledIndex = 7;
            int parentKeyIndex = 8;
            int activeIndex = 9;
            if (cells.length > keyIndex && keyIndex <= maxColumnIndex && cells[keyIndex] != null) {
                Object key = cells[keyIndex];
                if (keyClass != null && !keyClass.isAssignableFrom(key.getClass())) {
                    throw new IllegalArgumentException("Invalid key type for LookupRow. Expected: '" + keyClass.getName() + "', actual: '" + key.getClass().getName() + "'.");
                }
                this.setKey(key);
            }
            if (cells.length > textIndex && textIndex <= maxColumnIndex && cells[textIndex] != null) {
                if (cells[textIndex] != null) {
                    this.setText(cells[textIndex].toString());
                } else {
                    this.setText(null);
                }
            }
            if (cells.length > iconIndex && iconIndex <= maxColumnIndex && cells[iconIndex] != null) {
                if (cells[iconIndex] != null) {
                    this.setIconId(cells[iconIndex].toString());
                } else {
                    this.setIconId(null);
                }
            }
            if (cells.length > ttIndex && ttIndex <= maxColumnIndex && cells[ttIndex] != null) {
                if (cells[ttIndex] != null) {
                    this.setTooltipText(cells[ttIndex].toString());
                } else {
                    this.setTooltipText(null);
                }
            }
            if (cells.length > bgIndex && bgIndex <= maxColumnIndex && cells[bgIndex] != null && cells.length > ttIndex && ttIndex <= maxColumnIndex && cells[ttIndex] != null) {
                if (cells[bgIndex] != null) {
                    this.setBackgroundColor(cells[bgIndex].toString());
                } else {
                    this.setBackgroundColor(null);
                }
            }
            if (cells.length > fgIndex && fgIndex <= maxColumnIndex && cells[fgIndex] != null && cells.length > ttIndex && ttIndex <= maxColumnIndex && cells[ttIndex] != null) {
                if (cells[fgIndex] != null) {
                    this.setForegroundColor(cells[fgIndex].toString());
                } else {
                    this.setForegroundColor(null);
                }
            }
            if (cells.length > fontIndex && fontIndex <= maxColumnIndex && cells[fontIndex] != null) {
                if (cells[fontIndex] != null) {
                    this.setFont(FontSpec.parse(cells[fontIndex].toString()));
                } else {
                    this.setFont(null);
                }
            }
            if (cells.length > enabledIndex && enabledIndex <= maxColumnIndex && cells[enabledIndex] != null) {
                if (cells[enabledIndex] instanceof Boolean) {
                    this.setEnabled((Boolean)cells[enabledIndex]);
                } else if (cells[enabledIndex] instanceof Number) {
                    this.setEnabled(((Number)cells[enabledIndex]).intValue() != 0);
                }
            }
            if (cells.length > parentKeyIndex && parentKeyIndex <= maxColumnIndex && cells[parentKeyIndex] != null) {
                Object parentKey = cells[parentKeyIndex];
                if (keyClass != null && !keyClass.isAssignableFrom(parentKey.getClass())) {
                    throw new IllegalArgumentException("Invalid parent key type for LookupRow. Expected: '" + keyClass.getName() + "', actual: '" + parentKey.getClass().getName() + "'.");
                }
                this.setParentKey((ID_TYPE)parentKey);
            }
            if (cells.length > activeIndex && activeIndex <= maxColumnIndex && cells[activeIndex] != null) {
                if (cells[activeIndex] instanceof Boolean) {
                    this.setActive((Boolean)cells[activeIndex]);
                } else if (cells[activeIndex] instanceof Number) {
                    this.setActive(((Number)cells[activeIndex]).intValue() != 0);
                }
            }
        }
    }

    @Override
    public ID_TYPE getKey() {
        return (ID_TYPE)this.getValueInternal(1);
    }

    public void setKey(ID_TYPE key) {
        this.setValueInternal(1, key);
    }

    @Override
    public ID_TYPE getParentKey() {
        return (ID_TYPE)this.getValueInternal(9);
    }

    @Override
    public void setParentKey(ID_TYPE parentKey) {
        this.setValueInternal(9, parentKey);
    }

    @Override
    public String getText() {
        char[] c = (char[])this.getValueInternal(2);
        return c != null ? new String(c) : null;
    }

    @Override
    public void setText(String text) {
        this.setValueInternal(2, text != null ? text.toCharArray() : null);
    }

    @Override
    public String getIconId() {
        return (String)this.getValueInternal(3);
    }

    @Override
    public void setIconId(String iconId) {
        this.setValueInternal(3, StringUtility.intern((String)iconId));
    }

    @Override
    public String getTooltipText() {
        char[] c = (char[])this.getValueInternal(4);
        return c != null ? new String(c) : null;
    }

    public void setTooltipText(String tooltip) {
        this.setValueInternal(4, tooltip != null ? tooltip.toCharArray() : null);
    }

    @Override
    public String getForegroundColor() {
        return (String)this.getValueInternal(6);
    }

    public void setForegroundColor(String foregroundColor) {
        this.setValueInternal(6, StringUtility.intern((String)foregroundColor));
    }

    @Override
    public String getBackgroundColor() {
        return (String)this.getValueInternal(5);
    }

    public void setBackgroundColor(String backgroundColor) {
        this.setValueInternal(5, StringUtility.intern((String)backgroundColor));
    }

    @Override
    public FontSpec getFont() {
        String s = (String)this.getValueInternal(7);
        return s != null ? FontSpec.parse(s) : null;
    }

    public void setFont(FontSpec font) {
        this.setValueInternal(7, font != null ? StringUtility.intern((String)font.toPattern()) : null);
    }

    @Override
    public boolean isEnabled() {
        if (this.getValueInternal(8) == null) {
            return true;
        }
        return (Boolean)this.getValueInternal(8);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setValueInternal(8, enabled ? null : Boolean.FALSE);
    }

    @Override
    public boolean isActive() {
        if (this.getValueInternal(10) == null) {
            return true;
        }
        return (Boolean)this.getValueInternal(10);
    }

    @Override
    public void setActive(boolean active) {
        this.setValueInternal(10, active ? null : Boolean.FALSE);
    }

    @Override
    public AbstractTableRowData getAdditionalTableRowData() {
        return (AbstractTableRowData)this.getValueInternal(11);
    }

    @Override
    public void setAdditionalTableRowData(AbstractTableRowData bean) {
        this.setValueInternal(11, bean);
    }

    @Deprecated
    public static ILookupRow<?>[] createLookupRowArray(Object[][] data) {
        if (data == null || data.length == 0) {
            return EMPTY_ARRAY;
        }
        LookupRow[] a = new LookupRow[data.length];
        int i = 0;
        while (i < data.length) {
            a[i] = new LookupRow(data[i]);
            ++i;
        }
        return a;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getKey() + ", " + this.getText() + "]";
    }
}

