/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.security.Permission;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleObjectInputStream;

public class LenientPermissionWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LenientPermissionWrapper.class);
    private Permission m_permission;
    private String m_className;

    public LenientPermissionWrapper(Permission p) {
        this.m_permission = p;
        this.m_className = p.getClass().getName();
    }

    public Permission getPermission() {
        return this.m_permission;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream localOut = new ObjectOutputStream(bout);
        try {
            localOut.writeObject(this.m_permission);
        }
        finally {
            localOut.close();
        }
        byte[] data = bout.toByteArray();
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("m_className", this.m_className);
        pfields.put("m_permission", data);
        out.writeFields();
    }

    private void readObject(final ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            ObjectInputStream.GetField gfields = in.readFields();
            this.m_className = (String)gfields.get("m_className", null);
            byte[] data = (byte[])gfields.get("m_permission", null);
            ObjectInputStream localIn = new ObjectInputStream(new ByteArrayInputStream(data)){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    return in instanceof BundleObjectInputStream ? ((BundleObjectInputStream)in).resolveClass(desc) : Class.forName(desc.getName());
                }
            };
            try {
                this.m_permission = (Permission)localIn.readObject();
            }
            finally {
                localIn.close();
            }
        }
        catch (Throwable t) {
            LOG.warn("cannot deserialize permission", t);
        }
    }
}

