/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.spec.client.ISpecProcessor;
import org.eclipse.scout.rt.spec.client.SpecIOUtility;
import org.eclipse.scout.rt.spec.client.link.LinkTarget;
import org.eclipse.scout.rt.spec.client.out.mediawiki.MediawikiLinkTargetManager;

public class MediawikiAnchorPostProcessor
implements ISpecProcessor {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(MediawikiAnchorPostProcessor.class);

    @Override
    public void process() throws ProcessingException {
        if (!SpecIOUtility.getSpecFileConfigInstance().getMediawikiDir().exists()) {
            LOG.warn("MediawikiDir does not exists! (" + SpecIOUtility.getSpecFileConfigInstance().getMediawikiDir().getPath() + ")");
            return;
        }
        File[] fileArray = SpecIOUtility.getSpecFileConfigInstance().getMediawikiDir().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File wiki = fileArray[n2];
            this.replaceScoutAnchors(wiki);
            ++n2;
        }
    }

    private void replaceScoutAnchors(File wiki) throws ProcessingException {
        P_ScoutAnchorProcessor anchorProcessor = new P_ScoutAnchorProcessor();
        SpecIOUtility.process(wiki, anchorProcessor);
        MediawikiLinkTargetManager w = new MediawikiLinkTargetManager(SpecIOUtility.getSpecFileConfigInstance().getLinksFile());
        ArrayList<LinkTarget> targets = new ArrayList<LinkTarget>();
        for (String id : anchorProcessor.getAnchorsIds()) {
            targets.add(new LinkTarget(id, wiki.getName()));
        }
        w.writeLinks(targets);
    }

    protected static class P_ScoutAnchorProcessor
    implements SpecIOUtility.IStringProcessor {
        private List<String> m_anchorIds = new ArrayList<String>();

        protected P_ScoutAnchorProcessor() {
        }

        @Override
        public String processLine(String input) {
            Pattern pattern = Pattern.compile("(\\{\\{a:)([^}]+)(}})");
            Matcher matcher = pattern.matcher(input);
            StringBuilder sb = new StringBuilder();
            int index = 0;
            while (matcher.find()) {
                sb.append(input.substring(index, matcher.start(0)));
                sb.append("<span id=\"").append(matcher.group(2)).append("\"/>");
                this.m_anchorIds.add(matcher.group(2));
                index = matcher.end();
            }
            sb.append(input.substring(index));
            return sb.toString();
        }

        public List<String> getAnchorsIds() {
            return this.m_anchorIds;
        }
    }
}

