/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.rap.rwt.internal.lifecycle.UITestUtil;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.testing.CustomWidgetIdGenerator;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class AbstractRwtMenuAction {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractRwtMenuAction.class);
    private final IAction m_scoutAction;
    private final IRwtEnvironment m_uiEnvironment;
    private boolean m_initialized;
    private boolean m_connectedToScout;
    private boolean m_addKeyStrokeTextEnabled;
    private P_ScoutPropertyChangeListener m_scoutPropertyListener;
    private MenuItem m_uiMenuItem;
    private final Menu m_uiMenu;
    private SelectionListener m_menuSelectionListener;

    public AbstractRwtMenuAction(Menu uiMenu, IAction scoutAction, IRwtEnvironment uiEnvironment, boolean callInitializer) {
        this.m_uiMenu = uiMenu;
        this.m_scoutAction = scoutAction;
        this.m_uiEnvironment = uiEnvironment;
        this.m_addKeyStrokeTextEnabled = true;
        if (callInitializer) {
            this.init();
        }
        this.m_uiMenu.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent event) {
                AbstractRwtMenuAction.this.disconnectFromScout();
            }
        });
    }

    public void init() {
        this.callInitializers(this.m_uiMenu);
    }

    protected final void callInitializers(Menu menu) {
        if (this.m_initialized) {
            return;
        }
        this.m_initialized = true;
        this.initializeUi(menu);
        this.connectToScout();
    }

    protected final void connectToScout() {
        if (!this.m_connectedToScout) {
            this.attachScoutListeners();
            this.applyScoutProperties();
            this.m_connectedToScout = true;
        }
    }

    protected final void disconnectFromScout() {
        if (this.m_connectedToScout) {
            this.detachScoutListeners();
            this.m_connectedToScout = false;
        }
    }

    protected void attachScoutListeners() {
        if (this.m_scoutPropertyListener == null) {
            this.m_scoutPropertyListener = new P_ScoutPropertyChangeListener();
            this.m_scoutAction.addPropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyListener);
        }
    }

    protected void detachScoutListeners() {
        if (this.m_scoutPropertyListener != null) {
            this.m_scoutAction.removePropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyListener);
            this.m_scoutPropertyListener = null;
        }
    }

    protected void applyScoutProperties() {
        IAction scoutAction = this.getScoutAction();
        this.setEnabledFromScout(scoutAction.isEnabled());
        this.setTextFromScout(scoutAction.getTextWithMnemonic());
        this.setTooltipTextFromScout(scoutAction.getTooltipText());
        this.setIconFromScout(scoutAction.getIconId());
    }

    protected void setIconFromScout(String iconId) {
        if (!this.getUiMenuItem().isDisposed()) {
            this.getUiMenuItem().setImage(this.getUiEnvironment().getIcon(iconId));
        }
    }

    protected void setTooltipTextFromScout(String tooltipText) {
        if (!StringUtility.isNullOrEmpty((String)tooltipText)) {
            LOG.warn("unsuported method on rwt");
        }
    }

    protected void setTextFromScout(String text) {
        IAction action;
        if (this.getUiMenuItem().isDisposed()) {
            return;
        }
        if (text == null) {
            text = "";
        }
        if (this.isAddKeyStrokeTextEnabled() && (action = this.getScoutAction()) != null && StringUtility.hasText((String)action.getKeyStroke())) {
            text = String.valueOf(text) + "\t" + RwtUtility.getKeyStrokePrettyPrinted(action);
        }
        this.getUiMenuItem().setText(text);
    }

    protected void setEnabledFromScout(boolean enabled) {
        if (!this.getUiMenuItem().isDisposed()) {
            this.getUiMenuItem().setEnabled(enabled);
        }
    }

    protected void initializeUi(Menu menu) {
    }

    public IAction getScoutAction() {
        return this.m_scoutAction;
    }

    protected IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    public MenuItem getUiMenuItem() {
        return this.m_uiMenuItem;
    }

    public void setUiMenuItem(MenuItem uiMenuItem) {
        if (this.m_uiMenuItem != null) {
            this.m_uiMenuItem.removeSelectionListener(this.m_menuSelectionListener);
        }
        this.m_uiMenuItem = uiMenuItem;
        if (this.m_menuSelectionListener == null) {
            this.m_menuSelectionListener = new P_UiMenuItemSelectionListener();
        }
        this.m_uiMenuItem.addSelectionListener(this.m_menuSelectionListener);
        this.setCustomWidgetIds((Widget)this.m_uiMenuItem);
    }

    private void setCustomWidgetIds(Widget parent) {
        if (!UITestUtil.isEnabled()) {
            return;
        }
        CustomWidgetIdGenerator.getInstance().setCustomWidgetIds(parent, (IPropertyObserver)this.getScoutAction(), this.getClass().getName());
    }

    protected Menu getMenu() {
        return this.m_uiMenu;
    }

    private void handleUiAction() {
        RwtUtility.runUiInputVerifier();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                AbstractRwtMenuAction.this.getScoutAction().getUIFacade().fireActionFromUI();
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    private boolean isHandleScoutPropertyChange(String propertyName, Object newValue) {
        return true;
    }

    public boolean isAddKeyStrokeTextEnabled() {
        return this.m_addKeyStrokeTextEnabled;
    }

    public void setAddKeyStrokeTextEnabled(boolean addKeyStrokeTextEnabled) {
        this.m_addKeyStrokeTextEnabled = addKeyStrokeTextEnabled;
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("enabled")) {
            this.setEnabledFromScout((Boolean)newValue);
        } else if (name.equals("text")) {
            this.setTextFromScout((String)newValue);
        } else if (name.equals("tooltipText")) {
            this.setTooltipTextFromScout((String)newValue);
        } else if (name.equals("iconId")) {
            this.setIconFromScout((String)newValue);
        } else if (name.equals("keystroke")) {
            this.setTextFromScout(this.getScoutAction().getText());
        }
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            if (AbstractRwtMenuAction.this.isHandleScoutPropertyChange(e.getPropertyName(), e.getNewValue())) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        AbstractRwtMenuAction.this.handleScoutPropertyChange(e.getPropertyName(), e.getNewValue());
                    }
                };
                AbstractRwtMenuAction.this.getUiEnvironment().invokeUiLater(t);
            }
        }
    }

    private class P_UiMenuItemSelectionListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        private P_UiMenuItemSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractRwtMenuAction.this.handleUiAction();
        }
    }
}

