/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.action.menu;

import java.util.Set;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.action.menu.IRwtScoutMenu;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class RwtScoutContextMenu
implements IRwtScoutMenu {
    public static final String DATA_SYSTEM_MENU = "dataSystemMenu";
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutContextMenu.class);
    protected final BasicPropertySupport m_propertySupport;
    private final IRwtEnvironment m_environment;
    private final Shell m_parentShell;
    private Menu m_uiMenu;
    private IContextMenu m_scoutContextMenu;
    private Listener m_uiMenuListener;
    private Boolean m_childrenCreated = false;

    public RwtScoutContextMenu(Shell parentShell, IContextMenu scoutContextMenu, IRwtEnvironment environment) {
        this(parentShell, scoutContextMenu, environment, true);
    }

    public RwtScoutContextMenu(Shell parentShell, IContextMenu scoutContextMenu, IRwtEnvironment environment, boolean callInitializer) {
        this.m_parentShell = parentShell;
        this.m_scoutContextMenu = scoutContextMenu;
        this.m_environment = environment;
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        if (callInitializer) {
            this.initMenu();
        }
    }

    protected void initMenu() {
        this.m_uiMenu = new Menu((Decorations)this.getParentShell(), 8);
        this.m_uiMenuListener = new P_UiMenuListener();
        this.m_uiMenu.addListener(22, this.m_uiMenuListener);
        this.m_uiMenu.addListener(23, this.m_uiMenuListener);
        this.m_uiMenu.addListener(12, this.m_uiMenuListener);
    }

    public void dispose() {
        if (this.getUiMenu() != null) {
            this.getUiMenu().dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeChildren() {
        Boolean bl = this.m_childrenCreated;
        synchronized (bl) {
            if (this.m_childrenCreated.booleanValue()) {
                try {
                    MenuItem[] menuItemArray = this.getUiMenu().getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item = menuItemArray[n2];
                        if (item.getData(DATA_SYSTEM_MENU) == null) {
                            item.dispose();
                        }
                        ++n2;
                    }
                }
                finally {
                    this.m_childrenCreated = false;
                }
            }
        }
    }

    protected void updateUiMenu() {
        MenuItem[] menuItemArray = this.getUiMenu().getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (item.getData(DATA_SYSTEM_MENU) == null) {
                item.dispose();
            }
            ++n2;
        }
        IActionFilter filter = ActionUtility.createMenuFilterMenuTypes((Set)this.getScoutContextMenu().getCurrentMenuTypes(), (boolean)true);
        RwtMenuUtility.fillMenu(this.getUiMenu(), this.getScoutContextMenu().getChildActions(), filter, this.getEnvironment());
    }

    @Override
    public IRwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    public Shell getParentShell() {
        return this.m_parentShell;
    }

    @Override
    public IContextMenu getScoutContextMenu() {
        return this.m_scoutContextMenu;
    }

    @Override
    public Menu getUiMenu() {
        return this.m_uiMenu;
    }

    protected void handleSwtMenuShow() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                RwtScoutContextMenu.this.getScoutContextMenu().callAboutToShow(ActionUtility.createMenuFilterMenuTypes((Set)RwtScoutContextMenu.this.getScoutContextMenu().getCurrentMenuTypes(), (boolean)false));
            }
        };
        JobEx prepareJob = this.getEnvironment().invokeScoutLater(t, 0L);
        try {
            prepareJob.join(1200L);
        }
        catch (InterruptedException e) {
            LOG.error("error during prepare menus.", (Throwable)e);
        }
        this.updateUiMenu();
    }

    protected void handleSwtMenuHide() {
    }

    protected void handleSwtMenuDispose() {
        this.m_uiMenu.removeListener(22, this.m_uiMenuListener);
        this.m_uiMenu.removeListener(23, this.m_uiMenuListener);
        this.m_uiMenu.removeListener(12, this.m_uiMenuListener);
        this.m_uiMenuListener = null;
    }

    private class P_UiMenuListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_UiMenuListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 22: {
                    RwtScoutContextMenu.this.handleSwtMenuShow();
                    break;
                }
                case 23: {
                    RwtScoutContextMenu.this.handleSwtMenuHide();
                    break;
                }
                case 12: {
                    RwtScoutContextMenu.this.handleSwtMenuDispose();
                }
            }
        }
    }
}

