/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.action.menu;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class RwtScoutMenuItem {
    private final IMenu m_scoutMenu;
    private final IRwtEnvironment m_environment;
    private final Menu m_parentMenu;
    private MenuItem m_swtMenuItem;
    private boolean m_handleSelectionPending;
    private PropertyChangeListener m_scoutPropertyChangeListener;
    private Listener m_swtSelectionListener;
    private Listener m_swtMenuDisposeListener;
    private IActionFilter m_filter;

    public RwtScoutMenuItem(IMenu scoutMenu, Menu parentMenu, IActionFilter filter, IRwtEnvironment environment) {
        this(scoutMenu, parentMenu, filter, environment, true);
    }

    public RwtScoutMenuItem(IMenu scoutMenu, Menu parentMenu, IActionFilter filter, IRwtEnvironment environment, boolean callInitializer) {
        this.m_filter = filter;
        this.m_environment = environment;
        this.m_scoutMenu = scoutMenu;
        this.m_parentMenu = parentMenu;
        if (callInitializer) {
            this.createMenu(scoutMenu, parentMenu, environment);
        }
    }

    protected void createMenu(IMenu scoutMenu, Menu parentMenu, IRwtEnvironment environment) {
        this.m_swtMenuItem = RwtMenuUtility.createRwtMenuItem(parentMenu, scoutMenu, this.getFilter(), environment);
        this.m_swtMenuItem.setData((Object)this.getScoutMenu());
        this.m_swtSelectionListener = new P_SwtMenuListener();
        this.m_swtMenuItem.addListener(13, this.m_swtSelectionListener);
        this.m_swtMenuDisposeListener = new P_SwtMenuDisposeListener();
        this.m_swtMenuItem.addListener(12, this.m_swtMenuDisposeListener);
        this.attachScout();
    }

    protected void attachScout() {
        this.m_scoutPropertyChangeListener = new P_ScoutPropertyChangeListener();
        this.m_scoutMenu.addPropertyChangeListener(this.m_scoutPropertyChangeListener);
        this.updateEnabledFromScout();
        this.updateIconFromScout();
        this.updateKeyStrokeFromScout();
        this.updateTextWithMnemonicFromScout();
        this.updateTooltipTextFromScout();
        this.updateSelectedFromScout();
    }

    protected void dettachScout() {
        this.getScoutMenu().removePropertyChangeListener(this.m_scoutPropertyChangeListener);
    }

    public IActionFilter getFilter() {
        return this.m_filter;
    }

    public IRwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    public IMenu getScoutMenu() {
        return this.m_scoutMenu;
    }

    public Menu getParentMenu() {
        return this.m_parentMenu;
    }

    public MenuItem getSwtMenuItem() {
        return this.m_swtMenuItem;
    }

    private boolean isHandleScoutPropertyChange(String propertyName, Object newValue) {
        return true;
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("enabled")) {
            this.updateEnabledFromScout();
        } else if (name.equals("&text")) {
            this.updateTextWithMnemonicFromScout();
        } else if (name.equals("tooltipText")) {
            this.updateTooltipTextFromScout();
        } else if (name.equals("iconId")) {
            this.updateIconFromScout();
        } else if (name.equals("keystroke")) {
            this.updateKeyStrokeFromScout();
        } else if (name.equals("visible")) {
            this.updateVisibilityFromScout();
        } else if (name.equals("selected")) {
            this.updateSelectedFromScout();
        }
    }

    protected void updateKeyStrokeFromScout() {
        if (this.getSwtMenuItem() != null) {
            this.getSwtMenuItem().isDisposed();
        }
    }

    protected void updateIconFromScout() {
        if (this.getSwtMenuItem() != null && !this.getSwtMenuItem().isDisposed()) {
            this.getSwtMenuItem().setImage(this.getEnvironment().getIcon(this.getScoutMenu().getIconId()));
        }
    }

    protected void updateTooltipTextFromScout() {
        if (this.getSwtMenuItem() != null) {
            this.getSwtMenuItem().isDisposed();
        }
    }

    protected void updateTextWithMnemonicFromScout() {
        if (this.getSwtMenuItem() != null && !this.getSwtMenuItem().isDisposed()) {
            String text = this.getScoutMenu().getTextWithMnemonic();
            if (text == null) {
                text = "";
            }
            this.getSwtMenuItem().setText(text);
        }
    }

    protected void updateEnabledFromScout() {
        if (this.getSwtMenuItem() != null && !this.getSwtMenuItem().isDisposed()) {
            this.getSwtMenuItem().setEnabled(this.getScoutMenu().isEnabled());
        }
    }

    protected void updateVisibilityFromScout() {
    }

    protected void updateSelectedFromScout() {
        if (this.getSwtMenuItem() != null && !this.getSwtMenuItem().isDisposed()) {
            this.getSwtMenuItem().setSelection(this.getScoutMenu().isSelected());
        }
    }

    protected void handleSwtMenuSelection() {
        if (!this.m_handleSelectionPending) {
            this.m_handleSelectionPending = true;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        RwtScoutMenuItem.this.getScoutMenu().getUIFacade().fireActionFromUI();
                    }
                    finally {
                        RwtScoutMenuItem.this.m_handleSelectionPending = false;
                    }
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleSwtMenuItemDispose() {
        if (this.getSwtMenuItem() != null && !this.getSwtMenuItem().isDisposed()) {
            this.getSwtMenuItem().removeListener(12, this.m_swtMenuDisposeListener);
            this.m_swtMenuDisposeListener = null;
        }
        this.getSwtMenuItem().removeListener(13, this.m_swtSelectionListener);
        this.m_swtSelectionListener = null;
        this.dettachScout();
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            if (RwtScoutMenuItem.this.isHandleScoutPropertyChange(e.getPropertyName(), e.getNewValue())) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutMenuItem.this.handleScoutPropertyChange(e.getPropertyName(), e.getNewValue());
                    }
                };
                RwtScoutMenuItem.this.getEnvironment().invokeUiLater(t);
            }
        }
    }

    private class P_SwtMenuDisposeListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_SwtMenuDisposeListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 12: {
                    RwtScoutMenuItem.this.handleSwtMenuItemDispose();
                }
            }
        }
    }

    private class P_SwtMenuListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_SwtMenuListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    RwtScoutMenuItem.this.handleSwtMenuSelection();
                }
            }
        }
    }
}

