/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.table;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITableContextMenu;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.RowIndexComparator;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ICustomColumn;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.table.AbstractAvoidWrongDoubleClickListener;
import org.eclipse.scout.rt.ui.rap.basic.table.AbstractTableKeyboardNavigationSupport;
import org.eclipse.scout.rt.ui.rap.basic.table.IRwtScoutTable;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutColumnModel;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTableEvent;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTableModel;
import org.eclipse.scout.rt.ui.rap.basic.table.TableColumnManager;
import org.eclipse.scout.rt.ui.rap.basic.table.celleditor.RwtScoutTableCellEditor;
import org.eclipse.scout.rt.ui.rap.ext.MenuAdapterEx;
import org.eclipse.scout.rt.ui.rap.ext.table.TableEx;
import org.eclipse.scout.rt.ui.rap.ext.table.TableViewerEx;
import org.eclipse.scout.rt.ui.rap.ext.table.util.TableRolloverSupport;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.AbstractRwtScoutDndSupport;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.HtmlTextUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.util.UiRedrawHandler;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class RwtScoutTable
extends RwtScoutComposite<ITable>
implements IRwtScoutTable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutTable.class);
    private P_ScoutTableListener m_scoutTableListener;
    private UiRedrawHandler m_redrawHandler;
    private Listener m_autoResizeColumnListener;
    private Listener m_columnListener = new P_TableColumnListener();
    private SelectionListener m_columnSortListener = new P_ColumnSortListener();
    private TableColumnManager m_uiColumnManager = new TableColumnManager();
    private RwtScoutTableCellEditor m_uiCellEditorComposite;
    private int[] m_uiColumnOrder;
    private TableViewer m_uiViewer;
    private IRwtKeyStroke[] m_uiKeyStrokes;
    private ClientSyncJob m_storeColumnWidthsJob;
    private RwtScoutColumnModel m_columnModel = null;
    private String m_variant = "";
    private AbstractTableKeyboardNavigationSupport m_keyboardNavigationSupport;

    public RwtScoutTable() {
    }

    public RwtScoutTable(String variant) {
        this.m_variant = variant;
    }

    @Override
    protected void initializeUi(Composite parent) {
        this.m_redrawHandler = new UiRedrawHandler((Control)parent);
        int style = this.getScoutObject() != null && ((ITable)this.getScoutObject()).isMultiSelect() ? 2 : 4;
        TableEx table = this.getUiEnvironment().getFormToolkit().createTable(parent, style |= 0x10300);
        if (StringUtility.hasText((String)this.m_variant)) {
            table.setData("org.eclipse.rap.rwt.customVariant", this.m_variant);
        }
        table.setData("org.eclipse.rap.rwt.markupEnabled", Boolean.TRUE);
        table.setData("org.eclipse.rap.rwt.markupValidationDisabled", Boolean.TRUE);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setTouchEnabled(RwtUtility.getBrowserInfo().isTablet() || RwtUtility.getBrowserInfo().isMobile());
        new TableRolloverSupport(table);
        TableViewerEx viewer = new TableViewerEx(table);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        viewer.setUseHashlookup(true);
        this.setUiTableViewer(viewer);
        this.setUiField((Control)table);
        this.m_uiCellEditorComposite = new RwtScoutTableCellEditor(this);
        table.addMenuDetectListener(new P_RwtHeaderMenuDetectListener());
        viewer.addSelectionChangedListener(new P_RwtSelectionChangedListener());
        P_RwtTableListener rwtTableListener = new P_RwtTableListener();
        table.addListener(3, rwtTableListener);
        table.addListener(4, rwtTableListener);
        table.addListener(8, rwtTableListener);
        table.addListener(35, rwtTableListener);
        table.addListener(11, rwtTableListener);
        table.addSelectionListener((SelectionListener)new P_RwtHyperlinkSelectionListener());
        this.getUiEnvironment().addKeyStroke((Control)table, new RwtKeyStroke(32){

            @Override
            public void handleUiAction(Event e) {
                RwtScoutTable.this.handleUiToggleAcction(e);
            }
        }, false);
    }

    @Override
    public boolean isUiDisposed() {
        return this.getUiField() == null || this.getUiField().isDisposed();
    }

    protected RwtScoutTableModel createUiTableModel() {
        return new RwtScoutTableModel((ITable)this.getScoutObject(), this, this.m_uiColumnManager);
    }

    protected RwtScoutColumnModel getUiColumnModel() {
        if (this.m_columnModel == null) {
            this.m_columnModel = new RwtScoutColumnModel((ITable)this.getScoutObject(), this, this.m_uiColumnManager);
        }
        return this.m_columnModel;
    }

    public TableColumnManager getUiColumnManager() {
        return this.m_uiColumnManager;
    }

    public void initializeUiColumns() {
        this.m_redrawHandler.pushControlChanging();
        try {
            List scoutColumnsOrdered;
            TableColumn[] tableColumnArray = this.getUiField().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn col = tableColumnArray[n2];
                col.dispose();
                ++n2;
            }
            TableColumn dummyCol = new TableColumn((Table)this.getUiField(), 16384);
            dummyCol.setWidth(0);
            dummyCol.setResizable(false);
            dummyCol.setMoveable(false);
            boolean sortEnabled = false;
            if (this.getScoutObject() != null) {
                scoutColumnsOrdered = ((ITable)this.getScoutObject()).getColumnSet().getVisibleColumns();
                sortEnabled = ((ITable)this.getScoutObject()).isSortEnabled();
            } else {
                scoutColumnsOrdered = CollectionUtility.emptyArrayList();
            }
            if (this.m_uiColumnManager == null) {
                this.m_uiColumnManager = new TableColumnManager();
            }
            this.m_uiColumnManager.initialize(scoutColumnsOrdered);
            boolean multilineHeaders = false;
            for (IColumn scoutColumn : scoutColumnsOrdered) {
                boolean isHtml;
                IHeaderCell cell = scoutColumn.getHeaderCell();
                String cellText = cell.getText();
                if (cellText == null) {
                    cellText = "";
                }
                if (!(isHtml = HtmlTextUtility.isTextWithHtmlMarkup(cellText)) && cellText.indexOf("\n") >= 0) {
                    multilineHeaders = true;
                }
                if (isHtml) {
                    multilineHeaders = true;
                    cellText = this.getUiEnvironment().adaptHtmlCell(this, cellText);
                }
                int style = RwtUtility.getHorizontalAlignment(cell.getHorizontalAlignment());
                TableColumn rwtCol = new TableColumn((Table)this.getUiField(), style);
                TableViewerColumn rwtViewerCol = new TableViewerColumn(this.getUiTableViewer(), rwtCol);
                rwtViewerCol.setLabelProvider((CellLabelProvider)this.getUiColumnModel());
                rwtCol.setData("scoutColumn", (Object)scoutColumn);
                if (scoutColumn instanceof IStringColumn) {
                    rwtCol.setData("org.eclipse.rap.rwt.wrappedColumn", (Object)((IStringColumn)scoutColumn).isTextWrap());
                }
                rwtCol.setMoveable(true);
                rwtCol.setToolTipText(cell.getTooltipText());
                this.updateHeaderText(rwtCol, scoutColumn);
                rwtCol.setWidth(scoutColumn.getWidth());
                if (scoutColumn.isFixedWidth()) {
                    rwtCol.setResizable(false);
                }
                if (cell.isSortActive()) {
                    this.getUiField().setSortColumn(rwtCol);
                    this.getUiField().setSortDirection(cell.isSortAscending() ? 128 : 1024);
                }
                if (sortEnabled) {
                    rwtCol.addSelectionListener(this.m_columnSortListener);
                }
                rwtCol.addListener(10, this.m_columnListener);
                rwtCol.addListener(11, this.m_columnListener);
            }
            if (multilineHeaders) {
                this.getUiField().setData("multiLineHeader", Boolean.TRUE);
            }
            this.m_uiColumnOrder = this.getUiField().getColumnOrder();
            this.m_uiCellEditorComposite.initializeUi();
        }
        finally {
            this.m_redrawHandler.popControlChanging();
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_scoutTableListener == null) {
            this.m_scoutTableListener = new P_ScoutTableListener();
            ((ITable)this.getScoutObject()).addUITableListener((TableListener)this.m_scoutTableListener);
        }
        this.initializeUiColumns();
        RwtScoutTableModel tableModel = this.createUiTableModel();
        this.getUiTableViewer().setContentProvider((IContentProvider)tableModel);
        this.getUiTableViewer().setInput((Object)tableModel);
        this.setHeaderVisibleFromScout(((ITable)this.getScoutObject()).isHeaderVisible());
        this.setSelectionFromScout(((ITable)this.getScoutObject()).getSelectedRows());
        this.setKeyStrokeFormScout();
        this.setRowHeightFromScout();
        this.setKeyboardNavigationFromScout();
        this.updateAutoResizeColumnsFromScout();
        this.attachDndSupport();
        this.handleEventsFromRecentHistory();
    }

    private void handleEventsFromRecentHistory() {
        final IEventHistory h = ((ITable)this.getScoutObject()).getEventHistory();
        if (h == null) {
            return;
        }
        this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (TableEvent e : h.getRecentEvents()) {
                    RwtScoutTable.this.handleScoutTableEventInUi(e);
                }
            }
        });
    }

    protected void attachDndSupport() {
        if (UiDecorationExtensionPoint.getLookAndFeel().isDndSupportEnabled()) {
            new P_DndSupport((IPropertyObserver)this.getScoutObject(), (IDNDSupport)this.getScoutObject(), (Control)this.getUiField());
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        this.removeAutoResizeColumnListener();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_scoutTableListener != null) {
            ((ITable)this.getScoutObject()).removeTableListener((TableListener)this.m_scoutTableListener);
            this.m_scoutTableListener = null;
        }
    }

    public TableEx getUiField() {
        return (TableEx)super.getUiField();
    }

    public TableViewer getUiTableViewer() {
        return this.m_uiViewer;
    }

    public void setUiTableViewer(TableViewer uiViewer) {
        this.m_uiViewer = uiViewer;
    }

    public ITableRow getUiSelectedRow() {
        return (ITableRow)CollectionUtility.firstElement(this.getUiSelectedRows());
    }

    public List<ITableRow> getUiSelectedRows() {
        StructuredSelection uiSelection = (StructuredSelection)this.getUiTableViewer().getSelection();
        TreeSet<ITableRow> sortedRows = new TreeSet<ITableRow>((Comparator<ITableRow>)new RowIndexComparator());
        if (uiSelection != null && !uiSelection.isEmpty()) {
            Iterator uiSelectionIt = uiSelection.iterator();
            while (uiSelectionIt.hasNext()) {
                sortedRows.add((ITableRow)uiSelectionIt.next());
            }
        }
        return new ArrayList<ITableRow>(sortedRows);
    }

    protected void setKeyStrokeFormScout() {
        if (this.m_uiKeyStrokes != null) {
            IRwtKeyStroke[] iRwtKeyStrokeArray = this.m_uiKeyStrokes;
            int n = this.m_uiKeyStrokes.length;
            int n2 = 0;
            while (n2 < n) {
                IRwtKeyStroke rwtKeyStroke = iRwtKeyStrokeArray[n2];
                this.getUiEnvironment().removeKeyStroke((Control)this.getUiField(), rwtKeyStroke);
                ++n2;
            }
        }
        ArrayList<IRwtKeyStroke> newRwtKeyStrokes = new ArrayList<IRwtKeyStroke>();
        for (IKeyStroke scoutKeyStroke : ((ITable)this.getScoutObject()).getKeyStrokes()) {
            IRwtKeyStroke[] rwtStrokes;
            if (!scoutKeyStroke.isEnabled()) continue;
            IRwtKeyStroke[] iRwtKeyStrokeArray = rwtStrokes = RwtUtility.getKeyStrokes(scoutKeyStroke, this.getUiEnvironment());
            int n = rwtStrokes.length;
            int n3 = 0;
            while (n3 < n) {
                IRwtKeyStroke rwtStroke = iRwtKeyStrokeArray[n3];
                this.getUiEnvironment().addKeyStroke((Control)this.getUiField(), rwtStroke, false);
                newRwtKeyStrokes.add(rwtStroke);
                ++n3;
            }
        }
        this.m_uiKeyStrokes = newRwtKeyStrokes.toArray(new IRwtKeyStroke[newRwtKeyStrokes.size()]);
    }

    protected void setRowHeightFromScout() {
        int h = ((ITable)this.getScoutObject()).getRowHeightHint();
        if (h >= 0) {
            this.getUiField().setData("org.eclipse.rap.rwt.customItemHeight", h);
        } else {
            int defaultTableRowHeight = UiDecorationExtensionPoint.getLookAndFeel().getTableRowHeight();
            if (defaultTableRowHeight >= 0) {
                this.getUiField().setData("org.eclipse.rap.rwt.customItemHeight", defaultTableRowHeight);
            }
        }
        if (this.isCreated()) {
            this.getUiTableViewer().refresh();
        }
    }

    protected void setKeyboardNavigationFromScout() {
        if (((ITable)this.getScoutObject()).hasKeyboardNavigation()) {
            if (this.m_keyboardNavigationSupport == null) {
                this.m_keyboardNavigationSupport = new P_KeyBoardNavigationSupport(this.getUiField());
            }
        } else if (this.m_keyboardNavigationSupport != null) {
            this.m_keyboardNavigationSupport.dispose();
            this.m_keyboardNavigationSupport = null;
        }
    }

    private void updateAutoResizeColumnsFromScout() {
        if (this.getUiField() != null && !this.getUiField().getParent().isDisposed()) {
            Composite parent = this.getUiField().getParent();
            if (((ITable)this.getScoutObject()).isAutoResizeColumns()) {
                if (this.m_autoResizeColumnListener == null) {
                    this.m_autoResizeColumnListener = new P_RwtResizeListener();
                    parent.addListener(11, this.m_autoResizeColumnListener);
                }
                this.scheduleHandleAutoResizeColumn();
            }
        } else {
            this.removeAutoResizeColumnListener();
        }
    }

    private void scheduleHandleAutoResizeColumn() {
        this.getUiField().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                RwtScoutTable.this.handleAutoSizeColumns();
            }
        });
    }

    private void removeAutoResizeColumnListener() {
        if (this.m_autoResizeColumnListener == null) {
            return;
        }
        Composite parent = this.getUiField().getParent();
        parent.removeListener(11, this.m_autoResizeColumnListener);
        this.m_autoResizeColumnListener = null;
    }

    @Override
    protected void handleScoutPropertyChange(String propName, Object newValue) {
        if (propName.equals("headerVisible")) {
            this.setHeaderVisibleFromScout((Boolean)newValue);
        } else if (propName.equals("keyStroks")) {
            this.setKeyStrokeFormScout();
        } else if (propName.equals("rowHeightHint")) {
            this.setRowHeightFromScout();
        } else if (propName.equals("keyboardNavigation")) {
            this.setKeyboardNavigationFromScout();
        } else if (propName.equals("autoResizeColumns")) {
            this.updateAutoResizeColumnsFromScout();
        } else if (propName.equals("scrollToSelection")) {
            this.updateScrollToSelectionFromScout();
        }
    }

    protected boolean isHandleScoutTableEvent(List<? extends TableEvent> events) {
        for (TableEvent tableEvent : events) {
            switch (tableEvent.getType()) {
                case 1: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 105: 
                case 200: 
                case 210: 
                case 770: 
                case 780: 
                case 800: 
                case 805: 
                case 830: {
                    return true;
                }
            }
        }
        return false;
    }

    protected void handleScoutTableEventInUi(TableEvent e) {
        if (this.isUiDisposed()) {
            return;
        }
        RwtScoutTableEvent uiTableEvent = null;
        switch (e.getType()) {
            case 800: {
                this.getUiField().setFocus();
                break;
            }
            case 805: {
                int swtCol = -1;
                TableColumn[] swtColumns = this.getUiField().getColumns();
                int c = 0;
                while (c < swtColumns.length) {
                    if (swtColumns[c].getData("scoutColumn") == e.getFirstColumn()) {
                        swtCol = c;
                        break;
                    }
                    ++c;
                }
                ITableRow scoutRow = e.getFirstRow();
                if (scoutRow == null || swtCol < 0) break;
                this.getUiTableViewer().editElement((Object)scoutRow, swtCol);
                break;
            }
            case 830: {
                this.scrollToSelection();
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 200: 
            case 210: {
                uiTableEvent = new RwtScoutTableEvent();
                break;
            }
            case 770: {
                break;
            }
            case 780: {
                this.headerUpdateFromScout();
                break;
            }
            case 1: {
                this.initializeUiColumns();
                if (((ITable)this.getScoutObject()).isAutoResizeColumns()) {
                    this.handleAutoSizeColumns();
                }
                uiTableEvent = new RwtScoutTableEvent();
                break;
            }
            case 103: {
                this.setSelectionFromScout(e.getRows());
            }
        }
        if (uiTableEvent != null) {
            this.getUiColumnModel().consumeColumnModelEvent(uiTableEvent);
            ((RwtScoutTableModel)this.getUiTableViewer().getContentProvider()).consumeTableModelEvent(uiTableEvent);
            this.getUiTableViewer().refresh();
        }
        switch (e.getType()) {
            case 210: {
                TableColumn[] tableColumnArray = this.getUiField().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn swtCol = tableColumnArray[n2];
                    this.updateHeaderText(swtCol);
                    ++n2;
                }
                this.setSelectionFromScout(e.getTable().getSelectedRows());
            }
        }
    }

    private void updateHeaderText(TableColumn swtCol) {
        if (swtCol == null) {
            return;
        }
        Object data = swtCol.getData("scoutColumn");
        if (data instanceof IColumn) {
            this.updateHeaderText(swtCol, (IColumn)data);
        }
    }

    private void updateHeaderText(TableColumn swtCol, IColumn<?> scoutCol) {
        this.updateHeaderText(swtCol, scoutCol, false);
    }

    private void updateHeaderText(TableColumn swtCol, IColumn<?> scoutCol, boolean indicateSortOrder) {
        IHeaderCell cell = scoutCol.getHeaderCell();
        String text = cell.getText();
        if (text == null) {
            text = "";
        }
        if (scoutCol instanceof ICustomColumn) {
            text = "[+] " + text;
        }
        if (scoutCol.isColumnFilterActive()) {
            text = "(*) " + text;
        }
        if (indicateSortOrder) {
            text = scoutCol.isSortAscending() ? "[a-z] " + text : "[z-a] " + text;
        }
        swtCol.setText(text);
    }

    protected void setHeaderVisibleFromScout(boolean headerVisible) {
        this.getUiField().setHeaderVisible(headerVisible);
    }

    @Override
    public void setEnabledFromScout(boolean enabledFromScout) {
        this.getUiField().setEnabled(true);
        TableColumn[] tableColumnArray = this.getUiField().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setData("org.eclipse.rap.rwt.customVariant", (Object)(enabledFromScout ? null : "customDisabled"));
            ++n2;
        }
    }

    protected void setSelectionFromScout(List<ITableRow> selectedRows) {
        if (this.getUiField().isDisposed()) {
            return;
        }
        List<ITableRow> uiSelection = this.getUiSelectedRows();
        if (CompareUtility.equals(uiSelection, selectedRows)) {
            return;
        }
        if (selectedRows == null) {
            selectedRows = Collections.emptyList();
        }
        this.getUiTableViewer().setSelection((ISelection)new StructuredSelection(selectedRows), true);
        this.updateScrollToSelectionFromScout();
    }

    private void updateScrollToSelectionFromScout() {
        if (((ITable)this.getScoutObject()).isScrollToSelection()) {
            this.scrollToSelection();
        }
    }

    protected void scrollToSelection() {
        if (this.getUiField() != null && !this.getUiField().isDisposed()) {
            this.getUiField().showSelection();
        }
    }

    protected void setContextColumnFromUi(TableColumn uiColumn) {
        if (this.getScoutObject() != null) {
            Point pDisp = this.getUiField().toDisplay(-this.getUiField().getHorizontalBar().getSelection(), 0);
            TableColumn[] tableColumnArray = this.getUiField().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn c = tableColumnArray[n2];
                if (c == uiColumn) break;
                pDisp.x += c.getWidth();
                ++n2;
            }
            this.getUiEnvironment().setPopupOwner((Control)this.getUiField(), new Rectangle(pDisp.x - 2, pDisp.y, 1, this.getUiField().getHeaderHeight()));
            IColumn scoutColumn = null;
            if (uiColumn != null) {
                scoutColumn = (IColumn)uiColumn.getData("scoutColumn");
            }
            final IColumn finalCol = scoutColumn;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().setContextColumnFromUI(finalCol);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private int getVisualCellIndex(TableItem tableItem, int columnIndex) {
        int[] columnOrder;
        int visualCellIndex = columnIndex;
        int[] nArray = columnOrder = tableItem.getParent().getColumnOrder();
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (element == columnIndex) {
                visualCellIndex = columnIndex;
            }
            ++n2;
        }
        return visualCellIndex;
    }

    private TableColumn getUiColumnAt(Point p) {
        int[] order;
        Table table = this.getUiTableViewer().getTable();
        int x = p.x + this.getUiField().getHorizontalBar().getSelection();
        int[] nArray = order = table.getColumnOrder();
        int n = order.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableColumn c = table.getColumn(index);
            if (c != null) {
                if (x >= 0 && x <= c.getWidth()) {
                    return c;
                }
                x -= c.getWidth();
            }
            ++n2;
        }
        return null;
    }

    protected void setSelectionFromUi(final StructuredSelection selection) {
        if (this.getUpdateUiFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        RwtScoutTable.this.addIgnoredScoutEvent(TableEvent.class, "103");
                        ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().setSelectedRowsFromUI(RwtUtility.getItemsOfSelection(ITableRow.class, selection));
                    }
                    finally {
                        RwtScoutTable.this.removeIgnoredScoutEvent(TableEvent.class, "103");
                    }
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void headerUpdateFromScout() {
        IColumn cell;
        Object data;
        TableColumn col;
        int minSortIndex = -1;
        TableColumn minUiSortColumn = null;
        IColumn minScoutSortColumn = null;
        TableColumn[] tableColumnArray = this.getUiField().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            col = tableColumnArray[n2];
            data = col.getData("scoutColumn");
            if (data instanceof IColumn) {
                cell = (IColumn)data;
                if (cell.isSortExplicit() && (minSortIndex == -1 || cell.getSortIndex() < minSortIndex)) {
                    minSortIndex = cell.getSortIndex();
                    minUiSortColumn = col;
                    minScoutSortColumn = cell;
                }
                this.updateHeaderText(col);
            }
            ++n2;
        }
        if (minUiSortColumn != null && minScoutSortColumn != null) {
            this.getUiField().setSortColumn(minUiSortColumn);
            this.getUiField().setSortDirection(minScoutSortColumn.isSortAscending() ? 128 : 1024);
        } else {
            this.getUiField().setSortColumn(null);
        }
        tableColumnArray = this.getUiField().getColumns();
        n = tableColumnArray.length;
        n2 = 0;
        while (n2 < n) {
            col = tableColumnArray[n2];
            data = col.getData("scoutColumn");
            if (data instanceof IColumn) {
                cell = (IColumn)data;
                boolean indicateSortOrder = cell.isSortExplicit() && cell != minScoutSortColumn;
                this.updateHeaderText(col, cell, indicateSortOrder);
            }
            ++n2;
        }
    }

    protected void handleUiRowClick(final ITableRow row) {
        if (this.getScoutObject() != null && row != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().fireRowClickFromUI(row);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleUiRowAction(final ITableRow row) {
        if (this.getScoutObject() != null && !((ITable)this.getScoutObject()).isCheckable() && row != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().fireRowActionFromUI(row);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleUiHyperlinkAction(final ITableRow row, String urlText) {
        if (this.getScoutObject() != null) {
            URL url;
            try {
                url = new URL(urlText);
            }
            catch (MalformedURLException e) {
                LOG.error("Hyperlink could not be activated", (Throwable)e);
                return;
            }
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ITable table = (ITable)RwtScoutTable.this.getScoutObject();
                    table.getUIFacade().fireHyperlinkActionFromUI(row, table.getContextColumn(), url);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleAutoSizeColumns() {
        int width;
        if (this.getUiField() == null || this.getUiField().isDisposed()) {
            return;
        }
        int totalWidth = this.getUiField().getClientArea().width;
        if (totalWidth < 32) {
            return;
        }
        int totalWeight = 0;
        int actualWidth = 0;
        HashMap<TableColumn, Integer> columnWeights = new HashMap<TableColumn, Integer>();
        TableColumn[] tableColumnArray = this.getUiField().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            if (col != null && !col.isDisposed()) {
                actualWidth += col.getWidth();
                Object data = col.getData("scoutColumn");
                if (data instanceof IColumn && !((IColumn)data).isFixedWidth()) {
                    width = ((IColumn)data).getInitialWidth();
                    columnWeights.put(col, width);
                    totalWeight += width;
                } else {
                    totalWidth -= col.getWidth();
                }
            }
            ++n2;
        }
        if (actualWidth == totalWidth) {
            return;
        }
        double factor = (double)totalWidth / (double)totalWeight;
        int i = 0;
        for (Map.Entry entry : columnWeights.entrySet()) {
            if (i < columnWeights.size() - 1) {
                width = (int)(factor * (double)((Integer)entry.getValue()).intValue());
                ((TableColumn)entry.getKey()).setWidth(width);
                totalWidth -= width;
                ++i;
                continue;
            }
            ((TableColumn)entry.getKey()).setWidth(totalWidth);
        }
    }

    protected void handleUiColumnResized(TableColumn column) {
        if (column.isDisposed()) {
            return;
        }
        if (!column.getParent().isVisible()) {
            return;
        }
        if (this.getUpdateUiFromScoutLock().isAcquired()) {
            return;
        }
        final int width = column.getWidth();
        final IColumn scoutColumn = (IColumn)column.getData("scoutColumn");
        if (scoutColumn != null && scoutColumn.getWidth() != width) {
            if (this.m_storeColumnWidthsJob != null) {
                this.m_storeColumnWidthsJob.cancel();
            }
            this.m_storeColumnWidthsJob = new ClientSyncJob("Store column widths", this.getUiEnvironment().getClientSession()){

                protected IStatus runStatus(IProgressMonitor monitor) {
                    try {
                        RwtScoutTable.this.addIgnoredScoutEvent(TableEvent.class, "1");
                        ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().setColumnWidthFromUI(scoutColumn, width);
                    }
                    finally {
                        RwtScoutTable.this.removeIgnoredScoutEvent(TableEvent.class, "1");
                    }
                    return Status.OK_STATUS;
                }
            };
            this.m_storeColumnWidthsJob.schedule(400L);
        }
    }

    protected void handleUiColumnMoved() {
        if (this.getUpdateUiFromScoutLock().isAcquired()) {
            return;
        }
        int[] uiColumnOrder = this.getUiField().getColumnOrder();
        if (uiColumnOrder[0] != 0) {
            this.getUiField().setColumnOrder(this.m_uiColumnOrder);
            return;
        }
        if (uiColumnOrder[1] != this.m_uiColumnOrder[1] && ((ITable)this.getScoutObject()).getRowCount() > 0 && StringUtility.hasText((String)((ITable)this.getScoutObject()).getRow(0).getIconId())) {
            this.getUiTableViewer().refresh();
        }
        int[] truncatedColOrder = new int[uiColumnOrder.length - 1];
        int i = 0;
        while (i < truncatedColOrder.length) {
            truncatedColOrder[i] = uiColumnOrder[i + 1] - 1;
            ++i;
        }
        final List<IColumn<?>> newOrder = this.m_uiColumnManager.getOrderedColumns(truncatedColOrder);
        if (this.m_uiColumnManager.applyNewOrder(newOrder)) {
            this.m_uiColumnOrder = uiColumnOrder;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        RwtScoutTable.this.addIgnoredScoutEvent(TableEvent.class, "770");
                        RwtScoutTable.this.addIgnoredScoutEvent(TableEvent.class, "1");
                        ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().fireVisibleColumnsChangedFromUI((Collection)newOrder);
                    }
                    finally {
                        RwtScoutTable.this.removeIgnoredScoutEvent(TableEvent.class, "770");
                        RwtScoutTable.this.removeIgnoredScoutEvent(TableEvent.class, "1");
                    }
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleKeyboardNavigationFromUi(TableItem item) {
        this.getUiField().setSelection(item);
        Event selectionEvent = new Event();
        selectionEvent.type = 14;
        selectionEvent.widget = this.getUiField();
        Listener[] listenerArray = this.getUiField().getListeners(14);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener l = listenerArray[n2];
            l.handleEvent(selectionEvent);
            ++n2;
        }
    }

    protected void handleUiToggleAcction(Event e) {
        if (e.doit && ((ITable)this.getScoutObject()).isCheckable() && e.stateMask == 0) {
            switch (e.keyCode) {
                case 32: {
                    List<ITableRow> selectedRows = RwtUtility.getItemsOfSelection(ITableRow.class, (StructuredSelection)this.getUiTableViewer().getSelection());
                    if (CollectionUtility.hasElements(selectedRows)) {
                        this.handleUiRowClick((ITableRow)CollectionUtility.firstElement(selectedRows));
                    }
                    e.doit = false;
                }
            }
        }
    }

    private Menu createMenu(boolean headerMenu) {
        if (this.getUiField().getMenu() != null) {
            this.getUiField().getMenu().dispose();
            this.getUiField().setMenu(null);
        }
        Menu contextMenu = new Menu((Decorations)this.getUiField().getShell(), 8);
        contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener(headerMenu));
        this.getUiField().setMenu(contextMenu);
        return contextMenu;
    }

    private void createAndShowMenu(Point location) {
        Point pt = this.getUiField().getDisplay().map(null, (Control)this.getUiField(), location);
        Rectangle clientArea = this.getUiField().getClientArea();
        boolean header = clientArea.y <= pt.y && pt.y < clientArea.y + this.getUiField().getHeaderHeight();
        Menu menu = this.createMenu(header);
        menu.setLocation(location);
        menu.setVisible(true);
    }

    private class P_ColumnSortListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        private P_ColumnSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean ctrlKeyPressed;
            TableColumn col = (TableColumn)e.getSource();
            RwtScoutTable.this.setContextColumnFromUi(col);
            final IColumn newColumn = (IColumn)col.getData("scoutColumn");
            boolean bl = ctrlKeyPressed = (e.stateMask & 0x40000) > 0;
            if (RwtScoutTable.this.getScoutObject() != null) {
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().fireHeaderSortFromUI(newColumn, ctrlKeyPressed);
                    }
                };
                RwtScoutTable.this.getUiEnvironment().invokeScoutLater(job, 0L);
            }
        }
    }

    private class P_ContextMenuListener
    extends MenuAdapterEx {
        private boolean m_header;
        private static final long serialVersionUID = 1L;

        public P_ContextMenuListener(boolean header) {
            super((Control)RwtScoutTable.this.getUiTableViewer().getTable(), (Control)RwtScoutTable.this.getUiTableViewer().getTable());
            this.m_header = header;
        }

        @Override
        public void menuShown(MenuEvent e) {
            super.menuShown(e);
            final IActionFilter aboutToShowFilter = this.m_header ? ActionUtility.createMenuFilterMenuTypes((Set)CollectionUtility.hashSet((Object[])new TableMenuType[]{TableMenuType.EmptySpace, TableMenuType.Header}), (boolean)false) : ActionUtility.createMenuFilterMenuTypes((Set)((ITable)RwtScoutTable.this.getScoutObject()).getContextMenu().getCurrentMenuTypes(), (boolean)false);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ITableContextMenu contextMenu = ((ITable)RwtScoutTable.this.getScoutObject()).getContextMenu();
                    contextMenu.callAboutToShow(aboutToShowFilter);
                }
            };
            JobEx job = RwtScoutTable.this.getUiEnvironment().invokeScoutLater(t, 1200L);
            try {
                job.join(1200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IActionFilter displayFilter = this.m_header ? ActionUtility.createMenuFilterMenuTypes((Set)CollectionUtility.hashSet((Object[])new TableMenuType[]{TableMenuType.EmptySpace, TableMenuType.Header}), (boolean)true) : ActionUtility.createMenuFilterMenuTypes((Set)((ITable)RwtScoutTable.this.getScoutObject()).getContextMenu().getCurrentMenuTypes(), (boolean)true);
            RwtMenuUtility.fillMenu((Menu)e.getSource(), ((ITable)RwtScoutTable.this.getScoutObject()).getContextMenu().getChildActions(), displayFilter, RwtScoutTable.this.getUiEnvironment());
        }
    }

    private class P_DndSupport
    extends AbstractRwtScoutDndSupport {
        public P_DndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control) {
            super(scoutObject, scoutDndSupportable, control, RwtScoutTable.this.getUiEnvironment());
        }

        @Override
        protected TransferObject handleUiDragRequest() {
            final Holder result = new Holder(TransferObject.class, null);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().fireRowsDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            try {
                this.getUiEnvironment().invokeScoutLater(t, 20000L).join(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return (TransferObject)result.getValue();
        }

        @Override
        protected void handleUiDropAction(DropTargetEvent event, final TransferObject scoutTransferObject) {
            Object dropTarget = event.item != null ? event.item.getData() : null;
            final ITableRow row = dropTarget instanceof ITableRow ? (ITableRow)dropTarget : null;
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    ((ITable)RwtScoutTable.this.getScoutObject()).getUIFacade().fireRowDropActionFromUI(row, scoutTransferObject);
                }
            };
            this.getUiEnvironment().invokeScoutLater(job, 200L);
        }
    }

    private class P_KeyBoardNavigationSupport
    extends AbstractTableKeyboardNavigationSupport {
        public P_KeyBoardNavigationSupport(TableEx table) {
            super(table);
        }

        @Override
        public void handleKeyboardNavigation(TableItem tableItem) {
            RwtScoutTable.this.handleKeyboardNavigationFromUi(tableItem);
        }
    }

    private class P_RwtHeaderMenuDetectListener
    implements MenuDetectListener {
        private static final long serialVersionUID = 1L;

        private P_RwtHeaderMenuDetectListener() {
        }

        public void menuDetected(MenuDetectEvent event) {
            boolean header;
            TableEx table = RwtScoutTable.this.getUiField();
            Point pTable = table.getDisplay().map(null, (Control)table, new Point(event.x, event.y));
            Rectangle clientArea = table.getClientArea();
            boolean bl = header = clientArea.y <= pTable.y && pTable.y < clientArea.y + table.getHeaderHeight();
            if (!header) {
                return;
            }
            RwtScoutTable.this.setContextColumnFromUi(RwtScoutTable.this.getUiColumnAt(pTable));
        }
    }

    private class P_RwtHyperlinkSelectionListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        private P_RwtHyperlinkSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.detail == 0x4000000) {
                TableItem tableItem = (TableItem)event.item;
                ITableRow row = (ITableRow)tableItem.getData();
                RwtScoutTable.this.handleUiHyperlinkAction(row, event.text);
            }
        }
    }

    private class P_RwtResizeListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_RwtResizeListener() {
        }

        public void handleEvent(Event event) {
            if (RwtScoutTable.this.getUiField() != null && !RwtScoutTable.this.getUiField().isDisposed()) {
                if (((ITable)RwtScoutTable.this.getScoutObject()).isAutoResizeColumns()) {
                    RwtScoutTable.this.scheduleHandleAutoResizeColumn();
                }
                RwtScoutTable.this.updateScrollToSelectionFromScout();
            }
        }
    }

    public class P_RwtSelectionChangedListener
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            RwtScoutTable.this.setSelectionFromUi((StructuredSelection)event.getSelection());
        }
    }

    private class P_RwtTableListener
    extends AbstractAvoidWrongDoubleClickListener {
        private static final long serialVersionUID = 1L;

        private P_RwtTableListener() {
        }

        @Override
        public void handleEventInternal(Event event) {
            Point eventPosition = new Point(event.x, event.y);
            TableViewer uiTableViewer = RwtScoutTable.this.getUiTableViewer();
            switch (event.type) {
                case 3: {
                    if (uiTableViewer.getTable().getItem(new Point(event.y, event.y)) == null && uiTableViewer instanceof TableViewerEx) {
                        ((TableViewerEx)uiTableViewer).applyEditorValue();
                    }
                    RwtScoutTable.this.setContextColumnFromUi(RwtUtility.getRwtColumnAt(uiTableViewer.getTable(), eventPosition));
                    if (RwtScoutTable.this.getUiField().getItem(eventPosition) != null) break;
                    uiTableViewer.setSelection(null);
                    RwtScoutTable.this.setSelectionFromUi(new StructuredSelection());
                    break;
                }
                case 4: {
                    StructuredSelection selection = (StructuredSelection)uiTableViewer.getSelection();
                    if (selection == null || selection.size() != 1) break;
                    RwtScoutTable.this.handleUiRowClick((ITableRow)selection.getFirstElement());
                    break;
                }
                case 8: {
                    StructuredSelection selection = (StructuredSelection)uiTableViewer.getSelection();
                    if (selection == null || selection.size() != 1) break;
                    RwtScoutTable.this.handleUiRowAction((ITableRow)selection.getFirstElement());
                    break;
                }
                case 11: {
                    if (RwtScoutTable.this.getUiField() == null || RwtScoutTable.this.getUiField().isDisposed()) break;
                    if (((ITable)RwtScoutTable.this.getScoutObject()).isAutoResizeColumns()) {
                        RwtScoutTable.this.scheduleHandleAutoResizeColumn();
                    }
                    RwtScoutTable.this.updateScrollToSelectionFromScout();
                    break;
                }
                case 35: {
                    RwtScoutTable.this.createAndShowMenu(eventPosition);
                }
            }
        }
    }

    private class P_ScoutTableListener
    implements TableListener {
        private P_ScoutTableListener() {
        }

        public void tableChanged(final TableEvent e) {
            if (RwtScoutTable.this.isHandleScoutTableEvent(CollectionUtility.arrayList((Object)e))) {
                if (RwtScoutTable.this.isIgnoredScoutEvent(TableEvent.class, "" + e.getType())) {
                    return;
                }
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RwtScoutTable.this.getUpdateUiFromScoutLock().acquire();
                            RwtScoutTable.this.handleScoutTableEventInUi(e);
                        }
                        finally {
                            RwtScoutTable.this.getUpdateUiFromScoutLock().release();
                        }
                    }
                };
                RwtScoutTable.this.getUiEnvironment().invokeUiLater(t);
            }
        }

        public void tableChangedBatch(List<? extends TableEvent> events) {
            if (RwtScoutTable.this.isHandleScoutTableEvent(events)) {
                final ArrayList<TableEvent> filteredList = new ArrayList<TableEvent>();
                for (TableEvent tableEvent : events) {
                    if (RwtScoutTable.this.isIgnoredScoutEvent(TableEvent.class, "" + tableEvent.getType())) continue;
                    filteredList.add(tableEvent);
                }
                if (CollectionUtility.hasElements(filteredList)) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (RwtScoutTable.this.isUiDisposed()) {
                                return;
                            }
                            RwtScoutTable.this.m_redrawHandler.pushControlChanging();
                            try {
                                try {
                                    RwtScoutTable.this.getUpdateUiFromScoutLock().acquire();
                                    for (TableEvent element : filteredList) {
                                        RwtScoutTable.this.handleScoutTableEventInUi(element);
                                    }
                                }
                                finally {
                                    RwtScoutTable.this.getUpdateUiFromScoutLock().release();
                                }
                            }
                            finally {
                                RwtScoutTable.this.m_redrawHandler.popControlChanging();
                            }
                        }
                    };
                    RwtScoutTable.this.getUiEnvironment().invokeUiLater(runnable);
                }
            }
        }
    }

    private class P_TableColumnListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_TableColumnListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 10: {
                    RwtScoutTable.this.handleUiColumnMoved();
                    break;
                }
                case 11: {
                    if (!(event.widget instanceof TableColumn)) break;
                    RwtScoutTable.this.handleUiColumnResized((TableColumn)event.widget);
                }
            }
        }
    }
}

