/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext;

import java.util.EventListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;

public class DropDownButton
extends Button {
    private static final long serialVersionUID = 1L;
    private Rectangle m_buttonArea = new Rectangle(1, 1, 13, 17);
    private Rectangle m_dropDownArea = new Rectangle(14, 1, 10, 17);
    private EventListenerList m_eventListeners = new EventListenerList();
    private Point m_mouseDownPosition;
    private boolean m_dropdownEnabled = true;
    private boolean m_buttonEnabled = true;
    private MouseListener m_mouseListener;
    private String m_originalVariant = "";

    public DropDownButton(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addOrRemoveMouseListener();
    }

    protected void addOrRemoveMouseListener() {
        if (this.isButtonEnabled() || this.isDropdownEnabled()) {
            this.addMouseListener();
        } else {
            this.removeMouseListener();
        }
    }

    protected void addMouseListener() {
        if (this.m_mouseListener != null) {
            return;
        }
        this.m_mouseListener = new MouseAdapter(){
            private static final long serialVersionUID = 1L;

            public void mouseUp(MouseEvent event) {
                if (event.button == 1) {
                    DropDownButton.this.handleSelectionInternal(event);
                }
            }
        };
        this.addMouseListener(this.m_mouseListener);
    }

    protected void removeMouseListener() {
        if (this.m_mouseListener == null) {
            return;
        }
        this.removeMouseListener(this.m_mouseListener);
        this.m_mouseListener = null;
    }

    public boolean forceFocus() {
        if ((this.getStyle() & 0x80000) != 0) {
            return false;
        }
        return super.forceFocus();
    }

    protected void handleSelectionInternal(MouseEvent event) {
        Menu menu;
        Point pt = new Point(event.x, event.y);
        if (this.m_buttonArea.contains(pt) && this.isButtonEnabled()) {
            Event e = new Event();
            e.button = event.button;
            e.count = 1;
            e.data = event.data;
            e.display = event.display;
            e.stateMask = event.stateMask;
            e.time = event.time;
            e.widget = event.widget;
            e.x = event.x;
            e.y = event.y;
            this.fireSelectionEvent(new SelectionEvent(e));
        } else if (this.m_dropDownArea.contains(pt) && this.isDropdownEnabled() && (menu = this.createMenu()) != null) {
            menu.setLocation(this.toDisplay(event.x, event.y));
            menu.setVisible(true);
        }
    }

    private Menu createMenu() {
        if (this.getMenu() != null) {
            this.getMenu().dispose();
            this.setMenu(null);
        }
        Menu contextMenu = new Menu((Decorations)this.getShell(), 8);
        MenuListener[] menuListenerArray = (MenuListener[])this.m_eventListeners.getListeners(MenuListener.class);
        int n = menuListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuListener listener = menuListenerArray[n2];
            contextMenu.addMenuListener(listener);
            ++n2;
        }
        this.setMenu(contextMenu);
        return contextMenu;
    }

    public void fireSelectionEvent(SelectionEvent e) {
        if (this.isButtonEnabled()) {
            SelectionListener[] selectionListenerArray = (SelectionListener[])this.m_eventListeners.getListeners(SelectionListener.class);
            int n = selectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SelectionListener l = selectionListenerArray[n2];
                l.widgetSelected(e);
                ++n2;
            }
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.m_eventListeners.add(SelectionListener.class, (EventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.m_eventListeners.remove(SelectionListener.class, (EventListener)listener);
    }

    public void addMenuListener(MenuListener listener) {
        this.m_eventListeners.add(MenuListener.class, (EventListener)listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.m_eventListeners.remove(MenuListener.class, (EventListener)listener);
    }

    public void setDropdownEnabled(boolean enabled) {
        this.m_dropdownEnabled = enabled;
        this.setCustomVariant();
        this.addOrRemoveMouseListener();
    }

    public boolean isDropdownEnabled() {
        return this.m_dropdownEnabled;
    }

    public void setButtonEnabled(boolean enabled) {
        this.m_buttonEnabled = enabled;
        this.setCustomVariant();
        this.addOrRemoveMouseListener();
    }

    public boolean isButtonEnabled() {
        return this.m_buttonEnabled;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_buttonEnabled = enabled;
        this.m_dropdownEnabled = enabled;
    }

    private void setCustomVariant() {
        if (!StringUtility.hasText((String)this.m_originalVariant)) {
            this.m_originalVariant = (String)this.getData("org.eclipse.rap.rwt.customVariant");
        }
        if (this.m_originalVariant != null) {
            String customVariant = this.m_originalVariant;
            if (!this.m_buttonEnabled) {
                customVariant = String.valueOf(customVariant) + "_disabled";
            }
            if (this.m_dropdownEnabled) {
                customVariant = String.valueOf(customVariant) + "_menu";
            }
            this.setData("org.eclipse.rap.rwt.customVariant", customVariant);
        }
    }

    protected void checkSubclass() {
    }

    private IRwtEnvironment getUiEnvironment() {
        return (IRwtEnvironment)this.getDisplay().getData(IRwtEnvironment.class.getName());
    }
}

