/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ImageViewer
extends Canvas {
    private static final long serialVersionUID = 1L;
    private final int FOCUS_BORDER_OFFSET_PX = 2;
    private final Rectangle FOCUS_BORDER_OFFSET = new Rectangle(2, 2, -4, -4);
    private final Rectangle NO_FOCUS_BORDER_OFFSET = new Rectangle(0, 0, 0, 0);
    private int m_xAglin = 0x1000000;
    private int m_yAglin = 0x1000000;
    private boolean m_autoFit = false;
    private Image m_image;
    private Image m_scaledImage;
    private KeyListener m_keyListener;

    public ImageViewer(Composite parent) {
        super(parent, 0);
        this.addPaintListener(new PaintListener(){
            private static final long serialVersionUID = 1L;

            public void paintControl(PaintEvent e) {
                ImageViewer.this.handleUiPaintEvent(e.gc);
            }
        });
        this.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
                ImageViewer.this.freeResources();
            }
        });
        this.addFocusListener(new FocusListener(){
            private static final long serialVersionUID = 1L;

            public void focusLost(FocusEvent e) {
                ImageViewer.this.redraw();
            }

            public void focusGained(FocusEvent e) {
                ImageViewer.this.redraw();
            }
        });
    }

    private void freeResources() {
        if (this.m_scaledImage != null && !this.m_scaledImage.isDisposed() && this.m_scaledImage.getDevice() != null) {
            this.m_scaledImage.dispose();
            this.m_scaledImage = null;
        }
    }

    private Image scaleImage(Image img) {
        this.freeResources();
        if (this.m_autoFit && img != null) {
            Rectangle clientArea = this.getClientArea();
            if (clientArea.width == 0 || clientArea.height == 0) {
                return img;
            }
            Rectangle imageBounds = img.getBounds();
            if (imageBounds.width == 0 || imageBounds.height == 0) {
                return null;
            }
            double scaleFactor = (double)clientArea.width / (double)imageBounds.width;
            scaleFactor = Math.min(scaleFactor, (double)clientArea.height / (double)img.getBounds().height);
            this.m_scaledImage = new Image((Device)this.getDisplay(), img.getImageData().scaledTo((int)(scaleFactor * (double)img.getBounds().width), (int)(scaleFactor * (double)img.getBounds().height)));
            return this.m_scaledImage;
        }
        return img;
    }

    public Rectangle getClientArea() {
        Rectangle clientArea = super.getClientArea();
        if (this.isFocusable()) {
            clientArea.x += this.FOCUS_BORDER_OFFSET.x;
            clientArea.y += this.FOCUS_BORDER_OFFSET.y;
            clientArea.width += this.FOCUS_BORDER_OFFSET.width;
            clientArea.height += this.FOCUS_BORDER_OFFSET.height;
        }
        return clientArea;
    }

    protected void handleUiPaintEvent(GC gc) {
        Image img = this.getImage();
        Rectangle bounds = gc.getClipping();
        if (img != null) {
            if (this.isAutoFit()) {
                img = this.scaleImage(img);
            }
            Rectangle imgBounds = img.getBounds();
            Rectangle focusBorderOffset = this.getFocusBorderOffset();
            int x = 0;
            if (imgBounds.width <= bounds.width) {
                switch (this.getAlignmentX()) {
                    case 0x1000000: {
                        x = (bounds.width - imgBounds.width + focusBorderOffset.width) / 2;
                        break;
                    }
                    case 131072: {
                        x = bounds.width - imgBounds.width + focusBorderOffset.width;
                        break;
                    }
                    default: {
                        x = 0;
                    }
                }
            }
            int y = 0;
            if (imgBounds.height <= bounds.height) {
                switch (this.getAlignmentY()) {
                    case 0: {
                        y = (bounds.height - imgBounds.height + focusBorderOffset.height) / 2;
                        break;
                    }
                    case 1024: {
                        y = bounds.height - imgBounds.height + focusBorderOffset.height;
                        break;
                    }
                    default: {
                        y = 0;
                    }
                }
            }
            gc.drawImage(img, x + focusBorderOffset.x, y + focusBorderOffset.y);
            if (this.isFocusable() && this.isFocusControl()) {
                gc.drawFocus(x, y, imgBounds.width - focusBorderOffset.width, imgBounds.height - focusBorderOffset.height);
            }
        }
    }

    protected Rectangle getFocusBorderOffset() {
        if (this.isFocusable()) {
            return this.FOCUS_BORDER_OFFSET;
        }
        return this.NO_FOCUS_BORDER_OFFSET;
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        Point size = super.computeSize(hint, hint2, changed);
        if (this.getImage() != null) {
            Rectangle imgBounds = this.getImage().getBounds();
            size.x = imgBounds.width;
            size.y = imgBounds.height;
        }
        return size;
    }

    public void setAlignmentX(int alignment) {
        this.m_xAglin = alignment;
    }

    public int getAlignmentX() {
        return this.m_xAglin;
    }

    public void setAlignmentY(int alignment) {
        this.m_yAglin = alignment;
    }

    public int getAlignmentY() {
        return this.m_yAglin;
    }

    public synchronized boolean isFocusable() {
        return this.m_keyListener != null;
    }

    public synchronized void setFocusable(boolean focusable) {
        if (focusable) {
            if (this.m_keyListener == null) {
                this.m_keyListener = new KeyAdapter(){
                    private static final long serialVersionUID = 1L;

                    public void keyReleased(KeyEvent e) {
                    }
                };
                this.addKeyListener(this.m_keyListener);
            }
        } else if (this.m_keyListener != null) {
            this.removeKeyListener(this.m_keyListener);
            this.m_keyListener = null;
        }
    }

    public boolean isAutoFit() {
        return this.m_autoFit;
    }

    public void setAutoFit(boolean autoFit) {
        this.m_autoFit = autoFit;
    }

    public void setImage(Image img) {
        this.m_image = img;
    }

    public Image getImage() {
        return this.m_image;
    }
}

