/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.button;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton;
import org.eclipse.scout.rt.client.ui.form.fields.snapbox.ISnapBox;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.extension.IFormFieldFactory;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutFormField;
import org.eclipse.scout.rt.ui.rap.form.fields.button.IRwtScoutButton;
import org.eclipse.scout.rt.ui.rap.form.fields.button.RwtScoutButton;
import org.eclipse.scout.rt.ui.rap.form.fields.button.RwtScoutRadioButton;
import org.eclipse.scout.rt.ui.rap.form.fields.snapbox.button.RwtScoutSnapBoxMaximizedButton;
import org.eclipse.swt.widgets.Composite;

public class ButtonFieldFactory
implements IFormFieldFactory {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ButtonFieldFactory.class);

    @Override
    public IRwtScoutFormField<?> createUiFormField(Composite parent, IFormField model, IRwtEnvironment uiEnvironment) {
        if (model instanceof IRadioButton) {
            IRadioButton radio = (IRadioButton)model;
            RwtScoutRadioButton field = new RwtScoutRadioButton();
            field.createUiField(parent, radio, uiEnvironment);
            return field;
        }
        if (model instanceof IButton) {
            IButton button = (IButton)model;
            IRwtScoutButton<IButton> field = null;
            if (button.getParentField() instanceof ISnapBox) {
                field = this.createRwtScoutSnapBoxMaximizedButton();
            } else {
                if (((IButton)model).getDisplayStyle() == 2) {
                    LOG.warn("It seems your RadioButton extends from AbstractButton with getConfiguredDisplayStyle set to DISPLAY_STYLE_RADIO. Please use the class AbstractRadioButton instead.");
                }
                field = this.createRwtScoutButton();
            }
            field.createUiField(parent, button, uiEnvironment);
            return field;
        }
        return null;
    }

    protected IRwtScoutButton<IButton> createRwtScoutSnapBoxMaximizedButton() {
        return new RwtScoutSnapBoxMaximizedButton();
    }

    protected IRwtScoutButton<IButton> createRwtScoutButton() {
        return new RwtScoutButton<IButton>();
    }
}

