/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.colorpickerfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.colorpickerfield.IColorField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtScoutContextMenu;
import org.eclipse.scout.rt.ui.rap.basic.ColorUtility;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.StyledTextEx;
import org.eclipse.scout.rt.ui.rap.ext.custom.StyledText;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutBasicFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.colorpickerfield.IRwtScoutColorField;
import org.eclipse.scout.rt.ui.rap.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class RwtScoutColorField
extends RwtScoutBasicFieldComposite<IColorField>
implements IRwtScoutColorField {
    private Label m_colorPreviewLabel;
    private Button m_colorPickButton;
    private Composite m_colorPickerContainer;
    private TextFieldEditableSupport m_editableSupport;
    private Color m_previewColor;
    private RwtContextMenuMarkerComposite m_menuMarkerComposite;
    private RwtScoutContextMenu m_uiContextMenu;
    private P_ContextMenuPropertyListener m_contextMenuPropertyListener;

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        this.m_colorPickerContainer = this.getUiEnvironment().getFormToolkit().createComposite(container, 2048);
        this.m_colorPickerContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"colorfield");
        this.m_colorPreviewLabel = this.getUiEnvironment().getFormToolkit().createLabel(this.m_colorPickerContainer, "");
        this.m_colorPreviewLabel.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent event) {
                if (RwtScoutColorField.this.m_previewColor != null) {
                    RwtScoutColorField.this.m_previewColor.dispose();
                }
            }
        });
        this.m_colorPreviewLabel.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getColorPickerFieldVariant());
        Label splitLabel = this.getUiEnvironment().getFormToolkit().createLabel(this.m_colorPickerContainer, "");
        splitLabel.setData("org.eclipse.rap.rwt.customVariant", (Object)"colorpickerfield_splitLabel");
        this.m_menuMarkerComposite = new RwtContextMenuMarkerComposite(this.m_colorPickerContainer, this.getUiEnvironment(), 0);
        this.getUiEnvironment().getFormToolkit().adapt(this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                if (RwtScoutColorField.this.getUiContextMenu() != null) {
                    Menu uiMenu = RwtScoutColorField.this.getUiContextMenu().getUiMenu();
                    if (e.widget instanceof Control) {
                        Point loc = ((Control)e.widget).toDisplay(e.x, e.y);
                        uiMenu.setLocation(RwtMenuUtility.getMenuLocation(((IColorField)RwtScoutColorField.this.getScoutObject()).getContextMenu().getChildActions(), uiMenu, loc, RwtScoutColorField.this.getUiEnvironment()));
                    }
                    uiMenu.setVisible(true);
                }
            }
        });
        StyledTextEx textField = new StyledTextEx(this.m_menuMarkerComposite, 4);
        this.getUiEnvironment().getFormToolkit().adapt((Control)textField, false, false);
        textField.setData("org.eclipse.rap.rwt.customVariant", this.getColorPickerFieldVariant());
        this.m_colorPickButton = this.getUiEnvironment().getFormToolkit().createButton(this.m_colorPickerContainer, "", 8);
        this.m_colorPickButton.setImage(this.getUiEnvironment().getIcon("colorpicker_browse"));
        this.attachFocusListener((Control)textField, true);
        this.m_colorPickButton.addMouseListener((MouseListener)new MouseAdapter(){
            private static final long serialVersionUID = 1L;

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    RwtScoutColorField.this.handleUiPickColor();
                }
            }
        });
        this.m_colorPickerContainer.setTabList(new Control[]{this.m_menuMarkerComposite});
        this.m_colorPickButton.addFocusListener((FocusListener)new FocusAdapter(){
            private static final long serialVersionUID = 1L;

            public void focusGained(FocusEvent e) {
                RwtScoutColorField.this.getUiField().setFocus();
            }
        });
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setUiField((Control)textField);
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_F2KeyStroke(), false);
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_ArrowDownKeyStroke(), false);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_colorPickerContainer.setLayoutData((Object)LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
        this.m_colorPickerContainer.setLayout((Layout)RwtLayoutUtility.createGridLayoutNoSpacing(4, false));
        GridData colorPreviewLabelData = new GridData(0x1000000, 4, false, false);
        colorPreviewLabelData.widthHint = 20;
        this.m_colorPreviewLabel.setLayoutData((Object)colorPreviewLabelData);
        GridData splitLabelData = new GridData(0x1000000, 4, false, true);
        splitLabelData.widthHint = 1;
        splitLabel.setLayoutData((Object)splitLabelData);
        GridData textLayoutData = new GridData(4, 4, true, true);
        this.m_menuMarkerComposite.setLayoutData(textLayoutData);
        GridData buttonLayoutData = new GridData(0x1000000, 0x1000000, false, false);
        buttonLayoutData.heightHint = 20;
        buttonLayoutData.widthHint = 20;
        this.m_colorPickButton.setLayoutData((Object)buttonLayoutData);
    }

    public RwtScoutContextMenu getUiContextMenu() {
        return this.m_uiContextMenu;
    }

    protected String getColorPickerFieldVariant() {
        return "colorfield";
    }

    protected String getColorPickerFieldDisabledVariant() {
        return "colorfield-disabled";
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.updateIconIdFromScout();
        this.updateContextMenuVisibilityFromScout();
        if (((IColorField)this.getScoutObject()).getContextMenu() != null && this.m_contextMenuPropertyListener == null) {
            this.m_contextMenuPropertyListener = new P_ContextMenuPropertyListener();
            ((IColorField)this.getScoutObject()).getContextMenu().addPropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_contextMenuPropertyListener != null) {
            ((IColorField)this.getScoutObject()).getContextMenu().removePropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
            this.m_contextMenuPropertyListener = null;
        }
        super.detachScout();
    }

    @Override
    public StyledText getUiField() {
        return (StyledText)super.getUiField();
    }

    @Override
    protected void setFieldEnabled(Control rwtField, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getUiField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    @Override
    protected void handleUiInputVerifier(boolean doit) {
        if (!doit) {
            return;
        }
        final String text = this.getUiField().getText();
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IColorField)RwtScoutColorField.this.getScoutObject()).getUIFacade().setTextFromUI(text, false);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getUiEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getUiEnvironment().dispatchImmediateUiJobs();
    }

    protected void handleUiPickColor() {
        RGB selectedColor;
        RGB rgb;
        ColorDialog colorDialog = new ColorDialog(this.getUiContainer().getShell());
        colorDialog.setText(ScoutTexts.get((String)"ColorPickerSelectColor", (String[])new String[0]));
        if (((IColorField)this.getScoutObject()).getValue() != null && (rgb = ColorUtility.toRGB((String)((IColorField)this.getScoutObject()).getValue())) != null) {
            colorDialog.setRGB(rgb);
        }
        if ((selectedColor = colorDialog.open()) != null) {
            final String color = org.eclipse.scout.commons.ColorUtility.rgbToText((int)selectedColor.red, (int)selectedColor.green, (int)selectedColor.blue).toUpperCase();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((IColorField)RwtScoutColorField.this.getScoutObject()).getUIFacade().setValueFromUi(color);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 2345L);
        }
    }

    @Override
    protected void setValueFromScout() {
        String value = (String)((IColorField)this.getScoutObject()).getValue();
        if (value == null) {
            value = "";
        }
        if (this.m_previewColor != null) {
            this.m_previewColor.dispose();
            this.m_previewColor = null;
        }
        this.m_previewColor = ColorUtility.createColor(this.m_colorPreviewLabel.getDisplay(), value);
        this.m_colorPreviewLabel.setBackground(this.m_previewColor);
        this.getUiField().setText(value);
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_colorPickButton.setEnabled(b);
        this.getUiField().setEnabled(b);
        if (b) {
            this.m_colorPickerContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"colorfield");
        } else {
            this.m_colorPickerContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"colorfield-disabled");
        }
    }

    protected void updateIconIdFromScout() {
        String iconId = ((IColorField)this.getScoutObject()).getIconId();
        this.m_colorPickButton.setData("org.eclipse.rap.rwt.customVariant", (Object)iconId);
        if (StringUtility.isNullOrEmpty((String)iconId)) {
            if (this.m_colorPickButton.getLayoutData() instanceof GridData) {
                GridData layoutData = (GridData)this.m_colorPickButton.getLayoutData();
                layoutData.exclude = true;
            }
            this.m_colorPickButton.setVisible(false);
        } else {
            if (this.m_colorPickButton.getLayoutData() instanceof GridData) {
                GridData layoutData = (GridData)this.m_colorPickButton.getLayoutData();
                layoutData.exclude = false;
            }
            this.m_colorPickButton.setVisible(true);
        }
    }

    protected void updateContextMenuVisibilityFromScout() {
        this.m_menuMarkerComposite.setMarkerVisible(((IColorField)this.getScoutObject()).getContextMenu().isVisible());
        if (((IColorField)this.getScoutObject()).getContextMenu().isVisible()) {
            if (this.m_uiContextMenu == null) {
                this.m_uiContextMenu = new RwtScoutContextMenu(this.getUiField().getShell(), (IContextMenu)((IColorField)this.getScoutObject()).getContextMenu(), this.getUiEnvironment());
                this.m_colorPickButton.setMenu(this.m_uiContextMenu.getUiMenu());
                this.m_colorPreviewLabel.setMenu(this.m_uiContextMenu.getUiMenu());
            }
        } else {
            this.m_colorPickButton.setMenu(null);
            this.m_colorPreviewLabel.setMenu(null);
            if (this.m_uiContextMenu != null) {
                this.m_uiContextMenu.dispose();
            }
            this.m_uiContextMenu = null;
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if ("iconId".equals(name)) {
            this.updateIconIdFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }

    private class P_ArrowDownKeyStroke
    extends RwtKeyStroke {
        public P_ArrowDownKeyStroke() {
            super(0x1000002);
        }

        @Override
        public void handleUiAction(Event e) {
            RwtScoutColorField.this.handleUiPickColor();
        }
    }

    private class P_ContextMenuPropertyListener
    implements PropertyChangeListener {
        private P_ContextMenuPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName())) {
                RwtScoutColorField.this.getUiEnvironment().invokeUiLater(new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutColorField.this.updateContextMenuVisibilityFromScout();
                    }
                });
            }
        }
    }

    private class P_F2KeyStroke
    extends RwtKeyStroke {
        public P_F2KeyStroke() {
            super(0x100000B);
        }

        @Override
        public void handleUiAction(Event e) {
            RwtScoutColorField.this.handleUiPickColor();
        }
    }
}

