/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.datefield.chooser;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TimeChooser {
    private static final int TABLE_HEIGHT = 200;
    private static final int TABLE_CELL_HEIGHT = -1;
    private final EventListenerList m_listenerList = new EventListenerList();
    private Composite m_container;
    private Table m_table;
    private DateFormat m_timeFormat;

    public TimeChooser(Composite parent) {
        this.m_container = parent;
        this.m_timeFormat = DateFormat.getTimeInstance(3, LocaleThreadLocal.get());
        this.m_table = new Table(this.m_container, 66052);
        this.m_table.setLinesVisible(true);
        this.m_table.setHeaderVisible(false);
        if (this.getTableCellHeight() != -1) {
            this.m_table.setData("org.eclipse.rap.rwt.customItemHeight", (Object)this.getTableCellHeight());
        }
        GridData data = new GridData(4, 4, true, true);
        if (this.getTableHeight() != -1) {
            data.heightHint = this.getTableHeight();
        }
        this.m_table.setLayoutData((Object)data);
        TableColumn column = new TableColumn(this.m_table, 0);
        column.setText("");
        Date[] dateArray = this.createTableData();
        int n = dateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Date value = dateArray[n2];
            TableItem item = new TableItem(this.m_table, 0);
            item.setData((Object)value);
            if (value != null) {
                item.setText(0, this.m_timeFormat.format(value));
            } else {
                item.setText(0, "n/a");
            }
            ++n2;
        }
        this.m_table.getColumn(0).pack();
        this.m_table.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                TimeChooser.this.fireChangedEvent();
            }
        });
        this.setTime(new Date());
    }

    protected int getTableHeight() {
        return 200;
    }

    protected int getTableCellHeight() {
        return -1;
    }

    public void addChangeListener(ChangeListener listener) {
        this.m_listenerList.add(ChangeListener.class, (EventListener)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.m_listenerList.remove(ChangeListener.class, (EventListener)listener);
    }

    public void doChanged() {
        this.fireChangedEvent();
    }

    private void fireChangedEvent() {
        EventListener[] a = this.m_listenerList.getListeners(ChangeListener.class);
        if (a != null && a.length > 0) {
            ChangeEvent e = new ChangeEvent(this);
            int i = 0;
            while (i < a.length) {
                ((ChangeListener)a[i]).stateChanged(e);
                ++i;
            }
        }
    }

    public Date getTime() {
        TableItem selection;
        int row = this.m_table.getSelectionIndex();
        TableItem tableItem = selection = row >= 0 ? this.m_table.getSelection()[0] : null;
        if (selection instanceof TableItem) {
            return (Date)selection.getData();
        }
        return null;
    }

    public void setTime(Date value) {
        if (value == null) {
            value = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        int row = (cal.get(11) * 60 + cal.get(12)) / 30;
        this.m_table.setSelection(row);
        this.m_table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TimeChooser.this.m_table == null || TimeChooser.this.m_table.isDisposed()) {
                    return;
                }
                TimeChooser.this.m_table.showSelection();
            }
        });
    }

    public Double getTimeAsDouble() {
        Date t = this.getTime();
        if (t == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getTime());
        return 1.0 * (double)(cal.get(11) * 60 + cal.get(12)) / 1440.0;
    }

    public void setTimeAsAsDouble(Double d) {
        if (d == null) {
            this.setTime(null);
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.add(12, (int)(d * 24.0 * 60.0 + 0.5));
        this.setTime(cal.getTime());
    }

    protected Date[] createTableData() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        Date[] data = new Date[48];
        int i = 0;
        while (i < data.length) {
            data[i] = cal.getTime();
            cal.add(12, 30);
            ++i;
        }
        return data;
    }
}

