/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.sequencebox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutFormField;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.rap.form.fields.checkbox.IRwtScoutCheckbox;
import org.eclipse.scout.rt.ui.rap.form.fields.sequencebox.IRwtScoutSequenceBox;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutSequenceBox
extends RwtScoutFieldComposite<ISequenceBox>
implements IRwtScoutSequenceBox {
    private PropertyChangeListener m_scoutMandatoryChangeListener;
    private PropertyChangeListener m_scoutErrorStatusChangeListener;

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        Composite fieldContainer = this.getUiEnvironment().getFormToolkit().createComposite(container);
        int visibleCount = 0;
        for (IFormField scoutField : this.getScoutObject().getFields()) {
            IRwtScoutFormField childFormField = this.getUiEnvironment().createFormField(fieldContainer, scoutField);
            ILabelComposite childLabel = null;
            childLabel = childFormField instanceof IRwtScoutCheckbox ? ((IRwtScoutCheckbox)childFormField).getPlaceholderLabel() : childFormField.getUiLabel();
            if (childLabel != null && childLabel.getLayoutData() instanceof LogicalGridData) {
                ((LogicalGridData)childLabel.getLayoutData()).widthHint = 0;
                if (this.removeLabelCompletely(childFormField)) {
                    childLabel.setVisible(false);
                }
                if (childFormField.getScoutObject() instanceof IFormField) {
                    IFormField childScoutField = (IFormField)childFormField.getScoutObject();
                    if (childScoutField.isVisible()) {
                        ++visibleCount;
                    }
                    if (visibleCount > 1 && !childLabel.getVisible()) {
                        childLabel.setVisible(true);
                        childLabel.setText("");
                    }
                }
            }
            RwtScoutFormFieldGridData data = new RwtScoutFormFieldGridData(scoutField){

                @Override
                public void validate() {
                    super.validate();
                    this.useUiWidth = !RwtScoutSequenceBox.this.getScoutObject().isEqualColumnWidths();
                    this.useUiHeight = true;
                }
            };
            childFormField.getUiContainer().setLayoutData((Object)data);
        }
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setUiField((Control)fieldContainer);
        fieldContainer.setLayout((Layout)new LogicalGridLayout(this.getGridColumnGapInPixel(), 0));
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        this.setChildMandatoryFromScout();
    }

    protected int getGridColumnGapInPixel() {
        return 6;
    }

    private boolean removeLabelCompletely(IRwtScoutFormField rwtScoutFormField) {
        if (rwtScoutFormField == null) {
            return false;
        }
        if (!(rwtScoutFormField.getScoutObject() instanceof IFormField)) {
            return false;
        }
        IFormField formField = (IFormField)rwtScoutFormField.getScoutObject();
        return formField instanceof IBooleanField;
    }

    public Composite getUiField() {
        return (Composite)super.getUiField();
    }

    @Override
    public ISequenceBox getScoutObject() {
        return (ISequenceBox)super.getScoutObject();
    }

    protected void setChildMandatoryFromScout() {
        boolean inheritedMandatory = false;
        List<IValueField<?>> visibleFields = this.findVisibleValueFields((ICompositeField)this.getScoutObject());
        for (IValueField<?> field : visibleFields) {
            if (!field.isMandatory()) continue;
            inheritedMandatory = true;
            break;
        }
        this.setMandatoryFromScout(inheritedMandatory);
    }

    protected void setChildErrorStatusFromScout() {
        IProcessingStatus inheritedErrorStatus = null;
        List<IValueField<?>> visibleFields = this.findVisibleValueFields((ICompositeField)this.getScoutObject());
        if (visibleFields.size() > 0) {
            inheritedErrorStatus = visibleFields.get(0).getErrorStatus();
        }
        this.setErrorStatusFromScout(inheritedErrorStatus);
    }

    protected List<IValueField<?>> findVisibleValueFields(ICompositeField parent) {
        LinkedList valueFields = new LinkedList();
        for (IFormField field : parent.getFields()) {
            if (!field.isVisible()) continue;
            if (field instanceof IValueField) {
                valueFields.add((IValueField)field);
                continue;
            }
            if (!(field instanceof ICompositeField)) continue;
            valueFields.addAll(this.findVisibleValueFields((ICompositeField)field));
        }
        return valueFields;
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        if (this.getUiLabel() != null && this.getUiLabel().getEnabled() != b) {
            this.getUiLabel().setEnabled(b);
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.m_scoutMandatoryChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        if (RwtScoutSequenceBox.this.getUiContainer() != null && !RwtScoutSequenceBox.this.getUiContainer().isDisposed()) {
                            RwtScoutSequenceBox.this.setChildMandatoryFromScout();
                        }
                    }
                };
                RwtScoutSequenceBox.this.getUiEnvironment().invokeUiLater(j);
            }
        };
        for (IFormField f : this.getScoutObject().getFields()) {
            f.addPropertyChangeListener("mandatory", this.m_scoutMandatoryChangeListener);
        }
        this.m_scoutErrorStatusChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutSequenceBox.this.setChildErrorStatusFromScout();
                    }
                };
                RwtScoutSequenceBox.this.getUiEnvironment().invokeUiLater(j);
            }
        };
        for (IFormField f : this.getScoutObject().getFields()) {
            f.addPropertyChangeListener("errorStatus", this.m_scoutErrorStatusChangeListener);
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_scoutMandatoryChangeListener != null) {
            for (IFormField f : this.getScoutObject().getFields()) {
                f.removePropertyChangeListener("mandatory", this.m_scoutMandatoryChangeListener);
            }
            this.m_scoutMandatoryChangeListener = null;
        }
        if (this.m_scoutErrorStatusChangeListener != null) {
            for (IFormField f : this.getScoutObject().getFields()) {
                f.removePropertyChangeListener("errorStatus", this.m_scoutErrorStatusChangeListener);
            }
            this.m_scoutErrorStatusChangeListener = null;
        }
        super.detachScout();
    }

    @Override
    protected void updateKeyStrokesFromScout() {
    }
}

