/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.stringfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.rap.action.menu.RwtScoutContextMenu;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.StyledTextEx;
import org.eclipse.scout.rt.ui.rap.ext.custom.StyledText;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.AbstractRwtScoutDndSupport;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutBasicFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.stringfield.IRwtScoutStringField;
import org.eclipse.scout.rt.ui.rap.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class RwtScoutStringField
extends RwtScoutBasicFieldComposite<IStringField>
implements IRwtScoutStringField {
    public static final int DEFAULT_CASE = 0;
    public static final int UPPER_CASE = 1;
    public static final int LOWER_CASE = 2;
    private int m_characterType = -1;
    private MouseListener m_linkTrigger;
    private boolean m_linkDecoration;
    private TextFieldEditableSupport m_editableSupport;
    private P_UpperLowerCaseVerifyListener m_upperLowerCaseVerifyListener;
    private RwtContextMenuMarkerComposite m_menuMarkerComposite;
    private RwtScoutContextMenu m_uiContextMenu;
    private P_ContextMenuPropertyListener m_contextMenuPropertyListener;

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        this.m_menuMarkerComposite = new RwtContextMenuMarkerComposite(container, this.getUiEnvironment());
        this.getUiEnvironment().getFormToolkit().adapt(this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.setData("org.eclipse.rap.rwt.customVariant", "inputField");
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                if (RwtScoutStringField.this.getUiContextMenu() != null) {
                    Menu uiMenu = RwtScoutStringField.this.getUiContextMenu().getUiMenu();
                    if (e.widget instanceof Control) {
                        Point loc = ((Control)e.widget).toDisplay(e.x, e.y);
                        uiMenu.setLocation(RwtMenuUtility.getMenuLocation(((IStringField)RwtScoutStringField.this.getScoutObject()).getContextMenu().getChildActions(), uiMenu, loc, RwtScoutStringField.this.getUiEnvironment()));
                    }
                    uiMenu.setVisible(true);
                }
            }
        });
        int style = 0;
        if (((IStringField)this.getScoutObject()).isInputMasked()) {
            style |= 0x400000;
        }
        style = ((IStringField)this.getScoutObject()).isMultilineText() ? (style |= 0x202) : (style |= 4);
        if (((IStringField)this.getScoutObject()).isWrapText()) {
            style |= 0x40;
        }
        StyledText textField = this.getUiEnvironment().getFormToolkit().createStyledText(this.m_menuMarkerComposite, style |= RwtUtility.getHorizontalAlignment(((IStringField)this.getScoutObject()).getGridData().horizontalAlignment));
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setUiField((Control)textField);
        this.addDefaultUiListeners(textField);
        LogicalGridLayout layout = new LogicalGridLayout(1, 0);
        this.getUiContainer().setLayout((Layout)layout);
        this.m_menuMarkerComposite.setLayoutData(LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
    }

    protected void addDefaultUiListeners(StyledText textField) {
        textField.addSelectionListener((SelectionListener)new P_RwtTextSelectionListener());
        this.attachFocusListener((Control)textField, true);
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IStringField f = (IStringField)this.getScoutObject();
        this.setDecorationLinkFromScout(f.isDecorationLink());
        this.setFormatFromScout(f.getFormat());
        this.setMaxLengthFromScout(f.getMaxLength());
        this.setSelectionFromScout(f.getSelectionStart(), f.getSelectionEnd());
        this.setTextWrapFromScout(f.isWrapText());
        this.attachDndSupport();
        this.updateContextMenuVisibilityFromScout();
        if (((IStringField)this.getScoutObject()).getContextMenu() != null && this.m_contextMenuPropertyListener == null) {
            this.m_contextMenuPropertyListener = new P_ContextMenuPropertyListener();
            ((IStringField)this.getScoutObject()).getContextMenu().addPropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
        }
    }

    protected void attachDndSupport() {
        if (UiDecorationExtensionPoint.getLookAndFeel().isDndSupportEnabled()) {
            new P_DndSupport((IPropertyObserver)this.getScoutObject(), (IDNDSupport)this.getScoutObject(), (Control)this.getUiField());
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_contextMenuPropertyListener != null) {
            ((IStringField)this.getScoutObject()).getContextMenu().removePropertyChangeListener("visible", (PropertyChangeListener)this.m_contextMenuPropertyListener);
            this.m_contextMenuPropertyListener = null;
        }
        super.detachScout();
    }

    @Override
    public StyledTextEx getUiField() {
        return (StyledTextEx)super.getUiField();
    }

    public RwtScoutContextMenu getUiContextMenu() {
        return this.m_uiContextMenu;
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        if (b) {
            this.m_menuMarkerComposite.setData("org.eclipse.rap.rwt.customVariant", "inputField");
        } else {
            this.m_menuMarkerComposite.setData("org.eclipse.rap.rwt.customVariant", "inputField-readOnly");
        }
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getUiField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    @Override
    protected IRwtKeyStroke[] getUiKeyStrokes() {
        if (((IStringField)this.getScoutObject()).isMultilineText()) {
            return new IRwtKeyStroke[]{new RwtKeyStroke(13, 0, false){

                @Override
                public void handleUiAction(Event e) {
                    e.doit = false;
                }
            }};
        }
        return super.getUiKeyStrokes();
    }

    protected void setDecorationLinkFromScout(boolean b) {
        if (this.m_linkDecoration != b) {
            this.m_linkDecoration = b;
            if (this.m_linkDecoration) {
                this.m_linkTrigger = new P_RwtLinkTrigger();
                this.getUiField().addMouseListener(this.m_linkTrigger);
                this.getUiField().setCursor(this.getUiField().getDisplay().getSystemCursor(21));
                this.setForegroundFromScout(((IStringField)this.getScoutObject()).getForegroundColor());
            } else {
                this.getUiField().removeMouseListener(this.m_linkTrigger);
                this.m_linkTrigger = null;
                this.getUiField().setCursor(null);
                this.setForegroundFromScout(((IStringField)this.getScoutObject()).getForegroundColor());
            }
        }
    }

    @Override
    protected void setForegroundFromScout(String scoutColor) {
        if (scoutColor == null && this.m_linkDecoration) {
            scoutColor = "0000FF";
        }
        super.setForegroundFromScout(scoutColor);
    }

    protected void setFormatFromScout(String s) {
        if ("A".equals(s)) {
            this.m_characterType = 1;
            this.addUpperLowerCaseVerifyListener();
        } else if ("a".equals(s)) {
            this.m_characterType = 2;
            this.addUpperLowerCaseVerifyListener();
        } else {
            this.m_characterType = 0;
            this.removeUpperLowerCaseVerifyListener();
        }
    }

    protected void addUpperLowerCaseVerifyListener() {
        if (this.m_upperLowerCaseVerifyListener == null) {
            this.m_upperLowerCaseVerifyListener = new P_UpperLowerCaseVerifyListener();
            this.getUiField().addVerifyListener(this.m_upperLowerCaseVerifyListener);
        }
    }

    protected void removeUpperLowerCaseVerifyListener() {
        if (this.m_upperLowerCaseVerifyListener != null) {
            this.getUiField().removeVerifyListener(this.m_upperLowerCaseVerifyListener);
            this.m_upperLowerCaseVerifyListener = null;
        }
    }

    protected void setMaxLengthFromScout(int n) {
        this.getUiField().setTextLimit(n);
    }

    protected void setDoInsertFromScout(String s) {
        if (s != null && s.length() > 0) {
            StyledTextEx field = this.getUiField();
            int offset = field.getCaretPosition();
            int a = field.getSelection().x;
            int b = field.getSelection().y;
            String uiText = field.getText();
            StringBuilder builder = new StringBuilder(uiText);
            if (a >= 0 && b > a) {
                builder.replace(a, b, s);
            } else if (offset >= 0) {
                builder.insert(offset, s);
            } else {
                builder = null;
            }
            if (builder != null) {
                field.setText(builder.toString());
            }
            field.setSelection(a + s.length());
        }
    }

    protected void setSelectionFromScout(int startIndex, int endIndex) {
        StyledTextEx field = this.getUiField();
        int start = field.getSelection().x;
        int end = field.getSelection().y;
        if (startIndex < 0) {
            startIndex = start;
        }
        if (endIndex < 0) {
            endIndex = end;
        }
        field.setSelection(startIndex, endIndex);
    }

    protected void setTextWrapFromScout(boolean booleanValue) {
        ((IStringField)this.getScoutObject()).isMultilineText();
    }

    protected void updateContextMenuVisibilityFromScout() {
        this.m_menuMarkerComposite.setMarkerVisible(((IStringField)this.getScoutObject()).getContextMenu().isVisible());
        if (((IStringField)this.getScoutObject()).getContextMenu().isVisible()) {
            if (this.m_uiContextMenu == null) {
                this.m_uiContextMenu = new RwtScoutContextMenu(this.getUiField().getShell(), (IContextMenu)((IStringField)this.getScoutObject()).getContextMenu(), this.getUiEnvironment());
            }
        } else {
            if (this.m_uiContextMenu != null) {
                this.m_uiContextMenu.dispose();
            }
            this.m_uiContextMenu = null;
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("decorationLink")) {
            this.setDecorationLinkFromScout((Boolean)newValue);
        } else if (name.equals("maxLength")) {
            this.setMaxLengthFromScout(((Number)newValue).intValue());
        } else if (name.equals("insertText")) {
            this.setDoInsertFromScout((String)newValue);
        } else if (name.equals("selectionStart")) {
            IStringField f = (IStringField)this.getScoutObject();
            this.setSelectionFromScout(f.getSelectionStart(), f.getSelectionEnd());
        } else if (name.equals("selectionEnd")) {
            IStringField f = (IStringField)this.getScoutObject();
            this.setSelectionFromScout(f.getSelectionStart(), f.getSelectionEnd());
        } else if (name.equals("wrapText")) {
            this.setTextWrapFromScout((Boolean)newValue);
        }
    }

    protected void handleUiLinkTrigger() {
        final String text = this.getUiField().getText();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IStringField)RwtScoutStringField.this.getScoutObject()).getUIFacade().fireLinkActionFromUI(text);
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    protected void setSelectionFromUi(final int startIndex, final int endIndex) {
        if (this.getUpdateUiFromScoutLock().isAcquired()) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    RwtScoutStringField.this.addIgnoredScoutEvent(PropertyChangeEvent.class, "selectionStart");
                    RwtScoutStringField.this.addIgnoredScoutEvent(PropertyChangeEvent.class, "selectionEnd");
                    ((IStringField)RwtScoutStringField.this.getScoutObject()).getUIFacade().setSelectionFromUI(startIndex, endIndex);
                }
                finally {
                    RwtScoutStringField.this.removeIgnoredScoutEvent(PropertyChangeEvent.class, "selectionStart");
                    RwtScoutStringField.this.removeIgnoredScoutEvent(PropertyChangeEvent.class, "selectionEnd");
                }
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    @Override
    protected boolean isSelectAllOnFocusEnabled() {
        return super.isSelectAllOnFocusEnabled() && ((IStringField)this.getScoutObject()).isSelectAllOnFocus();
    }

    private class P_ContextMenuPropertyListener
    implements PropertyChangeListener {
        private P_ContextMenuPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName())) {
                RwtScoutStringField.this.getUiEnvironment().invokeUiLater(new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutStringField.this.updateContextMenuVisibilityFromScout();
                    }
                });
            }
        }
    }

    private class P_DndSupport
    extends AbstractRwtScoutDndSupport {
        public P_DndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control) {
            super(scoutObject, scoutDndSupportable, control, RwtScoutStringField.this.getUiEnvironment());
        }

        @Override
        protected TransferObject handleUiDragRequest() {
            final Holder result = new Holder(TransferObject.class, null);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((IStringField)RwtScoutStringField.this.getScoutObject()).getUIFacade().fireDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            JobEx job = this.getUiEnvironment().invokeScoutLater(t, 2345L);
            try {
                job.join(2345L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return (TransferObject)result.getValue();
        }

        @Override
        protected void handleUiDropAction(DropTargetEvent event, final TransferObject scoutTransferObject) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    if (((IStringField)RwtScoutStringField.this.getScoutObject()).isEnabled()) {
                        ((IStringField)RwtScoutStringField.this.getScoutObject()).getUIFacade().fireDropActionFromUi(scoutTransferObject);
                    }
                }
            };
            this.getUiEnvironment().invokeScoutLater(job, 200L);
        }
    }

    private class P_RwtLinkTrigger
    extends MouseAdapter {
        private static final long serialVersionUID = 1L;

        private P_RwtLinkTrigger() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            RwtScoutStringField.this.handleUiLinkTrigger();
        }
    }

    private class P_RwtTextSelectionListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;

        private P_RwtTextSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            RwtScoutStringField.this.setSelectionFromUi(e.x, e.y);
        }
    }

    private class P_UpperLowerCaseVerifyListener
    implements VerifyListener {
        private static final long serialVersionUID = 1L;

        private P_UpperLowerCaseVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            switch (RwtScoutStringField.this.m_characterType) {
                case 1: {
                    e.text = e.text.toUpperCase();
                    break;
                }
                case 2: {
                    e.text = e.text.toLowerCase();
                }
            }
        }
    }
}

