/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.radiobuttongroup;

import java.util.ArrayList;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.ButtonEx;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutFormField;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.radiobuttongroup.IRwtScoutRadioButtonGroup;
import org.eclipse.scout.rt.ui.rap.form.radiobuttongroup.layout.RadioButtonGroupLayout;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutRadioButtonGroup
extends RwtScoutValueFieldComposite<IRadioButtonGroup<?>>
implements IRwtScoutRadioButtonGroup {
    private ArrayList<Button> m_uiRadioButtons = new ArrayList();

    @Override
    protected void initializeUi(Composite parent) {
        boolean usesLogicalGrid;
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        Composite buttonArea = this.getUiEnvironment().getFormToolkit().createComposite(container);
        this.getUiEnvironment().getFormToolkit().adapt(buttonArea);
        for (IFormField scoutField : ((IRadioButtonGroup)this.getScoutObject()).getFields()) {
            IRwtScoutFormField uiField = this.getUiEnvironment().createFormField(buttonArea, scoutField);
            if (!(uiField.getUiField() instanceof Button)) continue;
            Button uiButton = (Button)uiField.getUiField();
            this.getUiEnvironment().addKeyStroke((Control)uiButton, new P_KeyStroke(0x1000002), false);
            this.getUiEnvironment().addKeyStroke((Control)uiButton, new P_KeyStroke(0x1000004), false);
            this.getUiEnvironment().addKeyStroke((Control)uiButton, new P_KeyStroke(0x1000001), false);
            this.getUiEnvironment().addKeyStroke((Control)uiButton, new P_KeyStroke(0x1000003), false);
            this.getUiEnvironment().addKeyStroke((Control)uiButton, new P_KeyStroke(0x1000007), false);
            this.getUiEnvironment().addKeyStroke((Control)uiButton, new P_KeyStroke(0x1000008), false);
            this.m_uiRadioButtons.add(uiButton);
        }
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setUiField((Control)buttonArea);
        this.getUiContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
        GridData scoutGridData = ((IRadioButtonGroup)this.getScoutObject()).getGridData();
        boolean bl = usesLogicalGrid = ((IRadioButtonGroup)this.getScoutObject()).getGridRowCount() == scoutGridData.h && !scoutGridData.useUiHeight;
        if (usesLogicalGrid) {
            IUiDecoration deco = UiDecorationExtensionPoint.getLookAndFeel();
            this.getUiField().setLayout((Layout)new RadioButtonGroupLayout((IRadioButtonGroup)this.getScoutObject(), deco.getLogicalGridLayoutHorizontalGap(), deco.getLogicalGridLayoutVerticalGap()));
        } else {
            this.getUiField().setLayout((Layout)new RadioButtonGroupLayout((IRadioButtonGroup)this.getScoutObject(), 0, 4));
        }
    }

    public Composite getUiField() {
        return (Composite)super.getUiField();
    }

    private class P_KeyStroke
    extends RwtKeyStroke {
        public P_KeyStroke(int keyCode) {
            super(keyCode);
        }

        @Override
        public void handleUiAction(Event e) {
            if (e.widget instanceof Button) {
                this.handleKeyEvent(e);
            }
        }

        public void handleKeyEvent(Event e) {
            int index = RwtScoutRadioButtonGroup.this.m_uiRadioButtons.indexOf(e.widget);
            if (index < 0) {
                return;
            }
            switch (e.keyCode) {
                case 0x1000002: 
                case 0x1000004: {
                    this.selectNextPossibleRadioButton(index, e);
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    this.selectPreviousPossibleRadioButton(index, e);
                    break;
                }
                case 0x1000007: {
                    this.selectFirstPossibleRadioButton(index, e);
                    break;
                }
                case 0x1000008: {
                    this.selectLastPossibleRadioButton(index, e);
                }
            }
            e.doit = false;
        }

        protected void selectNextPossibleRadioButton(int currentIndex, Event e) {
            Button oldButton = (Button)RwtScoutRadioButtonGroup.this.m_uiRadioButtons.get(currentIndex);
            int i = 1;
            while (i < RwtScoutRadioButtonGroup.this.m_uiRadioButtons.size()) {
                int nextIndex = (currentIndex + i) % RwtScoutRadioButtonGroup.this.m_uiRadioButtons.size();
                Button newButton = (Button)RwtScoutRadioButtonGroup.this.m_uiRadioButtons.get(nextIndex);
                if (newButton.setFocus()) {
                    this.selectButton(newButton, oldButton, e);
                    return;
                }
                ++i;
            }
        }

        protected void selectPreviousPossibleRadioButton(int currentIndex, Event e) {
            Button oldButton = (Button)RwtScoutRadioButtonGroup.this.m_uiRadioButtons.get(currentIndex);
            int i = 1;
            while (i < RwtScoutRadioButtonGroup.this.m_uiRadioButtons.size()) {
                Button newButton;
                int nextIndex = (currentIndex - i) % RwtScoutRadioButtonGroup.this.m_uiRadioButtons.size();
                if (nextIndex < 0) {
                    nextIndex += RwtScoutRadioButtonGroup.this.m_uiRadioButtons.size();
                }
                if ((newButton = (Button)RwtScoutRadioButtonGroup.this.m_uiRadioButtons.get(nextIndex)).setFocus()) {
                    this.selectButton(newButton, oldButton, e);
                    return;
                }
                ++i;
            }
        }

        protected void selectLastPossibleRadioButton(int currentIndex, Event e) {
            Button oldButton = (Button)RwtScoutRadioButtonGroup.this.m_uiRadioButtons.get(currentIndex);
            int i = RwtScoutRadioButtonGroup.this.m_uiRadioButtons.size() - 1;
            while (i >= 0) {
                Button newButton = (Button)RwtScoutRadioButtonGroup.this.m_uiRadioButtons.get(i);
                if (newButton.setFocus()) {
                    this.selectButton(newButton, oldButton, e);
                    return;
                }
                --i;
            }
        }

        protected void selectFirstPossibleRadioButton(int currentIndex, Event e) {
            Button oldButton = (Button)RwtScoutRadioButtonGroup.this.m_uiRadioButtons.get(currentIndex);
            for (Button newButton : RwtScoutRadioButtonGroup.this.m_uiRadioButtons) {
                if (!newButton.setFocus()) continue;
                this.selectButton(newButton, oldButton, e);
                return;
            }
        }

        private void selectButton(Button newButton, Button oldButton, Event e) {
            oldButton.setSelection(false);
            newButton.setSelection(true);
            if (newButton instanceof ButtonEx) {
                ((ButtonEx)newButton).handleButtonSelectionFromKeyStroke(e);
            }
        }
    }
}

