/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.servletfilter;

import javax.servlet.http.HttpServletResponse;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.service.ContextProvider;

public class LogoutHandler {
    private String m_redirectUrl = this.computeRedirectUrl();

    public void logout() {
        HttpServletResponse response = RWT.getResponse();
        String logoutUrl = response.encodeRedirectURL(this.getLogoutLocation());
        ContextProvider.getProtocolWriter().appendHead("redirect", logoutUrl);
    }

    protected String getLogoutLocation() {
        String path = RWT.getRequest().getServletPath();
        if (path.length() > 0 && '/' == path.charAt(0)) {
            path = path.substring(1);
        }
        path = String.valueOf(path) + "?doLogout";
        String redirectUrl = this.getRedirectUrl();
        if (redirectUrl != null) {
            path = String.valueOf(path) + "&redirectUrl=" + redirectUrl;
        }
        return path;
    }

    protected String computeRedirectUrl() {
        String currentServletName = RWT.getRequest().getServletPath();
        if (currentServletName.length() > 0 && '/' == currentServletName.charAt(0)) {
            currentServletName = currentServletName.substring(1);
        }
        return currentServletName;
    }

    public String getRedirectUrl() {
        return this.m_redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.m_redirectUrl = redirectUrl;
    }
}

