/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.testing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.widgets.Widget;

public class CustomWidgetIdGenerator {
    private Map<String, Integer> m_existingIds = new HashMap<String, Integer>();

    public static CustomWidgetIdGenerator getInstance() {
        return (CustomWidgetIdGenerator)SingletonUtil.getSessionInstance(CustomWidgetIdGenerator.class);
    }

    private CustomWidgetIdGenerator() {
    }

    public void setCustomWidgetIds(Widget widget, IPropertyObserver scoutObject, String prefix) {
        int childIndex = 0;
        List<Widget> children = RwtUtility.findChildComponents(widget, Widget.class);
        String customWidgetId = this.newId(widget, scoutObject, prefix);
        for (Widget childWidget : children) {
            if (childWidget.getData("org.eclipse.rap.rwt.customWidgetId") != null) continue;
            childWidget.setData("org.eclipse.rap.rwt.customWidgetId", (Object)this.newChildId(customWidgetId, childIndex));
            ++childIndex;
        }
    }

    private String newChildId(String parentId, int childIndex) {
        return String.valueOf(parentId) + "_c" + childIndex;
    }

    public String newId(Widget widget, IPropertyObserver scoutObject, String prefix) {
        String scoutObjectId = this.createScoutObjectId(scoutObject, widget);
        String id = String.valueOf(prefix) + "_" + scoutObjectId;
        Integer useCount = this.m_existingIds.get(id = id.replace('$', '.'));
        useCount = useCount != null ? Integer.valueOf(useCount + 1) : Integer.valueOf(1);
        this.m_existingIds.put(id, useCount);
        id = String.valueOf(id) + "_" + (useCount - 1);
        return id;
    }

    private String createScoutObjectId(IPropertyObserver scoutObject, Widget widget) {
        String scoutObjectId = "";
        scoutObjectId = scoutObject instanceof IFormField ? this.createFormFieldId((IFormField)scoutObject) : scoutObject.getClass().getName();
        return scoutObjectId;
    }

    private String createFormFieldId(IFormField formField) {
        IFormField topField;
        String scoutObjectId = "";
        List enclosingFieldList = formField.getEnclosingFieldList();
        if (enclosingFieldList != null && enclosingFieldList.size() > 0) {
            for (ICompositeField parentField : enclosingFieldList) {
                scoutObjectId = String.valueOf(parentField.getFieldId()) + "." + scoutObjectId;
            }
            topField = (IFormField)enclosingFieldList.get(enclosingFieldList.size() - 1);
        } else {
            topField = formField;
            scoutObjectId = formField.getFieldId();
        }
        if (topField.getForm() != null) {
            scoutObjectId = String.valueOf(topField.getForm().getFormId()) + "." + scoutObjectId;
        }
        scoutObjectId = String.valueOf(topField.getClass().getPackage().getName()) + "." + scoutObjectId;
        return scoutObjectId;
    }
}

