/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.util;

import java.util.Enumeration;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.rap.util.BrowserInfo;
import org.osgi.framework.Version;

public class BrowserInfoBuilder {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BrowserInfoBuilder.class);

    public BrowserInfo createBrowserInfo(HttpServletRequest request) {
        if (LOG.isInfoEnabled()) {
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String header = request.getHeader(headerName);
                headerName = String.valueOf(headerName) + (headerName.length() <= 11 ? "\t\t" : "\t");
                LOG.info(String.valueOf(headerName) + header);
            }
        }
        String userAgent = request.getHeader("User-Agent");
        BrowserInfo info = this.createBrowserInfo(userAgent, request.getLocale());
        if (LOG.isInfoEnabled()) {
            LOG.info(info.toString());
        }
        return info;
    }

    public BrowserInfo createBrowserInfo(String userAgent, Locale locale) {
        BrowserInfo info = this.createBrowserInfo(userAgent);
        info.setUserAgent(userAgent);
        info.setLocale(locale);
        if (userAgent.indexOf("Windows") != -1 || userAgent.indexOf("Win32") != -1 || userAgent.indexOf("Win64") != -1) {
            info.setSystem(BrowserInfo.System.WINDOWS);
            if (userAgent.indexOf("Windows Phone") != -1 || userAgent.indexOf("IEMobile") != -1) {
                info.setSystemVersion(this.parseWindowsPhoneVersion(userAgent));
                info.setMobile(true);
            } else {
                info.setSystemVersion(this.parseWindowsVersion(userAgent));
            }
        } else if (userAgent.indexOf("Macintosh") != -1 || userAgent.indexOf("MacPPC") != -1 || userAgent.indexOf("MacIntel") != -1) {
            info.setSystem(BrowserInfo.System.OSX);
        } else if (userAgent.indexOf("Android") != -1) {
            info.setSystem(BrowserInfo.System.ANDROID);
            info.setSystemVersion(this.parseAndroidVersion(userAgent));
            this.initAndroidMobileFlags(info);
        } else if (userAgent.indexOf("X11") != -1 || userAgent.indexOf("Linux") != -1 || userAgent.indexOf("BSD") != -1) {
            info.setSystem(BrowserInfo.System.UNIX);
        } else if (userAgent.indexOf("iPad") != -1) {
            info.setSystem(BrowserInfo.System.IOS);
            info.setSystemVersion(this.parseIosVersion(userAgent));
            info.setTablet(true);
        } else if (userAgent.indexOf("iPhone") != -1 || userAgent.indexOf("iPod") != -1) {
            info.setSystem(BrowserInfo.System.IOS);
            info.setSystemVersion(this.parseIosVersion(userAgent));
            info.setMobile(true);
        } else {
            info.setSystem(BrowserInfo.System.UNKNOWN);
        }
        return info;
    }

    private void initAndroidMobileFlags(BrowserInfo info) {
        if (info.getSystemVersion() == null) {
            info.setMobile(true);
            return;
        }
        if (info.getSystemVersion().getMajor() <= 2) {
            info.setMobile(true);
        } else if (info.getSystemVersion().getMajor() == 3) {
            info.setTablet(true);
        } else if (info.getUserAgent().indexOf("Mobile") != -1) {
            info.setMobile(true);
        } else {
            info.setTablet(true);
        }
    }

    private BrowserInfo createBrowserInfo(String userAgent) {
        boolean isGecko;
        boolean isWebkit;
        BrowserInfo info = null;
        Version v = null;
        String regex = "Opera[\\s\\/]([0-9\\.]*)";
        boolean isOpera = StringUtility.contains((String)userAgent, (String)regex);
        if (isOpera) {
            v = this.parseBrowserVersion(userAgent, regex);
            info = new BrowserInfo(BrowserInfo.Type.OPERA, v);
            info.setOpera(isOpera);
            return info;
        }
        regex = "KHTML\\/([0-9-\\.]*)";
        boolean isKonqueror = StringUtility.contains((String)userAgent, (String)regex);
        if (isKonqueror) {
            v = this.parseBrowserVersion(userAgent, regex);
            info = new BrowserInfo(BrowserInfo.Type.KONQUEROR, null);
            info.setWebkit(isKonqueror);
            return info;
        }
        regex = "AppleWebKit\\/([^ ]+)";
        boolean bl = isWebkit = userAgent.indexOf("AppleWebKit") != -1 && StringUtility.contains((String)userAgent, (String)regex);
        if (isWebkit) {
            v = this.parseBrowserVersion(userAgent, regex);
            if (userAgent.indexOf("Chrome") != -1) {
                info = new BrowserInfo(BrowserInfo.Type.GOOGLE_CHROME, v);
            } else if (userAgent.indexOf("Safari") != -1) {
                info = userAgent.indexOf("Android") != -1 ? new BrowserInfo(BrowserInfo.Type.ANDROID, v) : new BrowserInfo(BrowserInfo.Type.APPLE_SAFARI, v);
            } else if (userAgent.indexOf("OmniWeb") != -1) {
                info = new BrowserInfo(BrowserInfo.Type.OMNI_WEB, v);
            } else if (userAgent.indexOf("Shiira") != -1) {
                info = new BrowserInfo(BrowserInfo.Type.SHIRA, v);
            } else if (userAgent.indexOf("NetNewsWire") != -1) {
                info = new BrowserInfo(BrowserInfo.Type.BLACKPIXEL_NETNEWSWIRE, v);
            } else if (userAgent.indexOf("RealPlayer") != -1) {
                info = new BrowserInfo(BrowserInfo.Type.REALNETWORKS_REALPLAYER, v);
            } else if (userAgent.indexOf("Mobile") != -1) {
                info = new BrowserInfo(BrowserInfo.Type.APPLE_SAFARI, v);
                info.setStandalone(true);
            } else {
                info = new BrowserInfo(BrowserInfo.Type.UNKNOWN, null);
            }
            info.setWebkit(isWebkit);
            return info;
        }
        regex = "rv\\:([^\\);]+)(\\)|;)";
        boolean bl2 = isGecko = userAgent.indexOf("Gecko") != -1 && StringUtility.contains((String)userAgent, (String)regex);
        if (isGecko) {
            v = this.parseBrowserVersion(userAgent, regex);
            info = userAgent.indexOf("Firefox") != -1 ? new BrowserInfo(BrowserInfo.Type.MOZILLA_FIREFOX, v) : (userAgent.indexOf("Camino") != -1 ? new BrowserInfo(BrowserInfo.Type.MOZILLA_CAMINO, v) : (userAgent.indexOf("Galeon") != -1 ? new BrowserInfo(BrowserInfo.Type.GNOME_GALOEN, v) : new BrowserInfo(BrowserInfo.Type.UNKNOWN, null)));
            info.setGecko(isGecko);
            return info;
        }
        regex = "MSIE\\s+([^\\);]+)(\\)|;)";
        boolean isMshtml = StringUtility.contains((String)userAgent, (String)regex);
        if (isMshtml) {
            v = this.parseBrowserVersion(userAgent, regex);
            info = userAgent.indexOf("MSIE") != -1 ? new BrowserInfo(BrowserInfo.Type.IE, v) : new BrowserInfo(BrowserInfo.Type.UNKNOWN, null);
            info.setMshtml(isMshtml);
            return info;
        }
        return new BrowserInfo(BrowserInfo.Type.UNKNOWN, null);
    }

    private Version parseBrowserVersion(String userAgent, String regex) {
        Matcher matcher = Pattern.compile(".*" + regex + ".*", 42).matcher(userAgent);
        if (matcher.matches()) {
            String s = matcher.group(1);
            return this.createVersion(s);
        }
        return null;
    }

    private Version parseSystemVersion(String userAgent, String regex, int group) {
        Matcher matcher = Pattern.compile(regex, 2).matcher(userAgent);
        if (matcher.find()) {
            String s = matcher.group(group);
            return this.createVersion(s);
        }
        return null;
    }

    private Version parseSystemVersion(String userAgent, String regex) {
        return this.parseSystemVersion(userAgent, regex, 1);
    }

    private Version parseAndroidVersion(String userAgent) {
        return this.parseSystemVersion(userAgent, "Android\\s([^\\s;]+)");
    }

    private Version parseIosVersion(String userAgent) {
        userAgent = userAgent.replace('_', '.');
        return this.parseSystemVersion(userAgent, "\\sOS\\s([^\\s;]+)");
    }

    private Version parseWindowsPhoneVersion(String userAgent) {
        return this.parseSystemVersion(userAgent, "Windows\\sPhone\\s(OS )?([^\\s;]+)", 2);
    }

    private Version parseWindowsVersion(String userAgent) {
        return this.parseSystemVersion(userAgent, "Windows\\sNT\\s([^\\s;]+)");
    }

    private Version createVersion(String versionString) {
        versionString = versionString.replaceAll("^[/\\s]*", "");
        int[] vArr = new int[3];
        Matcher m = Pattern.compile("([0-9]+)\\.([0-9]+)[\\.]?([0-9]*)").matcher(versionString);
        if (m.find()) {
            int i = 1;
            while (i <= 3) {
                String versionPart = m.group(i);
                if (StringUtility.hasText((String)versionPart)) {
                    vArr[i - 1] = Integer.valueOf(versionPart);
                }
                ++i;
            }
        }
        return new Version(vArr[0], vArr[1], vArr[2]);
    }
}

