/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.util;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.rap.basic.comp.CLabelEx;
import org.eclipse.scout.rt.ui.rap.basic.comp.HyperlinkEx;
import org.eclipse.scout.rt.ui.rap.ext.ButtonEx;
import org.eclipse.scout.rt.ui.rap.ext.DropDownButton;
import org.eclipse.scout.rt.ui.rap.ext.DropDownFileUpload;
import org.eclipse.scout.rt.ui.rap.ext.IconCssStyledButton;
import org.eclipse.scout.rt.ui.rap.ext.ImageViewer;
import org.eclipse.scout.rt.ui.rap.ext.ScrolledFormEx;
import org.eclipse.scout.rt.ui.rap.ext.SectionContent;
import org.eclipse.scout.rt.ui.rap.ext.SnapButtonMaximized;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelTop;
import org.eclipse.scout.rt.ui.rap.ext.StyledTextEx;
import org.eclipse.scout.rt.ui.rap.ext.TextEx;
import org.eclipse.scout.rt.ui.rap.ext.custom.StyledText;
import org.eclipse.scout.rt.ui.rap.ext.table.TableEx;
import org.eclipse.scout.rt.ui.rap.ext.tree.TreeEx;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.util.WrappedFormToolkit;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ScoutFormToolkit
extends WrappedFormToolkit {
    public ScoutFormToolkit(FormToolkit kit) {
        super(kit);
        kit.getColors().setForeground(null);
        kit.getColors().setBackground(null);
        this.initializeHyperlinkColors();
    }

    protected void initializeHyperlinkColors() {
        RGB linkButtonBlue = new RGB(103, 168, 206);
        JFaceResources.getColorRegistry().put("HYPERLINK_COLOR", linkButtonBlue);
        JFaceResources.getColorRegistry().put("ACTIVE_HYPERLINK_COLOR", linkButtonBlue);
        this.refreshHyperlinkColors();
    }

    public ScrolledFormEx createScrolledFormEx(Composite parent, int style) {
        ScrolledFormEx form = new ScrolledFormEx(parent, style);
        this.adapt((Control)form, false, false);
        if (form.getBody() != null) {
            this.adapt((Control)form.getBody(), false, false);
        }
        form.setBackground(this.kit.getColors().getBackground());
        form.setForeground(this.kit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return form;
    }

    @Override
    public ScrolledForm createScrolledForm(Composite parent) {
        ScrolledForm form = new ScrolledForm(parent, 0x240 | this.kit.getOrientation());
        this.adapt((Control)form, false, false);
        form.setBackground(this.kit.getColors().getBackground());
        form.setForeground(this.kit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        form.setFont(JFaceResources.getHeaderFont());
        return form;
    }

    @Override
    public TreeEx createTree(Composite parent, int style) {
        TreeEx tree = new TreeEx(parent, style);
        this.adapt((Control)tree, false, false);
        return tree;
    }

    @Override
    public TableEx createTable(Composite parent, int style) {
        TableEx table = new TableEx(parent, style);
        this.adapt((Control)table, false, false);
        return table;
    }

    public int computeSwtLabelHorizontalAlignment(int scoutAlign) {
        switch (scoutAlign) {
            case -1: {
                return 16384;
            }
            case 0: {
                return 0x1000000;
            }
            case 1: {
                return 131072;
            }
        }
        return UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelAlignment();
    }

    protected int computeSwtLabelStyle(IFormField scoutObject) {
        if (scoutObject == null) {
            return 0;
        }
        return this.computeSwtLabelHorizontalAlignment(scoutObject.getLabelHorizontalAlignment());
    }

    public StatusLabelEx createStatusLabel(Composite parent, IFormField scoutObject) {
        int labelStyle = this.computeSwtLabelStyle(scoutObject);
        return this.createStatusLabel(parent, scoutObject, labelStyle);
    }

    public StatusLabelEx createStatusLabel(Composite parent, IFormField scoutObject, int style) {
        StatusLabelEx label = null;
        label = scoutObject != null && scoutObject.getLabelPosition() == 4 ? new StatusLabelTop(parent, style) : new StatusLabelEx(parent, style);
        this.adapt((Control)label, false, false);
        return label;
    }

    public StyledText createStyledText(Composite parent, int style) {
        StyledTextEx text = new StyledTextEx(parent, style);
        this.adapt((Control)text, false, false);
        return text;
    }

    public CTabFolder createTabFolder(Composite parent, int style) {
        CTabFolder folder = new CTabFolder(parent, style);
        this.adapt((Control)folder, false, false);
        return folder;
    }

    public Text createText(Composite container, int style) {
        TextEx t = new TextEx(container, style);
        this.adapt((Control)t, false, false);
        return t;
    }

    public SectionContent createSectionClient(Composite parent) {
        SectionContent client = new SectionContent(parent, 0);
        this.adapt((Control)client, false, false);
        return client;
    }

    public ButtonEx createButtonEx(Composite parent, int style) {
        ButtonEx button = new ButtonEx(parent, style | this.kit.getOrientation());
        this.adapt((Control)button, false, false);
        return button;
    }

    public IconCssStyledButton createIconCssStyledButton(Composite parent, int style) {
        IconCssStyledButton button = new IconCssStyledButton(parent, style | this.kit.getOrientation());
        this.adapt((Control)button, false, false);
        return button;
    }

    public DropDownButton createDropDownButton(Composite parent, int style) {
        DropDownButton button = new DropDownButton(parent, style | this.kit.getOrientation());
        this.adapt((Control)button, false, false);
        return button;
    }

    public DropDownFileUpload createDropDownFileUpload(Composite parent, int style) {
        DropDownFileUpload fileUpload = new DropDownFileUpload(parent, style | this.kit.getOrientation());
        this.adapt((Control)fileUpload, false, false);
        return fileUpload;
    }

    public Canvas createCanvas(Composite container) {
        Canvas c = new Canvas(container, 0);
        this.adapt((Control)c, false, false);
        return c;
    }

    public Browser createBrowser(Composite container, int style) {
        Browser browser = new Browser(container, style);
        this.adapt((Control)browser, false, false);
        return browser;
    }

    public SnapButtonMaximized createSnapButtonMaximized(Composite parent) {
        SnapButtonMaximized button = new SnapButtonMaximized(parent, 0);
        this.adapt((Composite)button);
        return button;
    }

    public SashForm createSashForm(Composite parent, int style) {
        SashForm button = new SashForm(parent, style);
        this.adapt((Composite)button);
        return button;
    }

    public CLabelEx createCLabel(Composite parent, String text) {
        return this.createCLabel(parent, text, 0);
    }

    public CLabelEx createCLabel(Composite parent, String text, int style) {
        CLabelEx label = new CLabelEx(parent, style | this.getOrientation());
        if (text != null) {
            label.setText(text);
        }
        this.adapt((Control)label, false, false);
        return label;
    }

    public ImageViewer createImageViewer(Composite container) {
        ImageViewer viewer = new ImageViewer(container);
        this.adapt((Control)viewer, false, false);
        return viewer;
    }

    @Override
    public HyperlinkEx createHyperlink(Composite parent, String text, int style) {
        HyperlinkEx hyperlink = new HyperlinkEx(parent, style | this.getOrientation());
        if (text != null) {
            hyperlink.setText(text);
        }
        this.getHyperlinkGroup().add((Hyperlink)hyperlink);
        this.adapt((Composite)hyperlink);
        return hyperlink;
    }

    private class P_HyperlinkKeyListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_HyperlinkKeyListener() {
        }

        public void handleEvent(Event event) {
        }
    }
}

