/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.action.RwtScoutToolbarAction;
import org.eclipse.scout.rt.ui.rap.window.IRwtScoutPart;
import org.eclipse.ui.forms.widgets.Form;

public abstract class AbstractRwtScoutPart
implements IRwtScoutPart {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractRwtScoutPart.class);
    private IForm m_scoutForm;
    private IRwtEnvironment m_uiEnvironment;
    private boolean m_opened;
    private PropertyChangeListener m_formPropertyListener;
    private DesktopListener m_desktopListener;

    @Override
    public void setBusy(boolean b) {
    }

    protected void createPart(IForm scoutForm, IRwtEnvironment uiEnvironment) {
        if (this.m_scoutForm != null) {
            throw new IllegalArgumentException("The form dialog is already open. The form '" + scoutForm.getTitle() + " (" + scoutForm.getClass().getName() + ")' can not be opened!");
        }
        this.m_scoutForm = scoutForm;
        this.m_uiEnvironment = uiEnvironment;
        this.m_formPropertyListener = new P_ScoutPropertyChangeListener();
        this.m_desktopListener = new P_ScoutDesktopListener();
        IDesktop desktop = this.getUiEnvironment().getScoutDesktop();
        if (desktop != null) {
            desktop.addDesktopListener(this.m_desktopListener);
        }
    }

    @Override
    public final void showPart() {
        if (this.m_opened) {
            return;
        }
        this.m_opened = true;
        this.showPartImpl();
    }

    protected abstract void showPartImpl();

    @Override
    public final void closePart() {
        if (!this.m_opened) {
            return;
        }
        this.m_opened = false;
        IDesktop desktop = this.getUiEnvironment().getScoutDesktop();
        if (desktop != null) {
            desktop.removeDesktopListener(this.m_desktopListener);
        }
        this.closePartImpl();
    }

    protected abstract void closePartImpl();

    @Override
    public IForm getScoutObject() {
        return this.m_scoutForm;
    }

    protected IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    protected void attachScout() {
        this.updateToolbarActionsFromScout();
        IForm form = this.getScoutObject();
        form.addPropertyChangeListener(this.m_formPropertyListener);
        this.setTitleFromScout();
        this.setImageFromScout();
        this.setMaximizeEnabledFromScout();
        this.setMaximizedFromScout();
        this.setMinimizeEnabledFromScout();
        this.setMinimizedFromScout();
        boolean closable = false;
        for (IFormField f : form.getAllFields()) {
            if (f.isEnabled() && f.isVisible() && f instanceof IButton) {
                switch (((IButton)f).getSystemType()) {
                    case 1: 
                    case 2: {
                        closable = true;
                    }
                }
            }
            if (closable) break;
        }
        this.setCloseEnabledFromScout(closable);
    }

    protected void updateToolbarActionsFromScout() {
        Form uiForm = this.getUiForm();
        if (uiForm == null) {
            return;
        }
        List toolbuttons = ActionUtility.visibleNormalizedActions((List)this.getScoutObject().getToolButtons());
        if (!toolbuttons.isEmpty()) {
            IToolBarManager toolBarManager = uiForm.getToolBarManager();
            for (IToolButton b : toolbuttons) {
                toolBarManager.add((org.eclipse.jface.action.IAction)new RwtScoutToolbarAction((IAction)b, toolBarManager, this.getUiEnvironment()));
            }
            toolBarManager.update(true);
        }
    }

    protected void detachScout() {
        this.getScoutObject().removePropertyChangeListener(this.m_formPropertyListener);
    }

    protected void setTitleFromScout() {
    }

    protected void setImageFromScout() {
    }

    protected void setMaximizeEnabledFromScout() {
    }

    protected void setMaximizedFromScout() {
    }

    protected void setMinimizeEnabledFromScout() {
    }

    protected void setMinimizedFromScout() {
    }

    protected void setCloseEnabledFromScout(boolean defaultValue) {
    }

    protected void ensureFormVisible() {
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("title")) {
            this.setTitleFromScout();
        } else if (name.equals("iconId")) {
            this.setImageFromScout();
        } else if (name.equals("minimizeEnabled")) {
            this.setMinimizeEnabledFromScout();
        } else if (name.equals("maximizeEnabled")) {
            this.setMaximizeEnabledFromScout();
        } else if (name.equals("minimized")) {
            this.setMinimizedFromScout();
        } else if (name.equals("maximized")) {
            this.setMaximizedFromScout();
        }
    }

    private void handleDesktopChangedUiThread(DesktopEvent e) {
        switch (e.getType()) {
            case 610: {
                IDesktop desktop = e.getDesktop();
                desktop.removeDesktopListener(this.m_desktopListener);
                try {
                    this.closePart();
                }
                catch (Throwable ex) {
                    LOG.warn("could not close part.", ex);
                }
                break;
            }
            case 620: {
                this.ensureFormVisible();
            }
        }
    }

    private class P_ScoutDesktopListener
    implements DesktopListener {
        private P_ScoutDesktopListener() {
        }

        public void desktopChanged(final DesktopEvent e) {
            if (AbstractRwtScoutPart.this.getUiEnvironment().getDisplay() != null && !AbstractRwtScoutPart.this.getUiEnvironment().getDisplay().isDisposed() && e.getForm() == AbstractRwtScoutPart.this.getScoutObject()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        AbstractRwtScoutPart.this.handleDesktopChangedUiThread(e);
                    }
                };
                AbstractRwtScoutPart.this.getUiEnvironment().invokeUiLater(t);
            }
        }
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            if (AbstractRwtScoutPart.this.getUiEnvironment().getDisplay() != null && !AbstractRwtScoutPart.this.getUiEnvironment().getDisplay().isDisposed()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        AbstractRwtScoutPart.this.handleScoutPropertyChange(e.getPropertyName(), e.getNewValue());
                    }
                };
                AbstractRwtScoutPart.this.getUiEnvironment().invokeUiLater(t);
            }
        }
    }
}

