/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.IUiLayer;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.extension.ISwingApplicationExtension;

public abstract class AbstractSwingApplicationExtension
implements ISwingApplicationExtension {
    private String m_extensionId;
    private IClientSession m_clientSession;
    private ISwingEnvironment m_environment;

    public AbstractSwingApplicationExtension(String extensionId) {
        this.m_extensionId = extensionId;
    }

    @Override
    public String getExtensionId() {
        return this.m_extensionId;
    }

    @Override
    public void initializeSwing() {
        this.m_environment = this.createEnvironment();
    }

    private UserAgent getUserAgent() {
        return UserAgent.create((IUiLayer)UiLayer.SWING, (IUiDeviceType)UiDeviceType.DESKTOP);
    }

    protected abstract IClientSession createClientSession(UserAgent var1);

    protected abstract ISwingEnvironment createEnvironment();

    @Override
    public Object execStart(IApplicationContext context, IProgressMonitor progressMonitor) throws Exception {
        return null;
    }

    @Override
    public Object execStartInSubject(IApplicationContext context, IProgressMonitor progressMonitor) throws Exception {
        this.m_clientSession = this.createClientSession(this.getUserAgent());
        return null;
    }

    @Override
    public IClientSession getClientSession() {
        return this.m_clientSession;
    }

    @Override
    public IDesktop getDesktop() {
        return this.m_clientSession.getDesktop();
    }

    @Override
    public ISwingEnvironment getEnvironment() {
        return this.m_environment;
    }
}

