/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.action;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.ISwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;

public class SwingScoutAction<T extends IAction>
extends SwingScoutComposite<T>
implements ISwingScoutAction<T> {
    private Action m_swingAction;
    private boolean m_handleActionPending;

    public static void registerCompositeOnAction(Action a, ISwingScoutComposite ui) {
        if (a != null) {
            a.putValue("ISwingScoutComposite", new WeakReference<ISwingScoutComposite>(ui));
        }
    }

    public static ISwingScoutComposite getCompositeOnAction(Action a) {
        if (a != null) {
            WeakReference ref = (WeakReference)a.getValue("ISwingScoutComposite");
            return ref != null ? (ISwingScoutComposite)ref.get() : null;
        }
        return null;
    }

    public static IPropertyObserver getScoutModelOnAction(Action a) {
        ISwingScoutComposite ui = SwingScoutAction.getCompositeOnAction(a);
        if (ui != null) {
            return ui.getScoutObject();
        }
        return null;
    }

    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        IAction scoutAction = (IAction)this.getScoutObject();
        this.m_swingAction = new P_SwingAction(SwingScoutAction.cleanupString(scoutAction.getText()));
    }

    public void reInitializeAction() {
        this.connectToScout();
    }

    public void disposeAction() {
        this.disconnectFromScout();
    }

    @Override
    public Action getSwingAction() {
        return this.m_swingAction;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IAction scoutAction = (IAction)this.getScoutObject();
        this.setEnabledFromScout(scoutAction.isEnabled());
        this.setVisibleFromScout(scoutAction.isVisible());
        this.setTextFromScout(scoutAction.getText());
        this.setTooltipTextFromScout(scoutAction.getTooltipText());
        this.setMnemonicFromScout(scoutAction.getMnemonic());
        this.setKeyStrokeFromScout(scoutAction.getKeyStroke());
        this.setIconFromScout(scoutAction.getIconId());
    }

    private void setEnabledFromScout(boolean b) {
        this.getSwingAction().setEnabled(b);
    }

    private void setVisibleFromScout(boolean b) {
        this.getSwingAction().putValue("visible", b ? Boolean.TRUE : Boolean.FALSE);
    }

    private void setTextFromScout(String s) {
        this.getSwingAction().putValue("Name", SwingScoutAction.cleanupString(s));
    }

    private void setKeyStrokeFromScout(String s) {
        if (s != null) {
            this.getSwingAction().putValue("AcceleratorKey", SwingUtility.createKeystroke((IKeyStroke)new KeyStroke(s)));
        } else {
            this.getSwingAction().putValue("AcceleratorKey", null);
        }
    }

    private void setTooltipTextFromScout(String s) {
        this.getSwingAction().putValue("ShortDescription", s);
    }

    private void setMnemonicFromScout(char ch) {
        if (ch != '\u0000') {
            ch = Character.toUpperCase(ch);
            this.getSwingAction().putValue("MnemonicKey", new Integer(ch));
        }
    }

    private void setIconFromScout(String id) {
        this.getSwingAction().putValue("SmallIcon", this.getSwingEnvironment().getIcon(id));
    }

    private static String cleanupString(String s) {
        if (s != null) {
            return s.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ');
        }
        return s;
    }

    private void handleSwingAction() {
        if (SwingUtility.runInputVerifier() && !this.m_handleActionPending) {
            this.m_handleActionPending = true;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        ((IAction)SwingScoutAction.this.getScoutObject()).getUIFacade().fireActionFromUI();
                    }
                    finally {
                        SwingScoutAction.this.m_handleActionPending = false;
                    }
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("enabled")) {
            this.setEnabledFromScout((Boolean)newValue);
        } else if (name.equals("visible")) {
            this.setVisibleFromScout((Boolean)newValue);
        } else if (name.equals("text")) {
            this.setTextFromScout((String)newValue);
        } else if (name.equals("tooltipText")) {
            this.setTooltipTextFromScout((String)newValue);
        } else if (name.equals("mnemonic")) {
            this.setMnemonicFromScout(((Character)newValue).charValue());
        } else if (name.equals("keystroke")) {
            this.setKeyStrokeFromScout((String)newValue);
        } else if (name.equals("iconId")) {
            this.setIconFromScout((String)newValue);
        }
    }

    private class P_SwingAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public P_SwingAction(String name) {
            super(name);
            SwingScoutAction.registerCompositeOnAction(this, SwingScoutAction.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutAction.this.handleSwingAction();
        }
    }
}

