/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;

public class SwingScoutCheckBoxMenu<T extends IMenu>
extends SwingScoutComposite<T>
implements ISwingScoutAction<T> {
    private SwingScoutAction<T> m_actionComposite;

    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        this.m_actionComposite = new SwingScoutAction();
        this.m_actionComposite.createField((IMenu)this.getScoutObject(), this.getSwingEnvironment());
        JCheckBoxMenuItem swingItem = new JCheckBoxMenuItem(this.m_actionComposite.getSwingAction());
        swingItem.setOpaque(false);
        this.setSwingField(swingItem);
        swingItem.setVisible(((IMenu)this.getScoutObject()).isVisible());
        this.m_actionComposite.getSwingAction().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                JCheckBoxMenuItem c;
                if ("visible".equals(e.getPropertyName()) && (c = SwingScoutCheckBoxMenu.this.getSwingField()) != null) {
                    c.setVisible((Boolean)e.getNewValue());
                }
            }
        });
    }

    @Override
    protected void handleSwingRemoveNotify() {
        super.handleSwingRemoveNotify();
        this.m_actionComposite.disposeAction();
    }

    @Override
    public JCheckBoxMenuItem getSwingField() {
        return (JCheckBoxMenuItem)super.getSwingField();
    }

    @Override
    public Action getSwingAction() {
        return this.m_actionComposite.getSwingAction();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IMenu scoutAction = (IMenu)this.getScoutObject();
        this.setSelectedFromScout(scoutAction.isSelected());
    }

    private void setSelectedFromScout(boolean b) {
        this.getSwingField().setSelected(b);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("selected")) {
            this.setSelectedFromScout((Boolean)newValue);
        }
    }
}

