/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic;

import java.awt.Color;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class ColorUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ColorUtility.class);

    private ColorUtility() {
    }

    public static Color darker(Color color, float ratio) {
        return ColorUtility.mergeColors(Color.BLACK, ratio, color, 1.0f - ratio);
    }

    public static Color lighter(Color color, float ratio) {
        return ColorUtility.mergeColors(Color.WHITE, ratio, color, 1.0f - ratio);
    }

    public static Color mergeColors(Color a, float fa, Color b, float fb) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new Color((fa * (float)a.getRed() + fb * (float)b.getRed()) / (fa + fb) / 255.0f, (fa * (float)a.getGreen() + fb * (float)b.getGreen()) / (fa + fb) / 255.0f, (fa * (float)a.getBlue() + fb * (float)b.getBlue()) / (fa + fb) / 255.0f);
    }

    public static Color multiplyColors(Color color1, Color color2) {
        if (color1 == null) {
            return color2;
        }
        if (color2 == null) {
            return color1;
        }
        int redHigh = Math.max(color1.getRed(), color2.getRed());
        int redLow = Math.min(color1.getRed(), color2.getRed());
        int greenHigh = Math.max(color1.getGreen(), color2.getGreen());
        int greenLow = Math.min(color1.getGreen(), color2.getGreen());
        int blueHigh = Math.max(color1.getBlue(), color2.getBlue());
        int blueLow = Math.min(color1.getBlue(), color2.getBlue());
        return new Color(Math.round((float)redHigh / 255.0f * (float)redLow), Math.round((float)greenHigh / 255.0f * (float)greenLow), Math.round((float)blueHigh / 255.0f * (float)blueLow));
    }

    public static Color createColor(String c) {
        if (StringUtility.isNullOrEmpty((String)c)) {
            return null;
        }
        c = c.replaceAll("^(0x|0X|#)", "");
        try {
            return new Color(Integer.parseInt(c, 16));
        }
        catch (NumberFormatException nfe) {
            LOG.warn("invalid color code: " + c, (Throwable)nfe);
            return null;
        }
    }

    public static String createStringFromColor(Color c) {
        if (c == null) {
            return null;
        }
        return org.eclipse.scout.commons.ColorUtility.rgbToText((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
    }
}

