/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.activitymap;

import org.eclipse.scout.rt.client.ui.basic.activitymap.MajorTimeColumn;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MinorTimeColumn;
import org.eclipse.scout.rt.client.ui.basic.activitymap.TimeScale;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityMapColumnModel;

public class SwingActivityMapColumnModel
implements ActivityMapColumnModel {
    private TimeScale m_scale;

    public SwingActivityMapColumnModel(TimeScale scale) {
        this.m_scale = scale;
    }

    @Override
    public Object[] getMajorColumns() {
        return this.m_scale.getMajorTimeColumns();
    }

    @Override
    public String getMajorColumnText(Object column, int size) {
        MajorTimeColumn m = (MajorTimeColumn)column;
        switch (size) {
            case 0: {
                return m.getSmallText();
            }
            case 1: {
                return m.getMediumText();
            }
            case 2: {
                return m.getLargeText();
            }
        }
        return null;
    }

    @Override
    public String getMajorColumnTooltipText(Object column) {
        MajorTimeColumn m = (MajorTimeColumn)column;
        return m.getTooltipText();
    }

    @Override
    public double[] getMajorColumnRange(Object majorColumn) {
        return this.m_scale.getRangeOf((MajorTimeColumn)majorColumn);
    }

    @Override
    public Object[] getMinorColumns(Object majorColumn) {
        MajorTimeColumn m = (MajorTimeColumn)majorColumn;
        return m.getMinorTimeColumns();
    }

    @Override
    public String getMinorColumnText(Object column, int size) {
        MinorTimeColumn m = (MinorTimeColumn)column;
        switch (size) {
            case 0: {
                return m.getSmallText();
            }
            case 1: {
                return m.getMediumText();
            }
            case 2: {
                return m.getLargeText();
            }
        }
        return null;
    }

    @Override
    public String getMinorColumnTooltipText(Object column) {
        MinorTimeColumn m = (MinorTimeColumn)column;
        return m.getTooltipText();
    }

    @Override
    public double[] getMinorColumnRange(Object minorColumn) {
        return this.m_scale.getRangeOf((MinorTimeColumn)minorColumn);
    }

    @Override
    public double[] snapRange(double d) {
        return this.m_scale.snapRange(d);
    }
}

