/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.document;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class BasicDocumentFilter
extends DocumentFilter {
    private static final long serialVersionUID = 1L;
    private int m_maxLen;

    public BasicDocumentFilter() {
    }

    public BasicDocumentFilter(int maxLength) {
        this.m_maxLen = maxLength;
    }

    public int getMaxLength() {
        return this.m_maxLen;
    }

    public void setMaxLength(int maxLen) {
        this.m_maxLen = maxLen;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String s, AttributeSet a) throws BadLocationException {
        if (s == null) {
            s = "";
        }
        this.checkStringTooLong(fb, s, fb.getDocument().getLength() + s.length());
        fb.insertString(offset, s, a);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String s, AttributeSet a) throws BadLocationException {
        if (s == null) {
            s = "";
        }
        this.checkStringTooLong(fb, s, fb.getDocument().getLength() + s.length() - length);
        fb.replace(offset, length, s, a);
    }

    protected void checkStringTooLong(DocumentFilter.FilterBypass fb, String s, int newLen) throws BadLocationException {
        if (this.m_maxLen > 0 && newLen > this.m_maxLen) {
            s = this.handleStringTooLong(s, Math.max(0, s.length() - (newLen - this.m_maxLen)));
        }
    }

    protected String handleStringTooLong(String s, int availableLength) throws BadLocationException {
        if (SwingUtility.isPasteAction() || SwingUtility.isSunDropAction()) {
            SwingUtility.showMessageDialogSynthCapable(SwingUtility.getOwnerForChildWindow(), SwingUtility.getNlsText("PasteTextTooLongForFieldX", "" + this.getMaxLength()), SwingUtility.getNlsText("Paste", new String[0]), 2);
        }
        s = s.substring(0, availableLength);
        return s;
    }
}

