/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.table;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import org.eclipse.scout.rt.ui.swing.basic.AbstractHtmlLinkDetector;

public class TableHtmlLinkDetector
extends AbstractHtmlLinkDetector<JTable> {
    private int m_rowIndex = -1;
    private int m_columnIndex = -1;

    @Override
    public boolean detect(JTable table, Point p) {
        boolean found = super.detect(table, p);
        if (found) {
            this.m_rowIndex = this.getRow(p);
            this.m_columnIndex = this.getColumn(p);
        } else {
            this.m_rowIndex = -1;
            this.m_columnIndex = -1;
        }
        return found;
    }

    @Override
    protected Rectangle getCellRectangle(Point p) {
        return ((JTable)this.getContainer()).getCellRect(this.getRow(p), this.getColumn(p), false);
    }

    @Override
    protected Component getComponent(Point p) {
        int row = this.getRow(p);
        int col = this.getColumn(p);
        Component c = ((JTable)this.getContainer()).prepareRenderer(((JTable)this.getContainer()).getCellRenderer(row, col), row, col);
        return c;
    }

    private int getRow(Point p) {
        return ((JTable)this.getContainer()).rowAtPoint(p);
    }

    private int getColumn(Point p) {
        return ((JTable)this.getContainer()).columnAtPoint(p);
    }

    public int getRowIndex() {
        return this.m_rowIndex;
    }

    public int getColumnIndex() {
        return this.m_columnIndex;
    }
}

