/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.basic.tree.SwingScoutTree;
import org.eclipse.scout.rt.ui.swing.icons.CheckboxIcon;
import org.eclipse.scout.rt.ui.swing.icons.CompositeIcon;

public class SwingTreeCellRenderer
implements TreeCellRenderer {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingTreeCellRenderer.class);
    private static final long serialVersionUID = 1L;
    private final ISwingEnvironment m_env;
    private TreeCellRenderer m_internalRenderer;
    private SwingScoutTree m_swingScoutTree;

    public SwingTreeCellRenderer(ISwingEnvironment env, TreeCellRenderer internalRenderer, SwingScoutTree swingScoutTree) {
        this.m_env = env;
        this.m_internalRenderer = internalRenderer;
        this.m_swingScoutTree = swingScoutTree;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int rowIndex, boolean focused) {
        Color color;
        JLabel label;
        if (this.m_internalRenderer instanceof JComponent) {
            JComponent j = (JComponent)((Object)this.m_internalRenderer);
            j.setBackground(tree.getBackground());
            j.setForeground(tree.getForeground());
            j.setFont(tree.getFont());
        }
        ITree scoutTree = (ITree)this.m_swingScoutTree.getScoutObject();
        ITreeNode node = (ITreeNode)value;
        ICell cell = node.getCell();
        Component comp = this.m_internalRenderer.getTreeCellRendererComponent(tree, cell.getText(), selected, expanded, leaf, rowIndex, focused);
        JLabel jLabel = label = comp instanceof JLabel ? (JLabel)comp : null;
        if (label == null) {
            return comp;
        }
        label.setEnabled(scoutTree.isEnabled() && node.isEnabled() && cell.isEnabled());
        String iconName = cell.getIconId();
        CheckboxIcon checkboxIcon = null;
        if (scoutTree != null && scoutTree.isCheckable()) {
            checkboxIcon = this.m_env.createCheckboxWithMarginIcon(new Insets(0, 0, 0, 5));
            checkboxIcon.setSelected(node.isChecked());
            checkboxIcon.setEnabled(label.isEnabled());
        }
        Icon decoIcon = null;
        if (iconName != null) {
            if (expanded) {
                decoIcon = this.m_env.getIcon(String.valueOf(iconName) + "_open");
            }
            if (decoIcon == null) {
                decoIcon = this.m_env.getIcon(iconName);
            }
        }
        Icon icon = null;
        if (checkboxIcon != null && decoIcon != null) {
            icon = new CompositeIcon(0, checkboxIcon, decoIcon);
        } else if (checkboxIcon != null) {
            icon = checkboxIcon;
        } else if (decoIcon != null) {
            icon = decoIcon;
        }
        label.setIcon(icon);
        label.setDisabledIcon(label.getIcon());
        String s = cell.getTooltipText();
        s = SwingUtility.createHtmlLabelText(s, true);
        label.setToolTipText(s);
        if (cell.getBackgroundColor() != null) {
            color = ColorUtility.createColor(cell.getBackgroundColor());
            if (selected) {
                color = color.darker();
            }
            label.setBackground(color);
        }
        if (cell.getForegroundColor() != null) {
            color = ColorUtility.createColor(cell.getForegroundColor());
            if (selected) {
                color = color.brighter();
            }
            label.setForeground(color);
        }
        if (cell.getFont() != null) {
            Font oldf = label.getFont();
            Font newf = SwingUtility.createFont(cell.getFont(), oldf);
            if (oldf != null) {
                label.setFont(new Font(oldf.getName(), newf != null ? newf.getStyle() : oldf.getStyle(), oldf.getSize()));
            }
        }
        return label;
    }
}

