/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.ui.swing.basic.tree.SwingScoutTree;

public class SwingTreeModel
implements TreeModel {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingTreeModel.class);
    private EventListenerList m_listenerList = new EventListenerList();
    private SwingScoutTree m_swingScoutTree;
    private WeakHashMap<Object, List<ITreeNode>> m_childMap;
    private WeakHashMap<Object, Integer> m_childIndexMap;

    public SwingTreeModel(SwingScoutTree swingScoutTree) {
        this.m_swingScoutTree = swingScoutTree;
        this.clearCache();
    }

    private void clearCache() {
        this.m_childMap = new WeakHashMap();
        this.m_childIndexMap = new WeakHashMap();
    }

    private List<ITreeNode> getCachedChildren(ITreeNode parent) {
        List children = this.m_childMap.get(parent);
        if (!CollectionUtility.hasElements(children)) {
            ITreeNode scoutNode = parent;
            children = scoutNode.getFilteredChildNodes();
            this.m_childMap.put(parent, children);
            int i = 0;
            while (i < children.size()) {
                this.m_childIndexMap.put(children.get(i), i);
                ++i;
            }
        }
        return CollectionUtility.arrayList(children);
    }

    private int getCachedChildIndex(ITreeNode parent, ITreeNode child) {
        this.getCachedChildren(parent);
        Integer index = this.m_childIndexMap.get(child);
        return index != null ? index : -1;
    }

    public void notifyScoutModelChanged() {
        this.fireStructureChanged((ITreeNode)this.getRoot());
    }

    @Override
    public boolean isLeaf(Object node) {
        ITreeNode scoutNode = (ITreeNode)node;
        return scoutNode.isLeaf();
    }

    @Override
    public Object getRoot() {
        ITreeNode root = null;
        if (this.m_swingScoutTree.getScoutObject() != null) {
            root = ((ITree)this.m_swingScoutTree.getScoutObject()).getRootNode();
        }
        return root;
    }

    @Override
    public int getChildCount(Object parent) {
        List<ITreeNode> cachedChildren = this.getCachedChildren((ITreeNode)parent);
        if (cachedChildren != null) {
            return cachedChildren.size();
        }
        return 0;
    }

    @Override
    public Object getChild(Object parent, int index) {
        List<ITreeNode> cachedChildren = this.getCachedChildren((ITreeNode)parent);
        if (cachedChildren != null && cachedChildren.size() > index) {
            return cachedChildren.get(index);
        }
        return null;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.getCachedChildIndex((ITreeNode)parent, (ITreeNode)child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.m_listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.m_listenerList.remove(TreeModelListener.class, l);
    }

    protected void fireTreeNodesChanged(ITreeNode scoutParent, List<ITreeNode> scoutChildren) {
        this.clearCache();
        EventListener[] listeners = this.m_listenerList.getListeners(TreeModelListener.class);
        if (listeners != null && listeners.length > 0) {
            TreeModelEvent e = new TreeModelEvent((Object)this, SwingScoutTree.scoutNodeToTreePath(scoutParent), this.scoutNodesToSwingIndexes(scoutParent, scoutChildren), scoutChildren != null ? scoutChildren.toArray() : null);
            int i = 0;
            while (i < listeners.length) {
                ((TreeModelListener)listeners[i]).treeNodesChanged(e);
                ++i;
            }
        }
    }

    protected void fireTreeNodesInserted(ITreeNode scoutParent, List<ITreeNode> scoutChildren) {
        this.clearCache();
        EventListener[] listeners = this.m_listenerList.getListeners(TreeModelListener.class);
        if (listeners != null && listeners.length > 0) {
            TreeModelEvent e = new TreeModelEvent((Object)this, SwingScoutTree.scoutNodeToTreePath(scoutParent), this.scoutNodesToSwingIndexes(scoutParent, scoutChildren), scoutChildren.toArray());
            int i = 0;
            while (i < listeners.length) {
                ((TreeModelListener)listeners[i]).treeNodesInserted(e);
                ++i;
            }
        }
    }

    protected void fireTreeNodesRemoved(ITreeNode scoutParent, List<ITreeNode> scoutChildren) {
        this.clearCache();
        EventListener[] listeners = this.m_listenerList.getListeners(TreeModelListener.class);
        if (listeners != null && listeners.length > 0) {
            TreeModelEvent e = new TreeModelEvent((Object)this, SwingScoutTree.scoutNodeToTreePath(scoutParent), this.scoutNodesToSwingIndexes(scoutParent, scoutChildren), scoutChildren.toArray());
            int i = 0;
            while (i < listeners.length) {
                ((TreeModelListener)listeners[i]).treeNodesRemoved(e);
                ++i;
            }
        }
    }

    protected void fireStructureChanged(ITreeNode scoutParent) {
        this.clearCache();
        EventListener[] listeners = this.m_listenerList.getListeners(TreeModelListener.class);
        if (listeners != null && listeners.length > 0) {
            TreeModelEvent e = new TreeModelEvent((Object)this, SwingScoutTree.scoutNodeToTreePath(scoutParent));
            int i = 0;
            while (i < listeners.length) {
                ((TreeModelListener)listeners[i]).treeStructureChanged(e);
                ++i;
            }
        }
    }

    public int[] scoutNodesToSwingIndexes(ITreeNode scoutParent, List<ITreeNode> scoutChildren) {
        if (!CollectionUtility.hasElements(scoutChildren)) {
            return new int[0];
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>(scoutChildren.size());
        for (ITreeNode scoutChild : scoutChildren) {
            int i = this.getCachedChildIndex(scoutParent, scoutChild);
            if (i < 0) continue;
            indexList.add(i);
        }
        int[] a = new int[indexList.size()];
        int i = 0;
        while (i < a.length) {
            a[i] = (Integer)indexList.get(i);
            ++i;
        }
        Arrays.sort(a);
        return a;
    }

    public void updateNode(ITreeNode node) {
        if (node != null) {
            if (node.getParentNode() == null) {
                this.fireTreeNodesChanged(node, null);
            } else {
                this.fireTreeNodesChanged(node.getParentNode(), CollectionUtility.arrayList((Object)node));
            }
        }
    }
}

